/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.raduga;

import java.sql.Statement;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.TagRepository;
import promauto.jroboplc.plugin.raduga.Context;
import promauto.jroboplc.plugin.raduga.DataService;
import promauto.jroboplc.plugin.raduga.DataServiceImpl;
import promauto.jroboplc.plugin.raduga.Line;
import promauto.jroboplc.plugin.raduga.LineCombo;
import promauto.jroboplc.plugin.raduga.LineSimple;
import promauto.jroboplc.plugin.raduga.RadugaPlugin;

public class RadugaModule
extends AbstractModule
implements Signal.Listener {
    private final Logger logger = LoggerFactory.getLogger(RadugaModule.class);
    public static final String DBSCR_RADUGA = "dbscr/dbscr.raduga.yml";
    public static final String RADUGA_INIT_1 = "raduga.init1";
    public static final String RADUGA_INIT_2 = "raduga.init2";
    public static final String TABLE_REPO = "RD_REPO";
    private TagRepository tagrepo;
    private Database database;
    private boolean needInit;
    private Context ctx = new Context();

    public RadugaModule(Plugin plugin, String name) {
        super(plugin, name);
        this.ctx.setModule(this);
        this.ctx.setDataService(new DataServiceImpl());
        this.ctx.setEnvironment(EnvironmentInst.get());
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.ctx.emulated = cm.get(conf, "emulate", false);
        this.ctx.databaseModuleName = cm.get(conf, "database", "db");
        this.ctx.deleteOtherStuff = cm.get(conf, "deleteOtherStuff", true);
        this.ctx.service.setArcSize(cm.get(conf, "shortRecs", 100000), cm.get(conf, "shortDays", 60), cm.get(conf, "longRecs", 1000000), cm.get(conf, "longDays", 3650));
        this.ctx.periods.load(conf);
        for (Object confLine : cm.toList(cm.get(conf, "lines"))) {
            LineSimple line;
            String type = cm.get(confLine, "type", "simple").toLowerCase();
            if (type.equals("simple")) {
                line = new LineSimple(this.ctx);
            } else if (type.equals("combo")) {
                line = new LineCombo(this.ctx);
            } else {
                this.env.printError(this.logger, this.name, "Unknown line type:", type);
                return false;
            }
            if (!line.load(confLine)) {
                return false;
            }
            this.ctx.lines.add(line);
        }
        this.ctx.tagConnected = this.tagtable.createBool("connected", false);
        return true;
    }

    @Override
    public final boolean prepareModule() {
        if (this.ctx.emulated) {
            return true;
        }
        this.database = this.env.getModuleManager().getModule(this.ctx.databaseModuleName, Database.class);
        if (this.database == null) {
            this.env.printError(this.logger, this.name, "Database not found:", this.ctx.databaseModuleName);
            return false;
        }
        this.database.addSignalListener(this);
        this.ctx.service.setDb(this.database);
        this.tagrepo = this.database.createTagRepository("", TABLE_REPO);
        boolean res = this.ctx.lines.stream().allMatch(Line::prepare);
        this.needInit = res &= this.database.loadScriptFromResource(RadugaPlugin.class, DBSCR_RADUGA) != null;
        return res;
    }

    @Override
    public void onSignal(JrModule sender, Signal signal) {
        if (signal.type == Signal.SignalType.CONNECTED && !this.ctx.tagConnected.getBool()) {
            this.needInit = true;
        }
        if (signal.type == Signal.SignalType.DISCONNECTED) {
            this.ctx.tagConnected.setBool(false);
        }
    }

    private void init() {
        boolean res;
        this.ctx.tagConnected.setBool(false);
        if (this.ctx.emulated || this.database == null || !this.database.isConnected()) {
            return;
        }
        boolean bl = res = this.database.executeScript((String)RADUGA_INIT_1).success && this.database.executeScript((String)RADUGA_INIT_2).success;
        if (res) {
            DataService svc = this.ctx.service;
            try (Statement st = svc.createStatement();){
                svc.startSync();
                res = this.tagrepo.init();
                for (Line line : this.ctx.lines) {
                    res &= line.init();
                }
                if (res) {
                    this.tagrepo.load(this.name, this.ctx.repoTags);
                }
                svc.finishSync(this.ctx.deleteOtherStuff);
                svc.commit();
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                svc.rollback();
            }
        }
        if (!res) {
            this.env.printError(this.logger, this.name, "Initialization error");
        }
        this.ctx.tagConnected.setBool(res);
        this.needInit = false;
    }

    @Override
    public boolean executeModule() {
        if (this.ctx.emulated) {
            this.tagtable.acceptWriteValues();
            return true;
        }
        if (this.database == null || !this.database.isConnected()) {
            return true;
        }
        if (this.needInit) {
            this.init();
        }
        if (this.ctx.tagConnected.getBool()) {
            try (Statement st = this.ctx.service.createStatement();){
                for (Line line : this.ctx.lines) {
                    line.execute();
                }
                this.tagrepo.save(this.name, this.ctx.repoTags);
                this.tagrepo.persist();
                this.ctx.service.commit();
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name, ", Last sql =", this.ctx.service.getLastSql());
                this.ctx.service.rollback();
                this.ctx.tagConnected.setBool(false);
                this.needInit = true;
            }
        }
        return true;
    }

    @Override
    public boolean closedownModule() {
        this.ctx.tagConnected.setBool(false);
        if (this.database != null) {
            this.database.removeSignalListener(this);
        }
        return true;
    }

    @Override
    public String getInfo() {
        if (!this.enable) {
            return "disabled";
        }
        if (this.ctx.emulated) {
            return "emulated";
        }
        return String.format("%s%s, lines: %d %s\r\n", this.ctx.tagConnected.getBool() ? "" : ANSI.redBold("NOT CONNECTED! "), this.ctx.databaseModuleName, this.ctx.lines.size(), this.ctx.lines.stream().map(Line::getInfo).collect(Collectors.joining()));
    }

    @Override
    public String check() {
        return this.ctx.lines.stream().map(Line::check).filter(s -> !s.isEmpty()).collect(Collectors.joining("\r\n"));
    }

    @Override
    protected boolean reload() {
        RadugaModule tmp = new RadugaModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.closedown();
        this.copySettingsFrom(tmp);
        this.tagtable.copyValuesTo(tmp.tagtable);
        this.tagtable.removeAll();
        tmp.tagtable.moveTagsTo(this.tagtable);
        this.ctx = tmp.ctx;
        this.ctx.setModule(this);
        this.prepare();
        return true;
    }
}

