/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.plugin.roboplant.ChannelManager;
import promauto.jroboplc.plugin.roboplant.Comp;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Reloader;
import promauto.jroboplc.plugin.roboplant.RoboplantPlugin;

public class RoboplantModule
extends AbstractModule
implements Signal.Listener {
    protected String project;
    private boolean useDescr;
    private int descrFlags;
    protected Device[] devicesByAddr;
    protected Device[] devicesByOrder;
    protected int devicesByAddrCount = 0;
    protected ChannelManager channelManager = new ChannelManager(this);

    public RoboplantModule(RoboplantPlugin plugin, String name) {
        super(plugin, name);
    }

    public boolean isUseDescr() {
        return this.useDescr;
    }

    public int getDescrFlags() {
        return this.descrFlags;
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.project = cm.get(conf, "project", "");
        String s = cm.get(conf, "use.descr", cm.get(conf, "useDescr", ""));
        if (s.equals("hidden")) {
            this.useDescr = true;
            this.descrFlags = 2;
        } else {
            this.useDescr = Boolean.parseBoolean(s);
            this.descrFlags = 0;
        }
        Path prjfile = cm.getConfDir().resolve(this.project);
        ((RoboplantPlugin)this.plugin).getConnectManager().loadConnectors(this, conf);
        boolean res = false;
        if (this.loadProject(prjfile) && this.initDevices()) {
            res = true;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean loadProject(Path prjfile) {
        LinkedList<Device> devlist;
        boolean result;
        block39: {
            result = true;
            devlist = new LinkedList<Device>();
            XMLInputFactory xmlif = this.env.getXMLInputFactory();
            XMLStreamReader xmlr = null;
            try (InputStream prjstream = Files.newInputStream(prjfile, new OpenOption[0]);){
                xmlr = xmlif.createXMLStreamReader(prjstream);
                Device currentDevice = null;
                while (xmlr.hasNext()) {
                    int eventType = xmlr.next();
                    block9 : switch (eventType) {
                        case 1: {
                            String xmltag;
                            switch (xmltag = xmlr.getName().getLocalPart()) {
                                case "dev": {
                                    currentDevice = this.createDevice(xmlr, devlist);
                                    break block9;
                                }
                                case "comp": {
                                    this.createComp(xmlr, currentDevice);
                                }
                            }
                            break;
                        }
                        case 2: {
                            if (!xmlr.getName().getLocalPart().equals("dev") || currentDevice == null) break;
                            currentDevice = null;
                        }
                    }
                }
            }
            try {
                if (xmlr != null) {
                    xmlr.close();
                }
                break block39;
            }
            catch (XMLStreamException e) {
                this.env.printError(this.logger, e, this.name, "XML stream error");
                result = false;
            }
            break block39;
            catch (Exception e) {
                try {
                    this.env.printError(this.logger, e, this.name, prjfile.toString(), xmlr == null ? "" : "line: " + xmlr.getLocation().getLineNumber());
                    result = false;
                }
                catch (Throwable throwable) {
                    try {
                        if (xmlr != null) {
                            xmlr.close();
                        }
                    }
                    catch (XMLStreamException e2) {
                        this.env.printError(this.logger, e2, this.name, "XML stream error");
                        result = false;
                    }
                    throw throwable;
                }
                try {
                    if (xmlr != null) {
                        xmlr.close();
                    }
                }
                catch (XMLStreamException e3) {
                    this.env.printError(this.logger, e3, this.name, "XML stream error");
                    result = false;
                }
            }
        }
        Collections.sort(devlist);
        this.devicesByOrder = devlist.toArray(new Device[0]);
        this.copyToDevicesByAddr();
        return result;
    }

    private Device createDevice(XMLStreamReader xmlr, List<Device> devlist) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String devtype = xmlr.getAttributeValue("", "DevType");
        String className = Device.class.getName() + devtype;
        Device device = (Device)Class.forName(className).newInstance();
        devlist.add(device);
        int n = xmlr.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            device.setAttribute(xmlr.getAttributeName(i).toString(), xmlr.getAttributeValue(i));
        }
        return device;
    }

    private void createComp(XMLStreamReader xmlr, Device device) {
        boolean isVar;
        if (device == null) {
            return;
        }
        boolean isInp = xmlr.getAttributeValue("", "IsInp") != null;
        boolean bl = isVar = xmlr.getAttributeValue("", "IsVar") != null;
        if (isInp || isVar) {
            Comp comp = device.addComp(isInp);
            int n = xmlr.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                comp.setAttribute(xmlr.getAttributeName(i).toString(), xmlr.getAttributeValue(i));
            }
        }
    }

    private void copyToDevicesByAddr() {
        int max = -1;
        for (Device dev : this.devicesByOrder) {
            if (max >= dev.addr) continue;
            max = dev.addr;
        }
        this.devicesByAddr = new Device[max + 1];
        for (int i = 0; i < max; ++i) {
            this.devicesByAddr[i] = null;
        }
        Device[] deviceArray = this.devicesByOrder;
        int n = deviceArray.length;
        for (int i = 0; i < n; ++i) {
            Device dev;
            this.devicesByAddr[dev.addr] = dev = deviceArray[i];
        }
        this.devicesByAddrCount = this.devicesByAddr.length;
    }

    protected boolean initDevices() {
        for (Device dev : this.devicesByOrder) {
            if (dev.init(this)) continue;
            return false;
        }
        return true;
    }

    public Device getDevice(int addr) {
        if (addr >= 0 && addr < this.devicesByAddrCount) {
            return this.devicesByAddr[addr];
        }
        return null;
    }

    @Override
    public boolean prepareModule() {
        if (this.enable && this.devicesByOrder != null) {
            for (Device dev : this.devicesByOrder) {
                if (dev.prepare()) continue;
                return false;
            }
        }
        this.addAsSignalListerToAllOthers();
        return true;
    }

    @Override
    public boolean closedownModule() {
        this.removeAsSignalListerFromAllOthers();
        return true;
    }

    @Override
    public String getInfo() {
        return !this.enable ? "disabled" : String.format("devices=%d tags=%d prj=%s", this.devicesByOrder.length, this.tagtable.getSize(), this.project);
    }

    @Override
    protected boolean reload() {
        Reloader r = new Reloader(this);
        boolean res = r.reload();
        return res;
    }

    @Override
    public boolean executeModule() {
        this.channelManager.execute();
        boolean res = true;
        if (this.enable) {
            for (Device dev : this.devicesByOrder) {
                res &= dev.execute();
            }
        }
        return res;
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public void loadState(State state) {
        for (Device d : this.devicesByOrder) {
            d.loadState(state);
        }
    }

    @Override
    public void saveState(State state) {
        for (Device d : this.devicesByOrder) {
            d.saveState(state);
        }
    }

    @Override
    public String check() {
        String res = "";
        for (Device dev : this.devicesByOrder) {
            String check = dev.checkErrors();
            if (check.isEmpty()) continue;
            res = res + dev.devtype + '.' + dev.tagname + ": " + check + "\r\n";
        }
        return res;
    }

    @Override
    public void onSignal(JrModule sender, Signal signal) {
        if (signal.type == Signal.SignalType.RELOADED) {
            this.channelManager.refreshErrorForeignChannels();
        }
    }
}

