/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.SerialManager;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.plugin.serial.CmdDisable;
import promauto.jroboplc.plugin.serial.CmdEnable;
import promauto.jroboplc.plugin.serial.SerialPortDisabled;
import promauto.jroboplc.plugin.serial.SerialPortFinsUdp;
import promauto.jroboplc.plugin.serial.SerialPortLocal;
import promauto.jroboplc.plugin.serial.SerialPortModbusTcp;
import promauto.jroboplc.plugin.serial.SerialPortNPort;
import promauto.jroboplc.plugin.serial.SerialPortRfc2217;
import promauto.jroboplc.plugin.serial.SerialPortUsr;

public class SerialManagerModule
extends AbstractModule
implements SerialManager {
    private final Logger logger = LoggerFactory.getLogger(SerialManagerModule.class);
    protected HashMap<Integer, SerialPort> ports = new HashMap();
    private boolean opened = false;
    protected Path pathEnables;
    protected Map<Integer, Boolean> enables = new HashMap<Integer, Boolean>();

    public SerialManagerModule(Plugin plugin, String name) {
        super(plugin, name);
        this.taskable = false;
        this.env.getCmdDispatcher().addCommand(this, CmdEnable.class);
        this.env.getCmdDispatcher().addCommand(this, CmdDisable.class);
    }

    @Override
    public boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.enables.clear();
        this.pathEnables = cm.getPath(conf, "file.enable", this.getPlugin().getPluginName() + '.' + this.name + ".enable");
        this.loadEnables();
        for (Object portconf : cm.toList(cm.get(conf, "ports"))) {
            int port_id = cm.get(portconf, "id", 0);
            boolean port_enable = cm.get(portconf, "enable", true);
            String type = cm.get(portconf, "type", "jssc");
            Object port = null;
            if (this.enables.containsKey(port_id)) {
                if (port_enable == this.enables.get(port_id)) {
                    this.enables.remove(port_id);
                } else {
                    port_enable = this.enables.get(port_id);
                }
            }
            if (!this.enable || !port_enable) {
                Object portimpl = new SerialPortDisabled(this);
                port = ((SerialPortDisabled)portimpl).load(portconf) ? portimpl : null;
            } else {
                switch (type) {
                    case "jssc": 
                    case "local": {
                        SerialPortLocal portLocal = new SerialPortLocal(this);
                        port = portLocal.load(portconf) ? portLocal : null;
                        break;
                    }
                    case "nport": {
                        SerialPortNPort nport = new SerialPortNPort(this);
                        port = nport.load(portconf) ? nport : null;
                        break;
                    }
                    case "usr": 
                    case "usr410": 
                    case "usriot": {
                        SerialPortUsr usr = new SerialPortUsr(this);
                        port = usr.load(portconf) ? usr : null;
                        break;
                    }
                    case "modbustcp": {
                        SerialPortModbusTcp modbustcp = new SerialPortModbusTcp(this);
                        port = modbustcp.load(portconf) ? modbustcp : null;
                        break;
                    }
                    case "finsudp": {
                        SerialPortFinsUdp finsudp = new SerialPortFinsUdp(this);
                        port = finsudp.load(portconf) ? finsudp : null;
                        break;
                    }
                    case "telnet": 
                    case "rfc2217": {
                        SerialPortRfc2217 rfc2217 = new SerialPortRfc2217(this);
                        port = rfc2217.load(portconf) ? rfc2217 : null;
                        break;
                    }
                    default: {
                        this.env.printError(this.logger, this.name, "Unknown port type:", type);
                    }
                }
            }
            if (port == null) {
                return false;
            }
            int id = port.getId();
            if (this.ports.containsKey(id)) {
                this.env.printError(this.logger, this.name, "Duplicate port id:", "" + id);
                return false;
            }
            this.ports.put(id, (SerialPort)port);
        }
        return true;
    }

    protected void loadEnables() {
        if (Files.exists(this.pathEnables, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.pathEnables, Charset.defaultCharset());){
                String line;
                Pattern p = Pattern.compile("(\\d+)\\s*:\\s*(on|off)");
                while ((line = reader.readLine()) != null) {
                    Matcher m = p.matcher(line);
                    if (!m.find()) continue;
                    int port_id = Integer.parseInt(m.group(1));
                    boolean port_enabled = m.group(2).equals("on");
                    this.enables.put(port_id, port_enabled);
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
            }
        }
    }

    protected void saveEnables() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.pathEnables, Charset.defaultCharset(), new OpenOption[0]);){
            StringBuilder sb = new StringBuilder();
            this.enables.entrySet().stream().filter(e -> this.ports.containsKey(e.getKey())).forEach(e -> sb.append(e.getKey() + ":" + ((Boolean)e.getValue() != false ? "on" : "off") + "\r\n"));
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e2) {
            this.env.printError(this.logger, e2, this.name);
        }
    }

    @Override
    public boolean prepareModule() {
        this.openAll();
        return true;
    }

    @Override
    public boolean closedownModule() {
        this.closeAll();
        return true;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        for (SerialPort port : this.ports.values()) {
            sb.append(port.getInfo());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Override
    public synchronized SerialPort getPort(int portid) {
        return this.ports.get(portid);
    }

    public boolean openAll() {
        for (SerialPort port : this.ports.values()) {
            port.open();
        }
        this.opened = true;
        return true;
    }

    public void closeAll() {
        for (SerialPort port : this.ports.values()) {
            port.close();
        }
        this.opened = false;
    }

    @Override
    public synchronized boolean reload() {
        boolean canLoad = new SerialManagerModule(this.plugin, this.name).load();
        if (!canLoad) {
            return false;
        }
        if (this.opened) {
            this.closeAll();
        }
        HashMap<Integer, SerialPort> ports_old = this.ports;
        this.ports = new HashMap();
        if (this.load()) {
            for (SerialPort port : ports_old.values()) {
                port.setInvalid();
            }
            ports_old.clear();
            if (this.enable && this.env.isRunning()) {
                return this.openAll();
            }
            return true;
        }
        this.ports = ports_old;
        return false;
    }

    public TagRW getTagOpened(int portnum) {
        String tagname = portnum + ".opened";
        Tag tag = this.tagtable.get(tagname);
        if (tag == null) {
            return this.tagtable.createRWInt(tagname, 0);
        }
        return (TagRWInt)tag;
    }
}

