/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.SerialPort;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.serial.SerialManagerModule;

public class SerialPortNPort
implements SerialPort {
    final Logger logger = LoggerFactory.getLogger(SerialPortNPort.class);
    private static final Charset charset = Charset.forName("windows-1251");
    private Socket socketData;
    private Socket socketCmd;
    private InputStream inputData;
    private OutputStream outputData;
    private InputStream inputCmd;
    private OutputStream outputCmd;
    private volatile boolean valid = true;
    private volatile boolean opened = false;
    private String host;
    private int portData;
    private int portCmd;
    private InetSocketAddress addrData;
    private InetSocketAddress addrCmd;
    private static final int BUFFIN_SIZE = 2048;
    private byte[] buffin = new byte[2048];
    private byte[] buffcmd = new byte[10];
    private int id;
    private int baud;
    private int databits;
    private int parity;
    private int stopbits;
    private byte baudCode;
    private byte modeCode;
    private int timeout_ms;
    private boolean noTcpDelay;
    private boolean connectionLost = false;
    private long connectionLostTime = 0L;
    private long recon_ms = 3000L;
    private SerialManagerModule module;
    private TagRW tagOpened;

    public SerialPortNPort(SerialManagerModule module) {
        this.module = module;
    }

    public synchronized boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.id = cm.get(conf, "id", 0);
        this.baud = cm.get(conf, "baud", 9600);
        this.recon_ms = cm.get(conf, "recon_ms", 3000);
        this.timeout_ms = cm.get(conf, "timeout", 200);
        this.noTcpDelay = cm.get(conf, "no_tcpdelay", true);
        this.tagOpened = this.module.getTagOpened(this.id);
        this.host = cm.get(conf, "host", "");
        this.portData = cm.get(conf, "port.data", 0);
        this.portCmd = cm.get(conf, "port.cmd", 0);
        this.addrData = new InetSocketAddress(this.host, this.portData);
        this.addrCmd = new InetSocketAddress(this.host, this.portCmd);
        String[] bits = cm.get(conf, "bits", "8/0/1").split("/");
        this.databits = bits.length > 0 ? Integer.parseInt(bits[0]) : 8;
        this.parity = bits.length > 1 ? Integer.parseInt(bits[1]) : 0;
        this.stopbits = bits.length > 2 ? Integer.parseInt(bits[2]) : 1;
        this.baudCode = this.getBaudCode(this.baud);
        this.modeCode = this.getModeCode(this.databits, this.parity, this.stopbits);
        return this.baudCode >= 0 && this.modeCode >= 0;
    }

    private byte getBaudCode(int baud) {
        switch (baud) {
            case 300: {
                return 0;
            }
            case 600: {
                return 1;
            }
            case 1200: {
                return 2;
            }
            case 2400: {
                return 3;
            }
            case 4800: {
                return 4;
            }
            case 7200: {
                return 5;
            }
            case 9600: {
                return 6;
            }
            case 19200: {
                return 7;
            }
            case 38400: {
                return 8;
            }
            case 57600: {
                return 9;
            }
            case 115200: {
                return 10;
            }
            case 230400: {
                return 11;
            }
            case 150: {
                return 14;
            }
            case 134: {
                return 15;
            }
            case 110: {
                return 16;
            }
            case 75: {
                return 17;
            }
            case 50: {
                return 18;
            }
        }
        EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Baud:", "" + baud);
        return -1;
    }

    private byte getModeCode(int databits, int parity, int stops) {
        byte mode;
        switch (databits) {
            case 8: {
                mode = 3;
                break;
            }
            case 7: {
                mode = 2;
                break;
            }
            case 6: {
                mode = 1;
                break;
            }
            case 5: {
                mode = 0;
                break;
            }
            default: {
                EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Databits:", "" + databits);
                return -1;
            }
        }
        switch (parity) {
            case 0: {
                mode = (byte)(mode | 0);
                break;
            }
            case 1: {
                mode = (byte)(mode | 0x10);
                break;
            }
            case 2: {
                mode = (byte)(mode | 8);
                break;
            }
            case 3: {
                mode = (byte)(mode | 0x18);
                break;
            }
            case 4: {
                mode = (byte)(mode | 0x20);
                break;
            }
            default: {
                EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Parity:", "" + parity);
                return -1;
            }
        }
        switch (stops) {
            case 1: {
                mode = (byte)(mode | 0);
                break;
            }
            case 2: {
                mode = (byte)(mode | 4);
                break;
            }
            default: {
                EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Stopbits:", "" + stops);
                return -1;
            }
        }
        return mode;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public synchronized boolean open() {
        return this.open(false);
    }

    public synchronized boolean open(boolean silent) {
        if (this.opened) {
            return true;
        }
        boolean bl = this.opened = this.connectSockets(silent) && this.applyParams();
        if (!this.opened) {
            this.connectionLost = true;
            this.disconnectSockets();
        } else {
            this.connectionLost = false;
            this.tagOpened.setReadValInt(1);
        }
        return this.opened;
    }

    protected boolean connectSockets(boolean silent) {
        try {
            this.socketCmd = null;
            this.socketData = null;
            this.socketData = new Socket();
            this.socketData.setSoTimeout(this.timeout_ms);
            this.socketData.setTcpNoDelay(this.noTcpDelay);
            this.socketData.connect(this.addrData, this.timeout_ms);
            this.inputData = this.socketData.getInputStream();
            this.outputData = this.socketData.getOutputStream();
            this.socketCmd = new Socket();
            this.socketCmd.setSoTimeout(this.timeout_ms);
            this.socketCmd.connect(this.addrCmd, this.timeout_ms);
            this.inputCmd = this.socketCmd.getInputStream();
            this.outputCmd = this.socketCmd.getOutputStream();
        }
        catch (Exception e) {
            if (!silent) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Connect sockets:", this.getDescr());
            }
            return false;
        }
        return true;
    }

    private void disconnectSockets() {
        if (this.socketCmd != null) {
            try {
                this.socketCmd.close();
            }
            catch (Exception e) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Disconnect sockets:", this.getDescr(), "socketCmd");
            }
            this.socketCmd = null;
        }
        if (this.socketData != null) {
            try {
                this.socketData.close();
            }
            catch (Exception e) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Disconnect sockets", this.getDescr(), "socketData");
            }
            this.socketData = null;
        }
        this.opened = false;
        this.tagOpened.setReadValInt(0);
    }

    private boolean applyParams() {
        try {
            this.buffcmd[0] = 17;
            this.buffcmd[1] = 4;
            this.buffcmd[2] = 0;
            this.buffcmd[3] = 0;
            this.buffcmd[4] = 0;
            this.buffcmd[5] = 0;
            this.sendCommand(6, 3);
            this.buffcmd[0] = 16;
            this.buffcmd[1] = 2;
            this.buffcmd[2] = this.baudCode;
            this.buffcmd[3] = this.modeCode;
            this.sendCommand(4, 3);
            this.buffcmd[0] = 18;
            this.buffcmd[1] = 2;
            this.buffcmd[2] = 1;
            this.buffcmd[3] = 1;
            this.sendCommand(4, 3);
            this.buffcmd[0] = 48;
            this.buffcmd[1] = 1;
            this.buffcmd[2] = 16;
            this.sendCommand(3, 3);
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Apply params:", this.getDescr());
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        try {
            this.buffcmd[0] = 47;
            this.buffcmd[1] = 4;
            this.buffcmd[2] = 76;
            this.buffcmd[3] = 29;
            this.buffcmd[4] = 0;
            this.buffcmd[5] = 0;
            this.sendCommand(6, 4);
            this.buffcmd[0] = 20;
            this.buffcmd[1] = 1;
            this.buffcmd[2] = 2;
            this.sendCommand(3, 3);
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), "Close port:", this.getDescr());
        }
        this.disconnectSockets();
        this.connectionLost = false;
        this.tagOpened.setReadValInt(0);
    }

    private void checkLiveness() {
        try {
            int cmd;
            this.buffcmd[0] = cmd = 19;
            this.buffcmd[1] = 0;
            this.sendCommand(2, 5);
            return;
        }
        catch (Exception exception) {
            if (this.opened) {
                EnvironmentInst.get().printError(this.logger, this.module.getName(), this.getDescr(), "Connection lost");
                this.disconnectSockets();
                this.connectionLost = true;
                this.connectionLostTime = System.currentTimeMillis();
            }
            return;
        }
    }

    private String getDescr() {
        return "Serial port " + this.id + " (NPort " + this.host + ":" + this.portData + "/" + this.portCmd + ")";
    }

    private boolean restoreConnectionIfLost() {
        if (!this.connectionLost) {
            return true;
        }
        if (System.currentTimeMillis() - this.connectionLostTime < this.recon_ms) {
            return false;
        }
        if (this.open(true)) {
            EnvironmentInst.get().printInfo(this.logger, this.getDescr(), "Connection restored");
            return true;
        }
        this.connectionLostTime = System.currentTimeMillis();
        return false;
    }

    private void sendCommand(int reqlen, int resplen) throws IOException {
        int b;
        byte cmd = this.buffcmd[0];
        this.outputCmd.write(this.buffcmd, 0, reqlen);
        while ((b = this.inputCmd.read()) == 38) {
            if (this.inputCmd.skip(3L) == 3L) continue;
            throw new IOException("Got bad notification, cmd: " + cmd);
        }
        if (b != cmd || this.inputCmd.skip(resplen - 1) != (long)(resplen - 1)) {
            throw new IOException("Bad answer, cmd: " + cmd);
        }
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public synchronized int readByte() {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return -1;
        }
        try {
            return this.inputData.read();
        }
        catch (IOException iOException) {
            this.checkLiveness();
            return -1;
        }
    }

    @Override
    public synchronized int readBytes(int[] buff, int size) {
        if (!this.restoreConnectionIfLost()) {
            return 0;
        }
        if (!this.opened) {
            return 0;
        }
        long time = System.currentTimeMillis();
        int n = 0;
        byte[] bufftmp = new byte[size];
        try {
            int p = 0;
            while ((n += this.inputData.read(bufftmp, p, size - p)) < size && System.currentTimeMillis() - time < (long)this.timeout_ms) {
                p = n;
            }
        }
        catch (IOException p) {
            // empty catch block
        }
        if (n > size) {
            n = size;
        }
        for (int i = 0; i < n; ++i) {
            buff[i] = bufftmp[i] & 0xFF;
        }
        if (n == size) {
            return n;
        }
        this.checkLiveness();
        return -n;
    }

    @Override
    public synchronized int readBytesDelim(int[] buff, int delim) {
        int size;
        block7: {
            if (!this.restoreConnectionIfLost()) {
                return 0;
            }
            if (!this.opened) {
                return 0;
            }
            long time = System.currentTimeMillis();
            int sizemax = buff.length;
            size = 0;
            try {
                block6: {
                    int b;
                    do {
                        if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                            this.checkLiveness();
                            return -size;
                        }
                        b = this.inputData.read();
                        if (size >= sizemax) break block6;
                        buff[size++] = b;
                    } while (b != delim);
                    break block7;
                }
                return -size;
            }
            catch (IOException e) {
                this.checkLiveness();
                return -size;
            }
        }
        return size;
    }

    @Override
    public synchronized String readString(int size) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        int n = 0;
        try {
            byte[] bufftmp = new byte[size];
            int p = 0;
            while ((n += this.inputData.read(bufftmp, p, size - p)) != size) {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    this.checkLiveness();
                    return "";
                }
                p = n;
            }
            if (n == size) {
                return new String(bufftmp, charset);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkLiveness();
        return "";
    }

    @Override
    public synchronized String readStringDelim(int delim) {
        if (!this.restoreConnectionIfLost() || !this.opened) {
            return "";
        }
        long time = System.currentTimeMillis();
        StringBuilder sb = null;
        int i = 0;
        int b = -1;
        try {
            while (true) {
                if (System.currentTimeMillis() - time >= (long)this.timeout_ms) {
                    this.checkLiveness();
                    return "";
                }
                b = this.inputData.read();
                this.buffin[i++] = (byte)b;
                if (b != delim) {
                    if (i < 2048) continue;
                    i = 0;
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(new String(Arrays.copyOf(this.buffin, i), charset));
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (b != delim) {
            this.checkLiveness();
        }
        if (sb == null) {
            return new String(Arrays.copyOf(this.buffin, i), charset);
        }
        sb.append(new String(Arrays.copyOf(this.buffin, i), charset));
        return sb.toString();
    }

    @Override
    public synchronized boolean writeByte(int data) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        try {
            this.outputData.write(data);
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeBytes(int[] data, int size) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        byte[] bufftmp = new byte[size];
        for (int i = 0; i < size; ++i) {
            bufftmp[i] = (byte)data[i];
        }
        try {
            this.outputData.write(bufftmp);
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean writeString(String data) {
        if (!this.restoreConnectionIfLost()) {
            return false;
        }
        if (!this.opened) {
            return false;
        }
        try {
            this.outputData.write(data.getBytes(charset));
        }
        catch (IOException e) {
            this.checkLiveness();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean discard() {
        if (!this.opened) {
            return false;
        }
        try {
            if (this.inputData.available() > 0) {
                this.inputData.skip(this.inputData.available());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getInfo() {
        return String.format("%d: nport %s:%d %d %d/%d/%d %d %s", this.id, this.host, this.portData, this.baud, this.databits, this.parity, this.stopbits, this.timeout_ms, this.opened ? "opened" : "closed");
    }
}

