/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.plugin.serial.SerialManagerModule;
import promauto.jroboplc.plugin.serial.SerialPortUsr;

public class SerialPortRfc2217
extends SerialPortUsr {
    private static final Logger logger = LoggerFactory.getLogger(SerialPortUsr.class);
    private static final int IAC = 255;
    private static final int SB = 250;
    private static final int SE = 240;
    private static final int COM_PORT_OPTION = 44;
    private static final int SET_BAUDRATE = 1;
    private static final int SET_DATASIZE = 2;
    private static final int SET_PARITY = 3;
    private static final int SET_STOPSIZE = 4;

    public SerialPortRfc2217(SerialManagerModule module) {
        super(module);
    }

    public void setBaudRate(int baud) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(baud);
        this.sendSubnegotiation(1, buf.array());
    }

    public void setDataBits(int dataBits) throws IOException {
        this.sendSubnegotiation(2, new byte[]{(byte)dataBits});
    }

    public void setParity(int parity) throws IOException {
        this.sendSubnegotiation(3, new byte[]{(byte)parity});
    }

    public void setStopBits(int stopBits) throws IOException {
        this.sendSubnegotiation(4, new byte[]{(byte)stopBits});
    }

    private void sendSubnegotiation(int command, byte[] payload) throws IOException {
        ByteArrayOutputStream frame = new ByteArrayOutputStream();
        frame.write(255);
        frame.write(250);
        frame.write(44);
        frame.write(command);
        frame.write(payload);
        frame.write(255);
        frame.write(240);
        this.out.write(frame.toByteArray());
        this.out.flush();
    }

    @Override
    protected void applyParams() throws IOException {
        this.setBaudRate(this.baud);
        this.setDataBits(this.databits);
        this.setParity(this.parity + 1);
        this.setStopBits(this.stopbits);
    }

    @Override
    protected int read() throws IOException {
        int b = super.read();
        if (b == 255) {
            b = super.read();
        }
        return b;
    }

    @Override
    protected void write(int b) throws IOException {
        super.write(b);
        if (b == 255) {
            super.write(b);
        }
    }
}

