/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.serial;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.serial.SerialManagerModule;
import promauto.jroboplc.plugin.serial.SerialPortStreamed;

public class SerialPortUsr
extends SerialPortStreamed {
    private final Logger logger = LoggerFactory.getLogger(SerialPortUsr.class);
    private Socket socket;
    private InetSocketAddress addr;
    private boolean noTcpDelay;
    private boolean noInit;

    public SerialPortUsr(SerialManagerModule module) {
        super(module);
    }

    @Override
    public synchronized boolean load(Object conf) {
        this.timeout_ms = 500;
        super.load(conf);
        Configuration cm = EnvironmentInst.get().getConfiguration();
        String host = cm.get(conf, "host", "");
        int port = cm.get(conf, "port", 0);
        this.noTcpDelay = cm.get(conf, "no_tcpdelay", true);
        this.noInit = cm.get(conf, "no_init", false);
        this.addr = new InetSocketAddress(host, port);
        this.portname = host + ":" + port;
        return true;
    }

    @Override
    protected Object getPortType() {
        return "usr";
    }

    @Override
    public void openPort() throws IOException {
        this.socket = new Socket();
        this.socket.setSoTimeout(this.timeout_ms);
        this.socket.setTcpNoDelay(this.noTcpDelay);
        this.socket.connect(this.addr, this.timeout_ms);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        this.applyParams();
    }

    protected void applyParams() throws IOException {
        if (this.noInit) {
            return;
        }
        this.buffin[0] = 85;
        this.buffin[1] = -86;
        this.buffin[2] = 85;
        this.buffin[3] = (byte)(this.baud >> 16 & 0xFF);
        this.buffin[4] = (byte)(this.baud >> 8 & 0xFF);
        this.buffin[5] = (byte)(this.baud & 0xFF);
        this.buffin[6] = (byte)(this.databits - 5 + (this.stopbits > 1 ? 4 : 0) + (this.parity > 0 ? 8 + (this.parity << 4) : 0));
        this.buffin[7] = (byte)(this.buffin[3] + this.buffin[4] + this.buffin[5] + this.buffin[6] & 0xFF);
        this.out.write(this.buffin, 0, 8);
    }

    @Override
    protected void closePort() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    @Override
    protected boolean isPortAlived() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }
}

