/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.system;

import promauto.jroboplc.core.AbstractPlugin;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.plugin.system.SystemModule;

public class SystemPlugin
extends AbstractPlugin {
    private static final String PLUGIN_NAME = "system";
    private OsType osType;
    private String osName;

    @Override
    public void initialize() {
        super.initialize();
        this.initOsType();
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginDescription() {
        return "Platform specific features";
    }

    @Override
    public JrModule createModule(String name, Object conf) {
        SystemModule m = new SystemModule(this, name);
        this.modules.add(m);
        return m.load(conf) ? m : null;
    }

    private void initOsType() {
        this.osName = System.getProperty("os.name");
        if (this.osName.equals("Linux")) {
            this.osType = OsType.Linux;
            this.osName = "linux";
        } else if (this.osName.startsWith("Win")) {
            this.osType = OsType.Windows;
            this.osName = "windows";
        }
    }

    public OsType getOsType() {
        return this.osType;
    }

    public String getOsName() {
        return this.osName;
    }

    public static enum OsType {
        Linux,
        Windows;

    }
}

