/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.wessvr;

import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.plugin.wessvr.Device;
import promauto.jroboplc.plugin.wessvr.DeviceBase;
import promauto.jroboplc.plugin.wessvr.WessvrModule;

public class CmdWmaxlist
extends AbstractCommand {
    private final Logger logger = LoggerFactory.getLogger(CmdWmaxlist.class);

    @Override
    public String getName() {
        return "wmaxlist";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "lists wesincmax setting of modules";
    }

    @Override
    public String execute(Console console, JrModule module, String args) {
        module.postCommand(this, console, module, args);
        return "";
    }

    @Override
    public void executePosted(Console console, JrModule module, String args) {
        WessvrModule w = (WessvrModule)module;
        Database db = w.getDatabase();
        if (!db.isConnected()) {
            console.print("Database " + db.getName() + " is not connected\n");
            return;
        }
        boolean firstpass = true;
        try (Statement st = db.getConnection().createStatement();){
            for (Device device : w.getDevices()) {
                if (!(device instanceof DeviceBase)) continue;
                DeviceBase d = (DeviceBase)device;
                int wesincmax = 0;
                long lastwes = 0L;
                long deltawes = 0L;
                String sql = "select wesincmax from modules where idm=" + d.idm;
                try (ResultSet rs = st.executeQuery(sql);){
                    if (rs.next()) {
                        wesincmax = rs.getInt(1);
                    }
                }
                sql = "select avg(lastwes) from (select first 10 idm, lastwes from arcval where idm=" + d.idm + " order by dt desc)";
                rs = st.executeQuery(sql);
                var19_22 = null;
                try {
                    if (rs.next()) {
                        lastwes = rs.getLong(1);
                    }
                }
                catch (Throwable throwable) {
                    var19_22 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var19_22 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable) {
                                var19_22.addSuppressed(throwable);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                sql = "select first  10 sumwes from arcval where idm=" + d.idm + " order by dt desc";
                long sumwes = 0L;
                try (ResultSet rs = st.executeQuery(sql);){
                    while (rs.next()) {
                        long l = sumwes - rs.getLong(1);
                        if (l > 0L && (deltawes == 0L || deltawes > sumwes)) {
                            deltawes = l;
                        }
                        sumwes = rs.getLong(1);
                    }
                }
                if (firstpass) {
                    console.print("\u001b[01m\n IDM DESCR                 WESINCMAX    LASTWES   DELTAWES\n\u001b[0m");
                    firstpass = false;
                }
                String s = String.format("%1$4d:%2$-20s %3$10d %4$10d %5$10d\n", d.idm, d.name, wesincmax, lastwes, deltawes);
                console.print(s);
            }
            db.commit();
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, new String[0]);
            try {
                db.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        console.print("OK\n");
    }
}

