/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.datastructure.queue;

import io.lettuce.core.internal.LettuceAssert;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class HashIndexedQueue<E>
extends AbstractQueue<E> {
    private final Map<E, Object> map = new HashMap<E, Object>();
    private Node<E> head;
    private Node<E> tail;
    private int size = 0;

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        Node<E> newNode = new Node<E>(e);
        if (this.tail == null) {
            this.tail = newNode;
            this.head = this.tail;
        } else {
            this.tail.next = newNode;
            newNode.prev = this.tail;
            this.tail = newNode;
        }
        if (!this.map.containsKey(e)) {
            this.map.put(e, newNode);
        } else {
            Object current = this.map.get(e);
            if (current instanceof Node) {
                ArrayList<Node<E>> nodes = new ArrayList<Node<E>>();
                nodes.add((Node)current);
                nodes.add(newNode);
                this.map.put(e, nodes);
            } else {
                ((List)current).add(newNode);
            }
        }
        ++this.size;
        return true;
    }

    @Override
    public E poll() {
        if (this.head == null) {
            return null;
        }
        Object value = this.head.value;
        this.removeNodeFromMap(this.head);
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        } else {
            this.head.prev = null;
        }
        --this.size;
        return value;
    }

    @Override
    public E peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.value;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @NotNull
    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            if (!this.removeAllOccurrences(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.map.clear();
        this.size = 0;
    }

    private boolean removeFirstOccurrence(Object element) {
        Object current = this.map.get(element);
        if (current == null) {
            return false;
        }
        if (current instanceof Node) {
            Node node = (Node)current;
            this.removeNode(node);
            this.map.remove(element);
        } else {
            List nodes = (List)current;
            Node node = (Node)nodes.remove(0);
            if (nodes.isEmpty()) {
                this.map.remove(element);
            }
            this.removeNode(node);
        }
        --this.size;
        return true;
    }

    private boolean removeAllOccurrences(Object element) {
        Object current = this.map.get(element);
        if (current == null) {
            return false;
        }
        if (current instanceof Node) {
            Node node = (Node)current;
            this.removeNode(node);
            --this.size;
        } else {
            List nodes = (List)current;
            for (Node node : nodes) {
                this.removeNode(node);
                --this.size;
            }
        }
        this.map.remove(element);
        return true;
    }

    private void removeNode(Node<E> node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.tail = node.prev;
        }
    }

    private void removeNodeFromMap(Node<E> node) {
        Object value = node.value;
        Object current = this.map.get(value);
        if (current instanceof Node) {
            LettuceAssert.assertState(current == node, "current != node");
            this.map.remove(value);
        } else {
            List nodes = (List)current;
            boolean removed = nodes.remove(node);
            LettuceAssert.assertState(removed, "!nodes.remove(node)");
            if (nodes.isEmpty()) {
                this.map.remove(value);
            }
        }
    }

    public class Iterator
    implements java.util.Iterator<E> {
        private Node<E> current;
        private Node<E> prev;

        private Iterator() {
            this.current = HashIndexedQueue.this.head;
            this.prev = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = this.current.value;
            this.prev = this.current;
            this.current = this.current.next;
            return value;
        }

        @Override
        public void remove() {
            if (this.prev != null) {
                HashIndexedQueue.this.removeNodeFromMap(this.prev);
                HashIndexedQueue.this.removeNode(this.prev);
                HashIndexedQueue.this.size--;
                this.prev = null;
            }
        }
    }

    private static class Node<E> {
        E value;
        Node<E> next;
        Node<E> prev;

        Node(E value) {
            this.value = value;
        }
    }
}

