@echo off
setlocal

set SERVY_DIR=C:\tools\servy
set SERVY_EXE=%SERVY_DIR%\servy-cli.exe
set SERVY_URL=https://prom-auto.ru/download/dist/servy/servy-cli.exe

REM ------------------------------------------------------------
REM Create directory if not exists
REM ------------------------------------------------------------
if not exist "%SERVY_DIR%" (
    echo Creating directory %SERVY_DIR%
    mkdir "%SERVY_DIR%" || exit /b 1
)

REM ------------------------------------------------------------
REM Download servy-cli.exe if missing
REM ------------------------------------------------------------
if not exist "%SERVY_EXE%" (
    echo Servy CLI not found. Downloading...

    powershell -NoProfile -ExecutionPolicy Bypass -Command ^
      "[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; " ^
      "Invoke-WebRequest -Uri '%SERVY_URL%' -OutFile '%SERVY_EXE%'"

    if errorlevel 1 (
        echo ERROR: Failed to download servy-cli.exe
        exit /b 1
    )
)

exit /b 0
