/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.message;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import org.apache.logging.log4j.message.ThreadInformation;
import org.apache.logging.log4j.util.StringBuilders;
import org.jspecify.annotations.Nullable;

class ExtendedThreadInformation
implements ThreadInformation {
    private final ThreadInfo threadInfo;

    ExtendedThreadInformation(ThreadInfo thread) {
        this.threadInfo = thread;
    }

    @Override
    public void printThreadInfo(StringBuilder sb) {
        StringBuilders.appendDqValue(sb, this.threadInfo.getThreadName());
        sb.append(" Id=").append(this.threadInfo.getThreadId()).append(' ');
        this.formatState(sb, this.threadInfo);
        if (this.threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (this.threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
    }

    @Override
    public void printStack(StringBuilder sb, StackTraceElement[] stack) {
        int i = 0;
        for (StackTraceElement element : stack) {
            sb.append("\tat ").append(element.toString());
            sb.append('\n');
            if (i == 0 && this.threadInfo.getLockInfo() != null) {
                Thread.State ts = this.threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ");
                        this.formatLock(sb, this.threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ");
                        this.formatLock(sb, this.threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ");
                        this.formatLock(sb, this.threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo mi : this.threadInfo.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ");
                this.formatLock(sb, mi);
                sb.append('\n');
            }
            ++i;
        }
        LockInfo[] locks = this.threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length).append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- ");
                this.formatLock(sb, li);
                sb.append('\n');
            }
        }
    }

    private void formatLock(StringBuilder sb, LockInfo lock) {
        sb.append('<').append(lock.getIdentityHashCode()).append("> (a ");
        sb.append(lock.getClassName()).append(')');
    }

    private void formatState(StringBuilder sb, ThreadInfo info2) {
        Thread.State state = info2.getThreadState();
        sb.append((Object)state);
        switch (state) {
            case BLOCKED: {
                sb.append(" (on object monitor owned by \"");
                sb.append(info2.getLockOwnerName()).append("\" Id=").append(info2.getLockOwnerId()).append(')');
                break;
            }
            case WAITING: {
                String method;
                StackTraceElement element = ExtendedThreadInformation.getFirstStackTraceElement(info2);
                String className = element != null ? element.getClassName() : null;
                String string = method = element != null ? element.getMethodName() : null;
                if ("java.lang.Object".equals(className) && "wait".equals(method)) {
                    sb.append(" (on object monitor");
                    if (info2.getLockOwnerName() != null) {
                        sb.append(" owned by \"");
                        sb.append(info2.getLockOwnerName()).append("\" Id=").append(info2.getLockOwnerId());
                    }
                    sb.append(')');
                    break;
                }
                if ("java.lang.Thread".equals(className) && "join".equals(method)) {
                    sb.append(" (on completion of thread ").append(info2.getLockOwnerId()).append(')');
                    break;
                }
                sb.append(" (parking for lock");
                if (info2.getLockOwnerName() != null) {
                    sb.append(" owned by \"");
                    sb.append(info2.getLockOwnerName()).append("\" Id=").append(info2.getLockOwnerId());
                }
                sb.append(')');
                break;
            }
            case TIMED_WAITING: {
                String method;
                StackTraceElement element = ExtendedThreadInformation.getFirstStackTraceElement(info2);
                String className = element != null ? element.getClassName() : null;
                String string = method = element != null ? element.getMethodName() : null;
                if ("java.lang.Object".equals(className) && "wait".equals(method)) {
                    sb.append(" (on object monitor");
                    if (info2.getLockOwnerName() != null) {
                        sb.append(" owned by \"");
                        sb.append(info2.getLockOwnerName()).append("\" Id=").append(info2.getLockOwnerId());
                    }
                    sb.append(')');
                    break;
                }
                if ("java.lang.Thread".equals(className) && "sleep".equals(method)) {
                    sb.append(" (sleeping)");
                    break;
                }
                if ("java.lang.Thread".equals(className) && "join".equals(method)) {
                    sb.append(" (on completion of thread ").append(info2.getLockOwnerId()).append(')');
                    break;
                }
                sb.append(" (parking for lock");
                if (info2.getLockOwnerName() != null) {
                    sb.append(" owned by \"");
                    sb.append(info2.getLockOwnerName()).append("\" Id=").append(info2.getLockOwnerId());
                }
                sb.append(')');
                break;
            }
        }
    }

    private static @Nullable StackTraceElement getFirstStackTraceElement(ThreadInfo info2) {
        StackTraceElement[] stackTrace = info2.getStackTrace();
        return stackTrace != null && stackTrace.length > 0 ? stackTrace[0] : null;
    }
}

