/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import org.firebirdsql.gds.Parameter;
import org.firebirdsql.gds.ParameterBuffer;

public interface TransactionParameterBuffer
extends ParameterBuffer {
    public TransactionParameterBuffer deepCopy();

    default public void copyTo(TransactionParameterBuffer destination) {
        for (Parameter parameter : this) {
            parameter.copyTo(destination, null);
        }
    }

    default public void setReadOnly(boolean readOnly2) {
        if (readOnly2) {
            this.ensurePresentAbsent(8, 9);
        } else {
            this.ensurePresentAbsent(9, 8);
        }
    }

    private void ensurePresentAbsent(int present, int absent) {
        if (!this.hasArgument(present)) {
            this.addArgument(present);
        }
        this.removeArgument(absent);
    }

    default public boolean isReadOnly() {
        return this.hasArgument(8);
    }

    default public void setAutoCommit(boolean autoCommit) {
        if (autoCommit) {
            if (!this.hasArgument(16)) {
                this.addArgument(16);
            }
        } else {
            this.removeArgument(16);
        }
    }

    default public boolean isAutoCommit() {
        return this.hasArgument(16);
    }
}

