/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.BlobParameterBufferImp;
import org.firebirdsql.gds.impl.TransactionParameterBufferImpl;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractFbAttachment;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.OdsVersion;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.DatabaseListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;

public abstract class AbstractFbDatabase<T extends AbstractConnection<IConnectionProperties, ? extends FbDatabase>>
extends AbstractFbAttachment<T>
implements FbDatabase,
TransactionListener {
    private static final System.Logger log = System.getLogger(AbstractFbDatabase.class.getName());
    private static final byte[] DESCRIBE_DATABASE_INFO_BLOCK = new byte[]{62, 103, 32, 33, 1};
    protected final DatabaseListenerDispatcher databaseListenerDispatcher = new DatabaseListenerDispatcher();
    private final Set<FbTransaction> activeTransactions = new HashSet<FbTransaction>();
    private final WarningMessageCallback warningCallback = warning -> this.databaseListenerDispatcher.warningReceived(this, warning);
    private final RowDescriptor emptyRowDescriptor;
    private OdsVersion odsVersion = OdsVersion.none();
    private short databaseDialect;

    protected AbstractFbDatabase(T connection, DatatypeCoder datatypeCoder) {
        super(connection, datatypeCoder);
        this.emptyRowDescriptor = RowDescriptor.empty(datatypeCoder);
    }

    public final WarningMessageCallback getDatabaseWarningCallback() {
        return this.warningCallback;
    }

    public final int getActiveTransactionCount() {
        try (LockCloseable ignored = this.withLock();){
            int n = this.activeTransactions.size();
            return n;
        }
    }

    protected final void transactionAdded(FbTransaction transaction) {
        try (LockCloseable ignored = this.withLock();){
            if (transaction.getState() == TransactionState.ACTIVE) {
                this.activeTransactions.add(transaction);
            }
            transaction.addTransactionListener(this);
            transaction.addExceptionListener(this.exceptionListenerDispatcher);
        }
    }

    @Override
    public final short getConnectionDialect() {
        return (short)((IConnectionProperties)this.connection.getAttachProperties()).getSqlDialect();
    }

    @Override
    public final short getDatabaseDialect() {
        return this.databaseDialect;
    }

    protected final void setDatabaseDialect(short dialect) {
        this.databaseDialect = dialect;
    }

    @Override
    public final void addDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.addListener(listener);
    }

    @Override
    public final void addWeakDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.addWeakListener(listener);
    }

    @Override
    public final void removeDatabaseListener(DatabaseListener listener) {
        this.databaseListenerDispatcher.removeListener(listener);
    }

    protected abstract void internalDetach() throws SQLException;

    @Override
    public final void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkConnected();
            int activeTransactionCount = this.getActiveTransactionCount();
            if (activeTransactionCount > 0) {
                throw FbExceptionBuilder.forException(335544357).messageParameter(activeTransactionCount).toSQLException();
            }
            this.databaseListenerDispatcher.detaching(this);
            try {
                this.internalDetach();
            }
            finally {
                this.databaseListenerDispatcher.detached(this);
                this.databaseListenerDispatcher.shutdown();
                this.exceptionListenerDispatcher.shutdown();
            }
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    @Override
    public final int getOdsMajor() {
        return this.odsVersion.major();
    }

    protected final void setOdsMajor(int odsMajor) {
        this.odsVersion = this.odsVersion.withMajor(odsMajor);
    }

    @Override
    public final int getOdsMinor() {
        return this.odsVersion.minor();
    }

    protected final void setOdsMinor(int odsMinor) {
        this.odsVersion = this.odsVersion.withMinor(odsMinor);
    }

    @Override
    public final OdsVersion getOdsVersion() {
        return this.odsVersion;
    }

    public final byte[] getStatementInfoRequestItems() {
        return this.getServerVersionInformation().getStatementInfoRequestItems();
    }

    public final byte[] getParameterDescriptionInfoRequestItems() {
        return this.getServerVersionInformation().getParameterDescriptionInfoRequestItems();
    }

    public final <R> R getDatabaseInfo(byte[] requestItems, int bufferLength, InfoProcessor<R> infoProcessor) throws SQLException {
        byte[] responseBuffer = this.getDatabaseInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(responseBuffer);
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    protected byte[] getDescribeDatabaseInfoBlock() {
        return DESCRIBE_DATABASE_INFO_BLOCK;
    }

    protected InfoProcessor<FbDatabase> getDatabaseInformationProcessor() {
        return new DatabaseInformationProcessor();
    }

    @Override
    public final void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        switch (newState) {
            case COMMITTING: 
            case ROLLING_BACK: 
            case PREPARED: {
                try (LockCloseable ignored = this.withLock();){
                    this.activeTransactions.remove(transaction);
                    break;
                }
            }
            case COMMITTED: 
            case ROLLED_BACK: {
                try (LockCloseable ignored = this.withLock();){
                    this.activeTransactions.remove(transaction);
                    transaction.removeTransactionListener(this);
                    transaction.removeExceptionListener(this.exceptionListenerDispatcher);
                    break;
                }
            }
        }
    }

    @Override
    public BlobParameterBuffer createBlobParameterBuffer() {
        return new BlobParameterBufferImp();
    }

    @Override
    public TransactionParameterBufferImpl createTransactionParameterBuffer() {
        return new TransactionParameterBufferImpl();
    }

    @Override
    public IConnectionProperties getConnectionProperties() {
        return ((IConnectionProperties)this.connection.getAttachProperties()).asImmutable();
    }

    @Override
    public final RowDescriptor emptyRowDescriptor() {
        return this.emptyRowDescriptor;
    }

    protected byte[] getTransactionIdBuffer(long transactionId) {
        byte[] buf;
        if ((transactionId & Integer.MAX_VALUE) == transactionId) {
            buf = new byte[4];
            VaxEncoding.encodeVaxIntegerWithoutLength(buf, 0, (int)transactionId);
        } else {
            buf = new byte[8];
            VaxEncoding.encodeVaxLongWithoutLength(buf, 0, transactionId);
        }
        return buf;
    }

    private class DatabaseInformationProcessor
    implements InfoProcessor<FbDatabase> {
        private DatabaseInformationProcessor() {
        }

        @Override
        public FbDatabase process(byte[] info2) throws SQLException {
            if (info2.length == 0) {
                throw FbExceptionBuilder.forException(337248307).messageParameter((Object)"database").toSQLException();
            }
            int i = 0;
            block10: while (info2[i] != 1) {
                byte arg = info2[i++];
                block0 : switch (arg) {
                    case 32: 
                    case 33: 
                    case 62: {
                        int len = VaxEncoding.iscVaxInteger2(info2, i);
                        int value = VaxEncoding.iscVaxInteger(info2, i += 2, len);
                        i += len;
                        switch (arg) {
                            case 62: {
                                AbstractFbDatabase.this.setDatabaseDialect((short)value);
                                break block0;
                            }
                            case 32: {
                                AbstractFbDatabase.this.setOdsMajor(value);
                                break block0;
                            }
                            case 33: {
                                AbstractFbDatabase.this.setOdsMinor(value);
                                break block0;
                            }
                        }
                        assert (false) : "Missing switch case (must cover parent case): " + arg;
                        continue block10;
                    }
                    case 103: {
                        int len = VaxEncoding.iscVaxInteger2(info2, i);
                        int expectedIndex = (i += 2) + len;
                        int versionCount = info2[i++] & 0xFF;
                        String[] versionParts = new String[versionCount];
                        for (int versionIndex = 0; versionIndex < versionCount; ++versionIndex) {
                            int versionLength = info2[i++] & 0xFF;
                            versionParts[versionIndex] = new String(info2, i, versionLength, StandardCharsets.UTF_8);
                            i += versionLength;
                        }
                        assert (i == expectedIndex) : "Parsing version information lead to wrong index";
                        AbstractFbDatabase.this.setServerVersion(versionParts);
                        break;
                    }
                    case 2: {
                        log.log(System.Logger.Level.DEBUG, "Received isc_info_truncated");
                        return AbstractFbDatabase.this;
                    }
                    default: {
                        throw FbExceptionBuilder.toException(335544341);
                    }
                }
            }
            return AbstractFbDatabase.this;
        }
    }
}

