/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.util.function.Consumer;
import java.util.function.Function;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.Response;

public interface DeferredAction {
    public static final DeferredAction NO_OP_INSTANCE = new DeferredAction(){};

    default public void processResponse(Response response) {
    }

    default public void onException(Exception exception) {
        System.getLogger(this.getClass().getName()).log(System.Logger.Level.DEBUG, "Exception in processDeferredActions", (Throwable)exception);
    }

    default public WarningMessageCallback getWarningMessageCallback() {
        return null;
    }

    default public boolean requiresSync() {
        return false;
    }

    public static <T> DeferredAction wrapDeferredResponse(final DeferredResponse<T> deferredResponse, final Function<Response, T> responseMapper, final WarningMessageCallback warningMessageCallback, final Consumer<Exception> exceptionConsumer, final boolean requiresSync) {
        return new DeferredAction(){

            @Override
            public void processResponse(Response response) {
                deferredResponse.onResponse(responseMapper.apply(response));
            }

            @Override
            public void onException(Exception exception) {
                try {
                    deferredResponse.onException(exception);
                }
                finally {
                    exceptionConsumer.accept(exception);
                }
            }

            @Override
            public WarningMessageCallback getWarningMessageCallback() {
                return warningMessageCallback;
            }

            @Override
            public boolean requiresSync() {
                return requiresSync;
            }
        };
    }
}

