/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.parser.LocalStatementClass;
import org.firebirdsql.jaybird.parser.LocalStatementType;
import org.firebirdsql.jaybird.parser.StatementDetector;
import org.firebirdsql.jaybird.props.DatabaseConnectionProperties;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;
import org.firebirdsql.jaybird.xca.FBLocalTransaction;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jdbc.ClientInfoProvider;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBCallableStatement;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBSavepoint;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FBTxPreparedStatement;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.jdbc.GeneratedKeysSupport;
import org.firebirdsql.jdbc.GeneratedKeysSupportFactory;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.ResultSetBehavior;
import org.firebirdsql.jdbc.StoredProcedureMetaData;
import org.firebirdsql.jdbc.StoredProcedureMetaDataFactory;
import org.firebirdsql.jdbc.escape.FBEscapedParser;

public class FBConnection
implements FirebirdConnection {
    private static final System.Logger log = System.getLogger(FBConnection.class.getName());
    private static final SQLPermission PERMISSION_SET_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");
    private static final SQLPermission PERMISSION_CALL_ABORT = new SQLPermission("callAbort");
    protected volatile FBManagedConnection mc;
    private FBLocalTransaction localTransaction;
    private FBDatabaseMetaData metaData;
    protected final InternalTransactionCoordinator txCoordinator;
    private SQLWarning firstWarning;
    protected final Set<Statement> activeStatements = Collections.synchronizedSet(new HashSet());
    private int resultSetHoldability;
    private StoredProcedureMetaData storedProcedureMetaData;
    private GeneratedKeysSupport generatedKeysSupport;
    private ClientInfoProvider clientInfoProvider;
    private boolean readOnly;
    private static final AtomicIntegerFieldUpdater<FBConnection> SAVEPOINT_COUNTER_UPDATE = AtomicIntegerFieldUpdater.newUpdater(FBConnection.class, "savepointCounter");
    private volatile int savepointCounter;
    private final List<FBSavepoint> savepoints = new ArrayList<FBSavepoint>();

    public FBConnection(FBManagedConnection mc) {
        this.mc = mc;
        this.txCoordinator = new InternalTransactionCoordinator(this);
        IConnectionProperties props = mc.getConnectionRequestInfo().asIConnectionProperties();
        this.resultSetHoldability = props.isDefaultResultSetHoldable() ? 1 : 2;
        this.readOnly = mc.isTpbReadOnly();
    }

    @Override
    public int getHoldability() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            int n = this.resultSetHoldability;
            return n;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.resultSetHoldability = holdability;
        }
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed()) {
            throw FbExceptionBuilder.connectionClosed();
        }
    }

    void notifyStatementClosed(FirebirdStatement stmt) {
        if (!this.activeStatements.remove(stmt)) {
            FBPreparedStatement pstmt;
            if (stmt instanceof FBPreparedStatement && !(pstmt = (FBPreparedStatement)stmt).isInitialized()) {
                return;
            }
            log.log(System.Logger.Level.WARNING, "Specified statement was not created by this connection: {0}", stmt);
        }
    }

    protected void freeStatements() throws SQLException {
        ArrayList<Statement> statements = new ArrayList<Statement>(this.activeStatements);
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        for (Statement stmt : statements) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        chain.throwIfPresent();
    }

    public void setManagedConnection(FBManagedConnection mc) {
        if (mc == null && this.mc == null) {
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            if (this.mc != mc && this.metaData != null) {
                try {
                    this.metaData.close();
                }
                finally {
                    this.metaData = null;
                }
            }
            this.mc = mc;
        }
    }

    public FBManagedConnection getManagedConnection() {
        try (LockCloseable ignored = this.withLock();){
            FBManagedConnection fBManagedConnection = this.mc;
            return fBManagedConnection;
        }
    }

    @Override
    public FbDatabase getFbDatabase() throws SQLException {
        return this.getGDSHelper().getCurrentDatabase();
    }

    public DatabaseConnectionProperties connectionProperties() {
        return this.mc != null ? this.mc.getConnectionRequestInfo().asIConnectionProperties().asImmutable() : null;
    }

    @Override
    @Deprecated(since="2")
    public void setTransactionParameters(int isolationLevel, int[] parameters) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            TransactionParameterBuffer tpbParams = this.createTransactionParameterBuffer();
            for (int parameter : parameters) {
                tpbParams.addArgument(parameter);
            }
            this.setTransactionParameters(isolationLevel, tpbParams);
        }
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolationLevel) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            TransactionParameterBuffer transactionParameterBuffer = this.mc.getTransactionParameters(isolationLevel);
            return transactionParameterBuffer;
        }
    }

    @Override
    public TransactionParameterBuffer createTransactionParameterBuffer() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            TransactionParameterBuffer transactionParameterBuffer = this.getFbDatabase().createTransactionParameterBuffer();
            return transactionParameterBuffer;
        }
    }

    @Override
    public void setTransactionParameters(int isolationLevel, TransactionParameterBuffer tpb) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.mc.isManagedEnvironment()) {
                throw new SQLException("Cannot set transaction parameters in managed environment.", "HY000");
            }
            this.mc.setTransactionParameters(isolationLevel, tpb);
        }
    }

    @Override
    public void setTransactionParameters(TransactionParameterBuffer tpb) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getLocalTransaction().inTransaction()) {
                throw new SQLException("Cannot set transaction parameters when transaction is already started.", "25001");
            }
            this.mc.setTransactionParameters(tpb);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public Blob createBlob() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBBlob fBBlob = this.createBlob(FBBlob.createConfig(0, this.connectionProperties(), this.getFbDatabase().getDatatypeCoder()));
            return fBBlob;
        }
    }

    private FBBlob createBlob(FBBlob.Config blobConfig) throws SQLException {
        return new FBBlob(this.getGDSHelper(), this.txCoordinator, blobConfig);
    }

    @Override
    public Clob createClob() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBBlob blob = this.createBlob(FBBlob.createConfig(1, this.connectionProperties(), this.getFbDatabase().getDatatypeCoder()));
            FBClob fBClob = new FBClob(blob);
            return fBClob;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type STRUCT not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            String string = FBEscapedParser.toNativeSql(sql);
            return string;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getAutoCommit() == autoCommit) {
                return;
            }
            this.txCoordinator.switchTransactionCoordinator(autoCommit);
        }
    }

    protected void setTransactionCoordinator(boolean managedConnection, boolean autoCommit) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.txCoordinator.setTransactionCoordinator(managedConnection, autoCommit);
        }
    }

    public void setManagedEnvironment(boolean managedConnection) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.setTransactionCoordinator(managedConnection, true);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.isClosed()) {
                throw new SQLNonTransientConnectionException("You cannot getAutoCommit on an unassociated closed connection.", "08006");
            }
            boolean bl = this.txCoordinator.getAutoCommit();
            return bl;
        }
    }

    @Override
    public void commit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.isClosed()) {
                throw new SQLNonTransientConnectionException("You cannot commit a closed connection.", "08007");
            }
            if (this.mc.inDistributedTransaction()) {
                throw FBConnection.connectionEnlistedInDistributedTransaction();
            }
            this.txCoordinator.commit();
            this.invalidateTransactionLifetimeObjects();
        }
    }

    private static SQLException connectionEnlistedInDistributedTransaction() {
        return new SQLException("Connection enlisted in distributed transaction", "25000");
    }

    @Override
    public void rollback() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.isClosed()) {
                throw new SQLNonTransientConnectionException("You cannot rollback closed connection.", "08007");
            }
            if (this.mc.inDistributedTransaction()) {
                throw FBConnection.connectionEnlistedInDistributedTransaction();
            }
            this.txCoordinator.rollback();
            this.invalidateTransactionLifetimeObjects();
        }
    }

    protected void invalidateTransactionLifetimeObjects() {
        this.invalidateSavepoints();
        this.storedProcedureMetaData = null;
    }

    boolean isAllowTxStmts() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isAllowTxStmts();
    }

    void handleHardCommitStatement() throws SQLException {
        if (!this.isAllowTxStmts()) {
            throw FbExceptionBuilder.toNonTransientException(337248313);
        }
        this.commit();
    }

    void handleHardRollbackStatement() throws SQLException {
        if (!this.isAllowTxStmts()) {
            throw FbExceptionBuilder.toNonTransientException(337248314);
        }
        this.rollback();
    }

    void handleSetTransactionStatement(String sql) throws SQLException {
        if (!this.isAllowTxStmts()) {
            throw FbExceptionBuilder.toNonTransientException(337248315);
        }
        this.txCoordinator.startSqlTransaction(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (log.isLoggable(System.Logger.Level.TRACE)) {
            log.log(System.Logger.Level.TRACE, "Connection closed requested at", (Throwable)new RuntimeException("Connection close logging"));
        }
        SQLExceptionChainBuilder chainBuilder = new SQLExceptionChainBuilder();
        try (LockCloseable ignored = this.withLock();){
            try {
                if (this.metaData != null) {
                    this.metaData.close();
                }
                this.freeStatements();
            }
            catch (SQLException e) {
                chainBuilder.append(e);
            }
            finally {
                this.metaData = null;
                this.closeMc(chainBuilder);
            }
        }
        chainBuilder.throwIfPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMc(SQLExceptionChainBuilder chainBuilder) {
        FBManagedConnection mc = this.mc;
        if (mc == null) {
            return;
        }
        if (!mc.inDistributedTransaction()) {
            try {
                this.txCoordinator.handleConnectionClose();
            }
            catch (SQLException e) {
                chainBuilder.append(e);
            }
            finally {
                block14: {
                    try {
                        this.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 337248336) break block14;
                        chainBuilder.append(e);
                    }
                }
            }
        }
        mc.close(this);
    }

    @Override
    public boolean isClosed() {
        return this.mc == null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout should be >= 0", "HY024");
        }
        if (this.isLockedByCurrentThread()) {
            return this.isValidImpl(timeout);
        }
        return this.isValidAsync(timeout);
    }

    private boolean isValidAsync(int timeout) {
        Future isValidFuture = ForkJoinPool.commonPool().submit(() -> this.isValidImpl(timeout));
        try {
            return timeout != 0 ? (Boolean)isValidFuture.get(timeout, TimeUnit.SECONDS) : (Boolean)isValidFuture.get();
        }
        catch (ExecutionException e) {
            log.log(System.Logger.Level.DEBUG, "isValidImpl produced an exception", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            isValidFuture.cancel(true);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            isValidFuture.cancel(true);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isValidImpl(int timeout) {
        try (LockCloseable ignored = this.withLock();){
            boolean bl;
            boolean networkTimeoutChanged;
            int originalNetworkTimeout;
            block28: {
                if (this.isClosed()) {
                    boolean bl2 = false;
                    return bl2;
                }
                originalNetworkTimeout = -1;
                networkTimeoutChanged = false;
                FbDatabase db = this.getFbDatabase();
                if (timeout != 0) {
                    try {
                        originalNetworkTimeout = db.getNetworkTimeout();
                        db.setNetworkTimeout((int)TimeUnit.SECONDS.toMillis(timeout));
                        networkTimeoutChanged = true;
                    }
                    catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                        // empty catch block
                    }
                }
                db.getDatabaseInfo(new byte[]{32, 1}, 10);
                bl = true;
                if (!networkTimeoutChanged) break block28;
                try {
                    this.getFbDatabase().setNetworkTimeout(originalNetworkTimeout);
                }
                catch (SQLException e) {
                    log.log(System.Logger.Level.DEBUG, "Exception while resetting connection network timeout", (Throwable)e);
                    boolean bl3 = false;
                    if (ignored != null) {
                        ignored.close();
                    }
                    return bl3;
                }
            }
            return bl;
            catch (SQLException ex) {
                boolean bl4;
                block29: {
                    try {
                        log.log(System.Logger.Level.DEBUG, "Exception while checking connection validity", (Throwable)ex);
                        bl4 = false;
                        if (!networkTimeoutChanged) break block29;
                    }
                    catch (Throwable throwable) {
                        block30: {
                            if (!networkTimeoutChanged) break block30;
                            try {
                                this.getFbDatabase().setNetworkTimeout(originalNetworkTimeout);
                            }
                            catch (SQLException e) {
                                log.log(System.Logger.Level.DEBUG, "Exception while resetting connection network timeout", (Throwable)e);
                                boolean bl5 = false;
                                if (ignored != null) {
                                    ignored.close();
                                }
                                return bl5;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.getFbDatabase().setNetworkTimeout(originalNetworkTimeout);
                    }
                    catch (SQLException e) {
                        log.log(System.Logger.Level.DEBUG, "Exception while resetting connection network timeout", (Throwable)e);
                        boolean bl6 = false;
                        if (ignored != null) {
                            ignored.close();
                        }
                        return bl6;
                    }
                }
                if (ignored != null) {
                    ignored.close();
                }
                return bl4;
            }
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.metaData == null) {
                this.metaData = new FBDatabaseMetaData(this);
            }
            FBDatabaseMetaData fBDatabaseMetaData = this.metaData;
            return fBDatabaseMetaData;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly2) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getLocalTransaction().inTransaction() && !this.mc.isManagedEnvironment()) {
                throw new SQLException("Calling setReadOnly(boolean) method is not allowed when transaction is already started.", "25001");
            }
            this.readOnly = readOnly2;
            this.mc.setTpbReadOnly(readOnly2);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            boolean bl = this.readOnly;
            return bl;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkValidity();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (!this.getAutoCommit() && !this.mc.isManagedEnvironment()) {
                this.txCoordinator.commit();
            }
            this.mc.setTransactionIsolation(level);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            int n = this.mc.getTransactionIsolation();
            return n;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            SQLWarning sQLWarning = this.firstWarning;
            return sQLWarning;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.firstWarning = null;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBStatement stmt = new FBStatement(this, this.toResultSetBehavior(resultSetType, resultSetConcurrency, resultSetHoldability), this.txCoordinator);
            this.activeStatements.add(stmt);
            FBStatement fBStatement = stmt;
            return fBStatement;
        }
    }

    private ResultSetBehavior toResultSetBehavior(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return ResultSetBehavior.of(resultSetType, resultSetConcurrency, resultSetHoldability, this::addWarning);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.getGeneratedKeysSupport().buildQuery(sql, autoGeneratedKeys);
            PreparedStatement preparedStatement = this.prepareStatement(query);
            return preparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.getGeneratedKeysSupport().buildQuery(sql, columnIndexes);
            PreparedStatement preparedStatement = this.prepareStatement(query);
            return preparedStatement;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.getGeneratedKeysSupport().buildQuery(sql, columnNames);
            PreparedStatement preparedStatement = this.prepareStatement(query);
            return preparedStatement;
        }
    }

    private PreparedStatement prepareStatement(GeneratedKeysSupport.Query query) throws SQLException {
        if (query.generatesKeys()) {
            return this.prepareStatement(query.getQueryString(), 1003, 1007, 2, false, true);
        }
        return this.prepareStatement(query.getQueryString());
    }

    protected PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean metaData, boolean generatedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            ResultSetBehavior rsBehavior = this.toResultSetBehavior(resultSetType, resultSetConcurrency, resultSetHoldability);
            Optional<PreparedStatement> txStmt = this.prepareIfTransactionStatement(sql, rsBehavior);
            if (txStmt.isPresent()) {
                PreparedStatement preparedStatement = txStmt.get();
                return preparedStatement;
            }
            FBObjectListener.StatementListener coordinator = this.txCoordinator;
            InternalTransactionCoordinator blobCoordinator = this.txCoordinator;
            if (metaData) {
                coordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.txCoordinator);
                blobCoordinator = null;
            }
            FBPreparedStatement stmt = new FBPreparedStatement(this, sql, rsBehavior, coordinator, blobCoordinator, metaData, false, generatedKeys);
            this.activeStatements.add(stmt);
            FBPreparedStatement fBPreparedStatement = stmt;
            return fBPreparedStatement;
        }
    }

    private Optional<PreparedStatement> prepareIfTransactionStatement(String sql, ResultSetBehavior rsBehavior) throws SQLException {
        LocalStatementType localStatementType = StatementDetector.determineLocalStatementType(sql);
        if (localStatementType.statementClass() == LocalStatementClass.TRANSACTION_BOUNDARY) {
            PreparedStatement stmt = this.prepareTxStatement(sql, localStatementType, rsBehavior);
            this.activeStatements.add(stmt);
            return Optional.of(stmt);
        }
        return Optional.empty();
    }

    private PreparedStatement prepareTxStatement(String sql, LocalStatementType statementType, ResultSetBehavior rsBehavior) throws SQLException {
        if (this.isAllowTxStmts()) {
            return new FBTxPreparedStatement(this, statementType, sql, rsBehavior);
        }
        int errorCode = switch (statementType) {
            case LocalStatementType.HARD_COMMIT -> 337248313;
            case LocalStatementType.HARD_ROLLBACK -> 337248314;
            case LocalStatementType.SET_TRANSACTION -> 337248315;
            default -> throw new IllegalArgumentException("Unexpected statementType: " + String.valueOf((Object)statementType));
        };
        throw FbExceptionBuilder.toNonTransientException(errorCode);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBStatement.rejectIfTxStmt(sql, 337248320);
            ResultSetBehavior rsBehavior = this.toResultSetBehavior(resultSetType, resultSetConcurrency, resultSetHoldability);
            if (rsBehavior.isUpdatable()) {
                this.addWarning(FbExceptionBuilder.toWarning(337248267));
                rsBehavior = rsBehavior.withReadOnly();
            }
            if (this.storedProcedureMetaData == null) {
                this.storedProcedureMetaData = StoredProcedureMetaDataFactory.getInstance(this);
            }
            FBCallableStatement stmt = new FBCallableStatement(this, sql, rsBehavior, this.storedProcedureMetaData, this.txCoordinator, this.txCoordinator);
            this.activeStatements.add(stmt);
            FBCallableStatement fBCallableStatement = stmt;
            return fBCallableStatement;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    private int getNextSavepointCounter() {
        return SAVEPOINT_COUNTER_UPDATE.getAndIncrement(this);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBSavepoint savepoint = new FBSavepoint(this.getNextSavepointCounter());
            this.setSavepoint(savepoint);
            FBSavepoint fBSavepoint = savepoint;
            return fBSavepoint;
        }
    }

    private void setSavepoint(FBSavepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLException("Connection.setSavepoint() method cannot be used in auto-commit mode", "25000");
        }
        if (this.mc.inDistributedTransaction()) {
            throw FBConnection.connectionEnlistedInDistributedTransaction();
        }
        this.txCoordinator.ensureTransaction();
        this.getGDSHelper().executeImmediate(savepoint.toSavepointStatement(this.getQuoteStrategy()));
        this.savepoints.add(savepoint);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            FBSavepoint savepoint = new FBSavepoint(name);
            this.setSavepoint(savepoint);
            FBSavepoint fBSavepoint = savepoint;
            return fBSavepoint;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getAutoCommit()) {
                throw new SQLException("Connection.rollback(Savepoint) method cannot be used in auto-commit mode", "25000");
            }
            if (this.mc.inDistributedTransaction()) {
                throw FBConnection.connectionEnlistedInDistributedTransaction();
            }
            FBSavepoint fbSavepoint = this.validateSavepoint(savepoint);
            this.getGDSHelper().executeImmediate(fbSavepoint.toRollbackStatement(this.getQuoteStrategy()));
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.getAutoCommit()) {
                throw new SQLException("Connection.releaseSavepoint() method cannot be used in auto-commit mode", "25000");
            }
            FBSavepoint fbSavepoint = this.validateSavepoint(savepoint);
            this.getGDSHelper().executeImmediate(fbSavepoint.toReleaseStatement(this.getQuoteStrategy()));
            this.savepoints.remove(fbSavepoint);
        }
    }

    protected void invalidateSavepoints() {
        try (LockCloseable ignored = this.withLock();){
            this.savepoints.clear();
        }
    }

    FBSavepoint validateSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof FBSavepoint)) {
            throw new SQLException("Specified savepoint was not obtained from this connection");
        }
        FBSavepoint fbSavepoint = (FBSavepoint)savepoint;
        if (!this.savepoints.contains(fbSavepoint)) {
            throw new SQLException("Savepoint is no longer valid");
        }
        return fbSavepoint;
    }

    public FBLocalTransaction getLocalTransaction() {
        try (LockCloseable ignored = this.withLock();){
            if (this.localTransaction == null) {
                this.localTransaction = this.mc.getLocalTransaction();
            }
            FBLocalTransaction fBLocalTransaction = this.localTransaction;
            return fBLocalTransaction;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(FBConnection.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw FbExceptionBuilder.forException(337248338).messageParameter((Object)(iface != null ? iface.getName() : "(null)")).toSQLException();
        }
        return iface.cast(this);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkValidity();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkValidity();
        return null;
    }

    public void addWarning(SQLWarning warning) {
        try (LockCloseable ignored = this.withLock();){
            if (this.isIgnoreSQLWarnings()) {
                return;
            }
            if (this.firstWarning == null) {
                this.firstWarning = warning;
            } else {
                this.firstWarning.setNextWarning(warning);
            }
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        return (NClob)this.createClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkValidity();
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    public GDSHelper getGDSHelper() throws SQLException {
        if (this.mc == null) {
            throw FbExceptionBuilder.toException(335544363);
        }
        return this.mc.getGDSHelper();
    }

    @Override
    public boolean isUseFirebirdAutoCommit() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isUseFirebirdAutocommit();
    }

    ClientInfoProvider getClientInfoProvider() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            ClientInfoProvider clientInfoProvider = this.clientInfoProvider;
            if (clientInfoProvider != null) {
                ClientInfoProvider clientInfoProvider2 = clientInfoProvider;
                return clientInfoProvider2;
            }
            ClientInfoProvider clientInfoProvider3 = this.clientInfoProvider = new ClientInfoProvider(this);
            return clientInfoProvider3;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            Properties properties = this.getClientInfoProvider().getClientInfo();
            return properties;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            String string = this.getClientInfoProvider().getClientInfo(name);
            return string;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try (LockCloseable ignored = this.withLock();){
            this.getClientInfoProvider().setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            Map<String, ClientInfoStatus> failedProperties = properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), name -> ClientInfoStatus.REASON_UNKNOWN));
            throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), e.getErrorCode(), failedProperties, e);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try (LockCloseable ignored = this.withLock();){
            this.getClientInfoProvider().setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), e.getErrorCode(), Map.of(name, ClientInfoStatus.REASON_UNKNOWN), e);
        }
    }

    @Override
    public void resetKnownClientInfoProperties() {
        try (LockCloseable ignored = this.withLock();){
            if (this.isClosed()) {
                return;
            }
            ClientInfoProvider clientInfoProvider = this.clientInfoProvider;
            if (clientInfoProvider != null) {
                clientInfoProvider.resetKnownProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Executor executor) throws SQLException {
        FbDatabase fbDatabase;
        if (this.isClosed()) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION_CALL_ABORT);
        }
        if (executor == null) {
            throw FbExceptionBuilder.toException(337248297);
        }
        try {
            fbDatabase = this.getFbDatabase();
        }
        finally {
            this.metaData = null;
            FBManagedConnection mc = this.mc;
            if (mc != null) {
                this.mc = null;
                mc.close(this);
            }
        }
        executor.execute(() -> {
            try {
                try {
                    this.txCoordinator.handleConnectionAbort();
                }
                finally {
                    try {
                        fbDatabase.cancelOperation(4);
                    }
                    catch (SQLException e) {
                        log.log(System.Logger.Level.DEBUG, "Failed to raise abort on FbDatabase", (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                log.log(System.Logger.Level.DEBUG, "txCoordinator.handleConnectionAbort() caused an exception", (Throwable)e);
            }
            finally {
                try {
                    fbDatabase.forceClose();
                }
                catch (SQLException e) {
                    log.log(System.Logger.Level.DEBUG, "Could not forceClose FbDatabase on abort", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION_SET_NETWORK_TIMEOUT);
        }
        if (executor == null) {
            throw FbExceptionBuilder.toException(337248297);
        }
        if (milliseconds < 0) {
            throw FbExceptionBuilder.toException(337248296);
        }
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.getFbDatabase().setNetworkTimeout(milliseconds);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.getFbDatabase().getNetworkTimeout();
    }

    protected final LockCloseable withLock() {
        FBManagedConnection mc = this.mc;
        if (mc != null) {
            return mc.withLock();
        }
        return LockCloseable.NO_OP;
    }

    protected final boolean isLockedByCurrentThread() {
        FBManagedConnection mc = this.mc;
        if (mc != null) {
            return mc.isLockedByCurrentThread();
        }
        return false;
    }

    QuoteStrategy getQuoteStrategy() throws SQLException {
        return QuoteStrategy.forDialect(this.getGDSHelper().getDialect());
    }

    GeneratedKeysSupport getGeneratedKeysSupport() throws SQLException {
        if (this.generatedKeysSupport == null) {
            this.generatedKeysSupport = GeneratedKeysSupportFactory.createFor(this.getGeneratedKeysEnabled(), (FirebirdDatabaseMetaData)this.getMetaData());
        }
        return this.generatedKeysSupport;
    }

    private String getGeneratedKeysEnabled() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null ? props.getGeneratedKeysEnabled() : null;
    }

    boolean isIgnoreProcedureType() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isIgnoreProcedureType();
    }

    boolean isScrollableCursor(String scrollableCursor) {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && scrollableCursor != null && scrollableCursor.equalsIgnoreCase(props.getScrollableCursor());
    }

    boolean isUseServerBatch() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isUseServerBatch();
    }

    int getServerBatchBufferSize() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null ? props.getServerBatchBufferSize() : 0;
    }

    boolean isExtendedMetadata() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && props.isExtendedMetadata();
    }

    boolean isIgnoreSQLWarnings() {
        DatabaseConnectionProperties props = this.connectionProperties();
        return props != null && "NONE".equalsIgnoreCase(props.getReportSQLWarnings());
    }
}

