/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.TransactionParameterBufferImpl;
import org.firebirdsql.jaybird.fb.constants.TpbItems;
import org.firebirdsql.jaybird.props.internal.TransactionNameMapping;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public final class FBTpbMapper
implements Serializable {
    private static final long serialVersionUID = 1690658870275668176L;
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    private static final List<String> ISOLATION_LEVEL_NAMES = List.of("TRANSACTION_SERIALIZABLE", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_READ_COMMITTED");
    public static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    public static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    private final Map<Integer, TransactionParameterBuffer> mapping;
    private int defaultIsolationLevel = 2;

    public static FBTpbMapper getDefaultMapper() {
        return new FBTpbMapper();
    }

    public static String getTransactionIsolationName(int isolationLevel) {
        return TransactionNameMapping.toIsolationLevelName(isolationLevel);
    }

    public static int getTransactionIsolationLevel(String isolationName) {
        return TransactionNameMapping.toIsolationLevel(isolationName);
    }

    public FBTpbMapper() {
        TransactionParameterBufferImpl serializableTpb = new TransactionParameterBufferImpl();
        serializableTpb.addArgument(9);
        serializableTpb.addArgument(6);
        serializableTpb.addArgument(1);
        TransactionParameterBufferImpl repeatableReadTpb = new TransactionParameterBufferImpl();
        repeatableReadTpb.addArgument(9);
        repeatableReadTpb.addArgument(6);
        repeatableReadTpb.addArgument(2);
        TransactionParameterBufferImpl readCommittedTpb = new TransactionParameterBufferImpl();
        readCommittedTpb.addArgument(9);
        readCommittedTpb.addArgument(6);
        readCommittedTpb.addArgument(15);
        readCommittedTpb.addArgument(17);
        ConcurrentHashMap<Integer, TransactionParameterBuffer> mapping = new ConcurrentHashMap<Integer, TransactionParameterBuffer>(3);
        mapping.put(8, serializableTpb);
        mapping.put(4, repeatableReadTpb);
        mapping.put(2, readCommittedTpb);
        this.mapping = mapping;
    }

    public FBTpbMapper(Map<String, String> stringMapping) throws SQLException {
        this();
        this.processMapping(stringMapping);
    }

    private FBTpbMapper(FBTpbMapper source) {
        ConcurrentHashMap<Integer, TransactionParameterBuffer> newMapping = new ConcurrentHashMap<Integer, TransactionParameterBuffer>(source.mapping.size());
        for (Map.Entry<Integer, TransactionParameterBuffer> entry : source.mapping.entrySet()) {
            newMapping.put(entry.getKey(), entry.getValue().deepCopy());
        }
        this.mapping = newMapping;
        this.defaultIsolationLevel = source.defaultIsolationLevel;
    }

    private void processMapping(Map<String, String> stringMapping) throws SQLException {
        for (Map.Entry<String, String> entry : stringMapping.entrySet()) {
            int isolationLevel;
            String jdbcTxIsolation = entry.getKey();
            try {
                isolationLevel = FBTpbMapper.getTransactionIsolationLevel(jdbcTxIsolation);
            }
            catch (IllegalArgumentException ex) {
                throw new SQLException(FBTpbMapper.unsupportedIsolationLevel(jdbcTxIsolation));
            }
            TransactionParameterBuffer tpb = FBTpbMapper.processMapping(entry.getValue());
            this.mapping.put(isolationLevel, tpb);
        }
    }

    private static String unsupportedIsolationLevel(int isolationLevel) {
        return FBTpbMapper.unsupportedIsolationLevel(String.valueOf(isolationLevel));
    }

    private static String unsupportedIsolationLevel(String jdbcTxIsolation) {
        return "Transaction isolation " + jdbcTxIsolation + " is not supported.";
    }

    public FBTpbMapper(String mappingResource, ClassLoader cl) throws SQLException {
        this();
        if (mappingResource.startsWith("res:")) {
            mappingResource = mappingResource.substring(4);
        }
        try {
            ResourceBundle res = ResourceBundle.getBundle(mappingResource, Locale.getDefault(), cl);
            HashMap<String, String> mapping = new HashMap<String, String>();
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                mapping.put(key, res.getString(key));
            }
            this.processMapping(mapping);
        }
        catch (MissingResourceException mrex) {
            throw new SQLException("Cannot load TPB mapping. " + mrex.getMessage(), mrex);
        }
    }

    public static void processMapping(FirebirdConnectionProperties connectionProperties, Properties info2) throws SQLException {
        for (String isolationName : ISOLATION_LEVEL_NAMES) {
            String property = info2.getProperty(isolationName);
            if (property == null) continue;
            connectionProperties.setTransactionParameters(FBTpbMapper.getTransactionIsolationLevel(isolationName), FBTpbMapper.processMapping(property));
        }
    }

    public static void processMapping(FirebirdConnectionProperties connectionProperties, Map<String, String> info2) throws SQLException {
        for (String isolationName : ISOLATION_LEVEL_NAMES) {
            String property = info2.get(isolationName);
            if (property == null) continue;
            connectionProperties.setTransactionParameters(FBTpbMapper.getTransactionIsolationLevel(isolationName), FBTpbMapper.processMapping(property));
        }
    }

    public static TransactionParameterBuffer processMapping(String mapping) throws SQLException {
        TransactionParameterBufferImpl result = new TransactionParameterBufferImpl();
        StringTokenizer st = new StringTokenizer(mapping, ",");
        while (st.hasMoreTokens()) {
            Integer value;
            String token = st.nextToken();
            Integer argValue = null;
            if (token.contains("=")) {
                String[] parts = token.split("=");
                try {
                    argValue = Integer.valueOf(parts[1]);
                }
                catch (NumberFormatException ex) {
                    throw new SQLException(parts[1] + " is not valid integer value");
                }
                token = parts[0];
            }
            if ((value = TpbMapping.getTpbParam(token)) == null) {
                throw new SQLException("Keyword " + token + " unknown. Please check your mapping.");
            }
            if (argValue == null) {
                result.addArgument(value);
                continue;
            }
            result.addArgument((int)value, argValue);
        }
        return result;
    }

    public TransactionParameterBuffer getMapping(int transactionIsolation) {
        TransactionParameterBuffer tpb = this.mapping.get(transactionIsolation != 1 ? transactionIsolation : 2);
        if (tpb == null) {
            throw new IllegalArgumentException(FBTpbMapper.unsupportedIsolationLevel(transactionIsolation));
        }
        return tpb.deepCopy();
    }

    public void setMapping(int transactionIsolation, TransactionParameterBuffer tpb) {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                this.mapping.put(transactionIsolation, tpb.deepCopy());
                break;
            }
            default: {
                throw new IllegalArgumentException(FBTpbMapper.unsupportedIsolationLevel(transactionIsolation));
            }
        }
    }

    public TransactionParameterBuffer getDefaultMapping() {
        return this.getMapping(this.defaultIsolationLevel);
    }

    int getDefaultTransactionIsolation() {
        return this.defaultIsolationLevel;
    }

    void setDefaultTransactionIsolation(int isolationLevel) {
        this.defaultIsolationLevel = isolationLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FBTpbMapper)) return false;
        FBTpbMapper that = (FBTpbMapper)obj;
        if (!this.mapping.equals(that.mapping)) return false;
        if (this.defaultIsolationLevel != that.defaultIsolationLevel) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.mapping, this.defaultIsolationLevel);
    }

    public static FBTpbMapper copyOf(FBTpbMapper tpbMapper) {
        return new FBTpbMapper(tpbMapper);
    }

    private static final class TpbMapping {
        private static final String TPB_PREFIX = "isc_tpb_";
        private static final Map<String, Integer> tpbTypes;

        private TpbMapping() {
        }

        private static Integer getTpbParam(String name) {
            return tpbTypes.get(name);
        }

        static {
            Field[] fields;
            HashMap<String, Integer> tempTpbTypes = new HashMap<String, Integer>(64);
            for (Field field : fields = TpbItems.class.getFields()) {
                String name = field.getName();
                if (!name.startsWith(TPB_PREFIX) || !field.getType().equals(Integer.TYPE)) continue;
                try {
                    Integer value = field.getInt(null);
                    tempTpbTypes.put(name.substring(TPB_PREFIX.length()), value);
                    tempTpbTypes.put(name, value);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            tpbTypes = Map.copyOf(tempTpbTypes);
        }
    }
}

