/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;

public class DatabaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseUtils.class);

    public static void clear(Console console, Database dbdst, String strTables) {
        String[] tbls = strTables.split("\\s*,\\s*");
        try (Statement st = dbdst.getConnection().createStatement();){
            for (String tbl : tbls) {
                console.print("clear " + tbl + ":");
                String sql = "delete from " + tbl;
                st.executeUpdate(sql);
                dbdst.commit();
                console.print(" OK\n");
            }
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                dbdst.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copygen(Console console, Database dbdst, String tbl, String gen, String id) {
        console.print("set " + gen + ":");
        String sql = "select max(" + id + ") from " + tbl;
        try (Statement st = dbdst.getConnection().createStatement();
             ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                int value = rs.getInt(1);
                sql = "ALTER SEQUENCE " + gen + " RESTART WITH " + value;
                st.executeUpdate(sql);
            }
            dbdst.commit();
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                dbdst.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        console.print(" OK\n");
    }

    public static void copytbl(Console console, Database dbsrc, Database dbdst, String tbl, String strColumns) {
        DatabaseUtils.copytbl(console, dbsrc, dbdst, tbl, strColumns, "", "");
    }

    public static void copytbl(Console console, Database dbsrc, Database dbdst, String tbl, String strColumns, String checkIdField, String checkIdTable) {
        console.print("copy " + tbl + ": ");
        try (Statement stsrc = dbsrc.getConnection().createStatement();){
            ResultSet rs;
            String sql;
            if (!dbsrc.hasTable(stsrc, "", tbl)) {
                console.print("source table not found!\n");
                return;
            }
            if (strColumns.equals("*")) {
                Set<String> srcColumns = DatabaseUtils.getColumnSet(dbsrc, tbl);
                Set<String> dstColumns = DatabaseUtils.getColumnSet(dbdst, tbl);
                srcColumns.retainAll(dstColumns);
                strColumns = srcColumns.stream().collect(Collectors.joining(","));
            }
            boolean checkId = !checkIdField.isEmpty() && !checkIdTable.isEmpty();
            HashSet<Integer> ids = new HashSet<Integer>();
            if (checkId) {
                sql = "select " + checkIdField + " from " + checkIdTable;
                rs = stsrc.executeQuery(sql);
                try {
                    while (rs.next()) {
                        ids.add(rs.getInt(1));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            sql = "select " + strColumns + " from " + tbl;
            rs = stsrc.executeQuery(sql);
            try {
                ResultSetMetaData md = rs.getMetaData();
                int n = md.getColumnCount();
                sql = "insert into " + tbl + " (" + strColumns + ") values (";
                for (int i = 1; i <= n; ++i) {
                    sql = sql + (i > 1 ? ", ?" : "?");
                }
                sql = sql + ")";
                boolean skip = false;
                int cnt1 = 0;
                int cnt2 = tbl.length() + 7;
                PreparedStatement dst = dbdst.getConnection().prepareStatement(sql);
                while (rs.next()) {
                    skip = false;
                    block29: for (int i = 1; i <= n; ++i) {
                        if (checkId && md.getColumnName(i).equals(checkIdField) && !ids.contains(rs.getInt(i))) {
                            skip = true;
                            break;
                        }
                        switch (md.getColumnType(i)) {
                            case -5: 
                            case 4: 
                            case 5: {
                                dst.setLong(i, rs.getLong(i));
                                continue block29;
                            }
                            case 93: {
                                dst.setTimestamp(i, rs.getTimestamp(i));
                                continue block29;
                            }
                            default: {
                                dst.setString(i, rs.getString(i));
                            }
                        }
                    }
                    if (skip) continue;
                    dst.executeUpdate();
                    if (cnt1++ <= 500) continue;
                    cnt1 = 0;
                    console.print("*");
                    dbdst.commit();
                    if (cnt2++ <= 80) continue;
                    cnt2 = 0;
                    console.print("\n");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            dbdst.commit();
            dbsrc.commit();
            console.print(" OK\n");
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                dbsrc.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dbdst.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Set<String> getColumnSet(Database db, String tbl) throws SQLException {
        HashSet<String> res = new HashSet<String>();
        String sql = "select * from " + tbl;
        try (Statement st = db.getConnection().createStatement();
             ResultSet rs = st.executeQuery(sql);){
            ResultSetMetaData md = rs.getMetaData();
            int n = md.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                res.add(md.getColumnName(i));
            }
        }
        return res;
    }

    public static void sweep(Console console, Database db, String table, String dtfield, int year) {
        String dt = year + ".12.31 23.59.59.999";
        String sql = "delete from " + table + " where " + dtfield + " <= '" + dt + "'";
        try (Statement st = db.getConnection().createStatement();){
            console.print("delete from " + table + "...");
            int cnt = st.executeUpdate(sql);
            db.commit();
            console.print(" " + cnt + " records\n");
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(logger, e, new String[0]);
            try {
                db.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

