/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import org.slf4j.Logger;
import promauto.jroboplc.core.KeyManagerImpl;
import promauto.jroboplc.core.LoggerMode;
import promauto.jroboplc.core.api.CmdDispatcher;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.ConsoleManager;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.KeyManager;
import promauto.jroboplc.core.api.ModuleManager;
import promauto.jroboplc.core.api.SerialManager;
import promauto.jroboplc.core.api.TaskManager;
import promauto.jroboplc.core.api.TcpServer;
import promauto.jroboplc.core.tags.RefFactory;
import promauto.jroboplc.core.tags.RefFactoryImpl;
import promauto.utils.Strings;

public class EnvironmentImpl
implements Environment {
    private LoggerMode loggerMode = null;
    private Configuration configuration = null;
    private CmdDispatcher cmdDispatcher = null;
    private ModuleManager moduleManager = null;
    private TaskManager taskManager = null;
    private ConsoleManager consoleManager = null;
    private Console console = null;
    private SerialManager serialManager = null;
    private TcpServer tcpserver = null;
    private volatile boolean terminated = false;
    private volatile boolean running = false;
    private XMLInputFactory xmlif = null;
    private KeyManager keyManager = null;
    private RefFactory refFactory = null;

    @Override
    public LoggerMode getLoggerMode() {
        return this.loggerMode;
    }

    public void setLoggerMode(LoggerMode loggerMode) {
        this.loggerMode = loggerMode;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            EnvironmentImpl environmentImpl = this;
            synchronized (environmentImpl) {
                if (this.keyManager == null) {
                    this.keyManager = new KeyManagerImpl();
                }
            }
        }
        return this.keyManager;
    }

    @Override
    public CmdDispatcher getCmdDispatcher() {
        return this.cmdDispatcher;
    }

    @Override
    public void setCmdDispatcher(CmdDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    @Override
    public ConsoleManager getConsoleManager() {
        return this.consoleManager;
    }

    @Override
    public void setConsoleManager(ConsoleManager consoleManager) {
        this.consoleManager = consoleManager;
    }

    @Override
    public Console getConsole() {
        return this.console;
    }

    @Override
    public void setConsole(Console console) {
        if (this.console != null && this.consoleManager != null) {
            this.consoleManager.removeConsole(this.console);
        }
        if (this.consoleManager != null) {
            this.consoleManager.addConsole(console);
        }
        this.console = console;
    }

    @Override
    public TcpServer getTcpServer() {
        return this.tcpserver;
    }

    @Override
    public SerialManager getSerialManager() {
        return this.serialManager;
    }

    @Override
    public void setSerialManager(SerialManager serialManager) {
        this.serialManager = serialManager;
    }

    @Override
    public void setTcpServer(TcpServer tcpserver) {
        this.tcpserver = tcpserver;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated() {
        this.terminated = true;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean status) {
        this.running = status;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public XMLInputFactory getXMLInputFactory() throws FactoryConfigurationError {
        if (this.xmlif == null) {
            this.xmlif = XMLInputFactory.newInstance();
            this.xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
            this.xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", true);
            this.xmlif.setProperty("javax.xml.stream.isCoalescing", false);
        }
        return this.xmlif;
    }

    @Override
    public RefFactory getRefFactory() {
        if (this.refFactory == null) {
            this.refFactory = new RefFactoryImpl();
        }
        return this.refFactory;
    }

    @Override
    public void printError(Logger logger, String ... text) {
        this.printError(logger, (Throwable)null, text);
    }

    @Override
    public void printError(Logger logger, Throwable e, String ... text) {
        String s = String.join((CharSequence)" ", text);
        this.print("\u001b[31m\r\n[ERROR] " + (String)(logger == null ? "" : logger.getName() + ": ") + s + (String)(e == null ? "" : "\r\n" + e.toString()) + "\r\n\u001b[0m");
        this.logError(logger, e, s);
    }

    @Override
    public void logError(Logger logger, String ... text) {
        this.logError(logger, (Throwable)null, text);
    }

    @Override
    public void logError(Logger logger, Throwable e, String ... text) {
        if (logger != null) {
            String s = Strings.removeAnsiColors(String.join((CharSequence)" ", text));
            if (e == null) {
                logger.error(s);
            } else {
                logger.error(s, e);
            }
            logger.info("[ERROR] " + (String)(logger == null ? "" : logger.getName() + ": ") + s + (String)(e == null ? "" : "\r\n" + e.toString() + "\r\n"));
        }
    }

    @Override
    public void printInfo(Logger logger, String ... text) {
        String s = String.join((CharSequence)" ", text);
        this.print("\u001b[34m\r\n[INFO] " + s + "\r\n\u001b[0m");
        this.logInfo(logger, s);
    }

    @Override
    public void logInfo(Logger logger, String ... text) {
        if (logger != null) {
            logger.info("[INFO] " + Strings.removeAnsiColors(String.join((CharSequence)" ", text)));
        }
    }

    @Override
    public void print(String text) {
        if (this.consoleManager != null) {
            this.consoleManager.printToAll(text);
        } else {
            System.out.println(text);
        }
    }

    @Override
    public void logStatus(Logger logger, String ... text) {
        if (logger != null) {
            logger.info("[STATUS] " + Strings.removeAnsiColors(String.join((CharSequence)" ", text)));
        }
    }
}

