/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.KeyManager;

public class KeyManagerImpl
implements KeyManager {
    private final Logger logger = LoggerFactory.getLogger(KeyManagerImpl.class);
    public static final String PUBLIC_EXTENSION = ".pub";
    private final Path keysDir;
    private final Map<String, Key> keys = new HashMap<String, Key>();

    public KeyManagerImpl() {
        Security.addProvider(new BouncyCastleProvider());
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.keysDir = cm.getPath(cm.getRoot(), "keys.dir", "keys");
    }

    @Override
    public String encryptPublic(String keyName, String decryptedText) throws Exception {
        RSAPublicKey publicKey = this.readPublicKey(keyName);
        Cipher encryptCipher = Cipher.getInstance("RSA");
        encryptCipher.init(1, publicKey);
        byte[] encryptedTextBytes = encryptCipher.doFinal(decryptedText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedTextBytes);
    }

    @Override
    public String decryptPrivate(String keyName, String enryptedText) throws Exception {
        RSAPrivateKey privateKey = this.readPrivateKey(keyName);
        Cipher decryptCipher = Cipher.getInstance("RSA");
        decryptCipher.init(2, privateKey);
        byte[] encryptedTextBytes = Base64.getDecoder().decode(enryptedText);
        byte[] decryptedTextBytes = decryptCipher.doFinal(encryptedTextBytes);
        return new String(decryptedTextBytes, StandardCharsets.UTF_8);
    }

    @Override
    public String generateAndSaveKeyPair(String keyName) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024);
            KeyPair kp = generator.generateKeyPair();
            String privateKeyText = "-----BEGIN PRIVATE KEY-----\r\n" + Base64.getMimeEncoder().encodeToString(kp.getPrivate().getEncoded()) + "\r\n-----END PRIVATE KEY-----";
            String publicKeyText = "-----BEGIN PUBLIC KEY-----\r\n" + Base64.getMimeEncoder().encodeToString(kp.getPublic().getEncoded()) + "\r\n-----END PUBLIC KEY-----";
            if (((String)keyName).isEmpty()) {
                while (Files.exists(this.keysDir.resolve((String)(keyName = "key" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")))), new LinkOption[0]) || Files.exists(this.keysDir.resolve((String)keyName + PUBLIC_EXTENSION), new LinkOption[0])) {
                }
            }
            Files.createDirectories(this.keysDir, new FileAttribute[0]);
            Files.write(this.keysDir.resolve((String)keyName), privateKeyText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(this.keysDir.resolve((String)keyName + PUBLIC_EXTENSION), publicKeyText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, "Failed to generate keys: " + (String)keyName);
        }
        return keyName;
    }

    @Override
    public String getDefaultPrivateKeyName() {
        try {
            List found = Files.find(this.keysDir, 1, (path, attr) -> !path.toString().endsWith(PUBLIC_EXTENSION) && attr.isRegularFile(), new FileVisitOption[0]).collect(Collectors.toList());
            if (found.size() == 1) {
                return ((Path)found.get(0)).getFileName().toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private RSAPublicKey readPublicKey(String keyName) throws Exception {
        Key key = this.keys.get(keyName = (String)keyName + PUBLIC_EXTENSION);
        if (key != null) {
            return (RSAPublicKey)key;
        }
        Path path = this.keysDir.resolve((String)keyName);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        try (FileReader keyReader = new FileReader(path.toFile());){
            RSAPublicKey rSAPublicKey;
            try (PemReader pemReader = new PemReader(keyReader);){
                PemObject pemObject = pemReader.readPemObject();
                byte[] content = pemObject.getContent();
                X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
                RSAPublicKey rsaPublicKey = (RSAPublicKey)factory.generatePublic(pubKeySpec);
                this.keys.put((String)keyName, rsaPublicKey);
                rSAPublicKey = rsaPublicKey;
            }
            return rSAPublicKey;
        }
    }

    private RSAPrivateKey readPrivateKey(String keyName) throws Exception {
        Key key = this.keys.get(keyName);
        if (key != null) {
            return (RSAPrivateKey)key;
        }
        Path path = this.keysDir.resolve(keyName);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        try (FileReader keyReader = new FileReader(path.toFile());){
            RSAPrivateKey rSAPrivateKey;
            try (PemReader pemReader = new PemReader(keyReader);){
                PemObject pemObject = pemReader.readPemObject();
                byte[] content = pemObject.getContent();
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(content);
                RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)factory.generatePrivate(privKeySpec);
                this.keys.put(keyName, rsaPrivateKey);
                rSAPrivateKey = rsaPrivateKey;
            }
            return rSAPrivateKey;
        }
    }
}

