/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Task;
import promauto.jroboplc.core.api.TaskManager;

public class TaskManagerImpl
implements TaskManager {
    private final Logger logger = LoggerFactory.getLogger(TaskManagerImpl.class);
    private final Environment env;

    public TaskManagerImpl(Environment env) {
        this.env = env;
    }

    @Override
    public String start() {
        if (this.env.isRunning()) {
            return "Already started";
        }
        this.env.logStatus(this.logger, "*** START ***");
        boolean status = true;
        for (JrModule m : this.env.getModuleManager().getModules()) {
            try {
                if (status &= m.prepare()) continue;
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, "Unhandled exception while preparing module:", m.getName());
                status = false;
            }
            break;
        }
        this.env.setRunning(status);
        if (status) {
            for (JrModule m : this.env.getModuleManager().getModules()) {
                if (!(m instanceof Task)) continue;
                m.execute();
            }
            this.env.logStatus(this.logger, "*** RUN ***");
        } else {
            this.env.printError(this.logger, "Start failed, rolling back...");
            this.stop();
        }
        return status ? "OK" : "FAILED";
    }

    @Override
    public String stop() {
        this.env.logStatus(this.logger, "*** STOP ***");
        this.env.setRunning(false);
        for (JrModule m : this.env.getModuleManager().getModules()) {
            if (!(m instanceof Task)) continue;
            m.closedown();
        }
        for (JrModule m : this.env.getModuleManager().getModules()) {
            if (m instanceof Task) continue;
            m.closedown();
        }
        this.env.logStatus(this.logger, "*** IDLE ***");
        return "OK";
    }

    @Override
    public Task getTask(JrModule module) {
        return this.getTask(module.getName());
    }

    @Override
    public Task getTask(String modname) {
        for (JrModule m : this.env.getModuleManager().getModules()) {
            Task task;
            if (!(m instanceof Task) || !(task = (Task)((Object)m)).hasModule(modname)) continue;
            return task;
        }
        return null;
    }
}

