/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.TagRepository;

public interface Database
extends JrModule {
    public void registerEventNotification(String var1);

    public DatabaseType getType();

    public Connection getConnection();

    public boolean isConnected();

    public DateTimeFormatter getTimestampFormatter();

    public List<String> loadScriptFromFile(String var1);

    public List<String> loadScriptFromResource(Class<?> var1, String var2);

    public ScriptResult executeScript(String var1, Map<String, String> var2);

    public ScriptResult executeScript(String var1);

    public boolean hasScript(String var1);

    public String getSchemaDelimiter();

    public String makeSchemaObjectName(String var1, String var2);

    public boolean hasSchema(Statement var1, String var2) throws SQLException;

    public boolean hasDomain(Statement var1, String var2, String var3) throws SQLException;

    public boolean hasTable(Statement var1, String var2, String var3) throws SQLException;

    public boolean hasColumn(Statement var1, String var2, String var3, String var4) throws SQLException;

    public boolean hasConstraint(Statement var1, String var2, String var3, String var4) throws SQLException;

    public boolean hasIndex(Statement var1, String var2, String var3) throws SQLException;

    public boolean hasTrigger(Statement var1, String var2, String var3) throws SQLException;

    public boolean hasProcedure(Statement var1, String var2, String var3) throws SQLException;

    public boolean hasRecord(Statement var1, String var2) throws SQLException;

    public Integer insertReturningId(Statement var1, String var2, String ... var3) throws SQLException;

    public void commit() throws SQLException;

    public void rollback();

    public TagRepository createTagRepository(String var1, String var2);

    public long getServerTimerOffset();

    public LocalDateTime getServerDatetime();

    public String formatDatetimeWithOffset(LocalDateTime var1);

    public String formatDatetime(LocalDateTime var1);

    public static class ScriptResult {
        public boolean success = false;
        public int executedDoCount;
        public int positiveIfCount;
    }

    public static enum DatabaseType {
        FIREBIRD;

    }
}

