/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.cmd;

import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Task;
import promauto.jroboplc.core.api.TaskManager;

public class CmdModinfo
extends AbstractCommand {
    final Logger logger = LoggerFactory.getLogger(CmdModinfo.class);

    @Override
    public String getName() {
        return "i";
    }

    @Override
    public String getUsage() {
        return "[mod]";
    }

    @Override
    public String getDescription() {
        return "module info";
    }

    @Override
    public String execute(Console console, String args) {
        Set<JrModule> mods = EnvironmentInst.get().getModuleManager().getModules();
        Pattern pattern = null;
        try {
            if (!args.isEmpty()) {
                pattern = Pattern.compile(args);
            }
        }
        catch (PatternSyntaxException e) {
            EnvironmentInst.get().printError(this.logger, e, "Pattern compilation error:", args);
        }
        TreeMap<CallSite, JrModule> map = new TreeMap<CallSite, JrModule>();
        int moduleWidth = 6;
        int pluginWidth = 6;
        int taskWidth = 6;
        for (JrModule m : mods) {
            int w = m.getName().length();
            if (moduleWidth < w) {
                moduleWidth = w;
            }
            if (m instanceof Task && taskWidth < w) {
                taskWidth = w;
            }
            if (pluginWidth < (w = m.getPlugin().getPluginName().length())) {
                pluginWidth = w;
            }
            map.put((CallSite)((Object)(m.getPlugin().getPluginName() + m.getName())), m);
        }
        int totalWidth = (moduleWidth += 2) + (pluginWidth += 2) + (taskWidth += 2);
        StringBuilder sb = new StringBuilder();
        String fmtplg = "%-" + pluginWidth + "s";
        String fmtmod = "%-" + moduleWidth + "s";
        String fmttsk = "%-" + taskWidth + "s";
        String fmt2 = "%-" + totalWidth + "s%s\r\n";
        sb.append("\u001b[01m");
        sb.append(String.format(fmtmod, "MODULE"));
        sb.append(String.format(fmtplg, "PLUGIN"));
        sb.append(String.format(fmttsk, "TASK"));
        sb.append("INFORMATION");
        sb.append("\r\n");
        sb.append("\u001b[0m");
        TaskManager tm = EnvironmentInst.get().getTaskManager();
        for (JrModule m : map.values()) {
            if (pattern != null && !pattern.matcher(m.getName()).matches()) continue;
            String[] info2 = m.getInfo().split("\r\n");
            sb.append("\u001b[33m");
            sb.append(String.format(fmtmod, m.getName()));
            sb.append("\u001b[0m");
            sb.append("\u001b[32m");
            sb.append(String.format(fmtplg, m.getPlugin().getPluginName()));
            sb.append("\u001b[0m");
            sb.append("\u001b[33m");
            String taskname = "";
            Task task = tm.getTask(m);
            if (task != null) {
                taskname = task.getName();
                if (task.isRunning()) {
                    sb.append("\u001b[01m");
                }
            } else if (m.isTaskable()) {
                taskname = "---";
            }
            sb.append(String.format(fmttsk, taskname));
            sb.append("\u001b[0m");
            sb.append((String)info2[0]);
            sb.append("\r\n");
            for (int i = 1; i < info2.length; ++i) {
                sb.append(String.format(fmt2, " ", info2[i]));
            }
        }
        if (args.isEmpty()) {
            sb.append("\u001b[01m");
            sb.append(String.format(fmtmod, "\r\nTOTALS:"));
            sb.append("\r\n");
            sb.append("\u001b[0m");
            LinkedHashMap<String, CallSite> totals = new LinkedHashMap<String, CallSite>();
            totals.put("modules", (CallSite)((Object)("" + mods.size())));
            int totaltags = 0;
            for (JrModule mod : mods) {
                totaltags += mod.getTagTable().getSize();
            }
            totals.put("tags", (CallSite)((Object)("" + totaltags)));
            String fmt = "%-12s";
            for (Map.Entry ent : totals.entrySet()) {
                sb.append("\u001b[32m");
                sb.append(String.format(fmt, ent.getKey()));
                sb.append("\u001b[0m");
                sb.append((String)ent.getValue());
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }
}

