/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.core.cmd;

import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Tag;

public class CmdStx
extends AbstractCommand {
    private final Logger logger = LoggerFactory.getLogger(CmdStx.class);

    @Override
    public String getName() {
        return "stx";
    }

    @Override
    public String getUsage() {
        return "mod tag val";
    }

    @Override
    public String getDescription() {
        return "sets a new value to a group of tags, where \u001b[32mmod\u001b[0m and \u001b[32mtag\u001b[0m are regex expressions";
    }

    @Override
    public String execute(Console console, String args) {
        Environment env = EnvironmentInst.get();
        String[] ss = args.split("\\s* \\s*", 3);
        if (ss.length != 3) {
            return "";
        }
        Object result = "";
        Pattern pmod = Pattern.compile(ss[0]);
        Pattern ptag = Pattern.compile(ss[1]);
        TreeMap<CallSite, Tag> map = new TreeMap<CallSite, Tag>();
        for (JrModule jrModule : env.getModuleManager().getModules()) {
            if (!pmod.matcher(jrModule.getName()).matches()) continue;
            for (Tag tag : jrModule.getTagTable().getMap().values()) {
                if (!ptag.matcher(tag.getName()).matches()) continue;
                map.put((CallSite)((Object)(jrModule.getName() + ":" + tag.getName())), tag);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            try {
                ((Tag)entry.getValue()).setString(ss[2]);
            }
            catch (NumberFormatException e) {
                EnvironmentInst.get().printError(this.logger, e, new String[0]);
                return result;
            }
            result = (String)result + (String)entry.getKey() + " = " + ((Tag)entry.getValue()).getString() + "\r\n";
        }
        return result;
    }
}

