/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.arcsvr.ArcsvrModule;
import promauto.jroboplc.plugin.arcsvr.MesBase;
import promauto.jroboplc.plugin.arcsvr.MesPlain;
import promauto.jroboplc.plugin.arcsvr.MesRegex;
import promauto.jroboplc.plugin.arcsvr.MesRobo;
import promauto.utils.IniFile;
import promauto.utils.ParamsMap;

public class MesHolder {
    public static final String STR_SERVER_ARCH = "\u0421\u0435\u0440\u0432\u0435\u0440 \u0430\u0440\u0445\u0438\u0432\u0430\u0446\u0438\u0438";
    public static final int CLB_START = 0xFF8000;
    public static final int CLF_START = 0xFFFFFF;
    public static final int CLB_STOP = 9192960;
    public static final int CLF_STOP = 0xFFFFFF;
    public static final int CLB_ERROR = 0;
    public static final int CLF_ERROR = 255;
    private final Logger logger = LoggerFactory.getLogger(MesHolder.class);
    private static final Charset charset = Charset.forName("windows-1251");
    protected final ArcsvrModule module;
    protected final Environment env;
    protected Map<Integer, MesBase> mess = new TreeMap<Integer, MesBase>();
    private boolean enable;
    private Map<String, Integer> places = new HashMap<String, Integer>();
    private boolean version2;
    private PreparedStatement pstInsert = null;
    private PreparedStatement pstUpdateDtend = null;
    private PreparedStatement pstUpdateDtack = null;

    public MesHolder(ArcsvrModule module) {
        this.module = module;
        this.env = EnvironmentInst.get();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isVersion2() {
        return this.version2;
    }

    public PreparedStatement getPstInsert() {
        return this.pstInsert;
    }

    public PreparedStatement getPstUpdateDtend() {
        return this.pstUpdateDtend;
    }

    public PreparedStatement getPstUpdateDtack() {
        return this.pstUpdateDtack;
    }

    public boolean load(Object conf) {
        int id;
        Configuration cm = this.env.getConfiguration();
        this.version2 = cm.get(conf, "version", 1) == 2;
        boolean res = true;
        this.mess.clear();
        for (String o : cm.getStringList(conf, "arcmes.robo")) {
            res &= this.loadFile(o.toString());
        }
        for (Object conf_plain : cm.toList(cm.get(conf, "arcmes.plain"))) {
            id = cm.get(conf_plain, "id", 0);
            if (this.mess.containsKey(id)) {
                this.env.printError(this.logger, this.module.getName(), "id=" + id, "Duplicate name");
                return false;
            }
            MesPlain mesplain = new MesPlain(this, id);
            res &= mesplain.load(conf_plain);
            this.mess.put(id, mesplain);
        }
        for (Object conf_regex : cm.toList(cm.get(conf, "arcmes.regex"))) {
            id = cm.get(conf_regex, "id", 0);
            if (this.mess.containsKey(id)) {
                this.env.printError(this.logger, this.module.getName(), "id=" + id, "Duplicate name");
                return false;
            }
            MesRegex arcval = new MesRegex(this, id);
            res &= arcval.load(conf_regex);
            this.mess.put(id, arcval);
        }
        this.enable = this.mess.size() > 0;
        return res;
    }

    private boolean loadFile(String pathplace) {
        String[] ss = pathplace.split(";");
        Path path = Paths.get(ss[0].trim(), new String[0]);
        path = path.isAbsolute() ? path : this.env.getConfiguration().getConfDir().resolve(path);
        String place = ss.length > 1 ? ss[1].trim() : this.module.getPlaceName();
        try {
            IniFile ini = new IniFile(path);
            String tagpath = ini.getString("MesLogMain", "OpcAccessPath", "");
            int mescount = ini.getInt("MesLogMain", "MesCount", 0);
            for (int mesnum = 0; mesnum < mescount; ++mesnum) {
                String section = "MesLogArc" + mesnum;
                int id = ini.getInt(section, "MesId", 0);
                int alarm = ini.getInt(section, "Alarm", 0);
                if (alarm == 0) continue;
                MesBase mesbase = this.mess.get(id);
                if (mesbase != null && !(mesbase instanceof MesRobo)) {
                    this.env.printError(this.logger, this.module.getName(), "id=" + id, "Duplicate name");
                    return false;
                }
                MesRobo mes = (MesRobo)mesbase;
                if (mes == null) {
                    mes = new MesRobo(this, id);
                    this.mess.put(id, mes);
                }
                mes.load(ini, section, tagpath, place);
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, "File loading error:", path.toString());
            return false;
        }
        return true;
    }

    public void link() {
        if (!this.enable) {
            return;
        }
        for (MesBase mes : this.mess.values()) {
            mes.link();
        }
    }

    public boolean init() {
        if (!this.enable) {
            return true;
        }
        ParamsMap params = new ParamsMap("schema=" + this.module.getSchema());
        if (!(this.module.getDatabase().executeScript((String)"arcsvr_arcmes_init1", (Map<String, String>)params).success && this.module.getDatabase().executeScript((String)"arcsvr_arcmes_init2", (Map<String, String>)params).success && this.module.getDatabase().executeScript((String)"arcsvr_arcmes_update1", (Map<String, String>)params).success)) {
            return false;
        }
        this.isDbReadyForVersion2();
        boolean res = true;
        this.initPreparedStatements();
        for (MesBase arc : this.mess.values()) {
            if (arc.init()) continue;
            res = false;
        }
        this.removeOldMeslistRecords();
        if (res) {
            this.saveMessage(STR_SERVER_ARCH, "\u0421\u0422\u0410\u0420\u0422", this.module.getName(), 0xFF8000, 0xFFFFFF);
        } else {
            this.saveMessage(STR_SERVER_ARCH, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430", this.module.getName(), 0, 255);
        }
        return res;
    }

    private void isDbReadyForVersion2() {
        if (!this.version2) {
            return;
        }
        boolean res = false;
        Database db = this.module.getDatabase();
        try (Statement st = db.getConnection().createStatement();){
            res = db.hasTable(st, this.module.getSchema(), "MESMONITOR");
            db.commit();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName());
            db.rollback();
        }
        if (!res) {
            this.version2 = false;
            this.env.printError(this.logger, this.module.getName(), "Version 2 mode has been disabled. You must recreate database " + db.getName() + "!");
        }
    }

    private void removeOldMeslistRecords() {
        String idmsgs = this.mess.keySet().stream().map(Object::toString).collect(Collectors.joining(", "));
        Database db = this.module.getDatabase();
        try (Statement st = db.getConnection().createStatement();){
            String sql = String.format("delete from %s where (idmsg not in (%s)) and (idmsg < 100000)", this.module.makeTableName("meslist"), idmsgs);
            st.executeUpdate(sql);
            db.commit();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName());
            db.rollback();
        }
    }

    public boolean execute() throws SQLException {
        if (!this.enable) {
            return true;
        }
        boolean res = true;
        for (MesBase arc : this.mess.values()) {
            if (arc.execute()) continue;
            res = false;
        }
        return res;
    }

    public void closedown() {
        if (!this.enable) {
            return;
        }
        this.closePreparedStatements();
        this.saveMessage(STR_SERVER_ARCH, "\u0421\u0422\u041e\u041f", this.module.getName(), 9192960, 0xFFFFFF);
    }

    private void saveMessage(String text1, String text2, String text3, int clb, int clf) {
        if (!this.version2) {
            return;
        }
        Database db = this.module.getDatabase();
        if (db == null || db.getConnection() == null) {
            return;
        }
        try (Statement st = db.getConnection().createStatement();){
            String sql = String.format("select * from %s('%s', '%s', '%s', %d, %d, %d, %d)", this.module.makeTableName("save_message"), text1, text2, text3, 0, 0, clb, clf);
            ResultSet rs = st.executeQuery(sql);
            rs.next();
            db.commit();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.module.getName());
            db.rollback();
        }
    }

    public String getInfo() {
        Object res = "";
        if (this.version2) {
            res = (String)res + "\u001b[32m\r\narcmes version 2\u001b[0m";
        }
        for (MesBase arc : this.mess.values()) {
            res = (String)res + arc.getInfo();
        }
        return res;
    }

    public String showNolinks() {
        Object res = "";
        for (MesBase mes : this.mess.values()) {
            String s = mes.getNolinks();
            if (s.isEmpty()) continue;
            res = (String)res + "\u001b[31m\u001b[01m" + mes.idmsg + ": " + mes.mestext + ":\r\n\u001b[0m" + s;
        }
        return res;
    }

    public void addPlace(String placeName, int placeId) {
        this.places.put(placeName, placeId);
    }

    public int getPlace(String placeName) {
        Integer placeId = this.places.get(placeName);
        return placeId == null ? 0 : placeId;
    }

    protected void initPreparedStatements() {
        this.closePreparedStatements();
        String tblMessages = this.module.makeTableName("messages");
        try {
            this.pstInsert = this.module.getDatabase().getConnection().prepareStatement(String.format("insert into %s (dt, idmsg, idtag, idplace, act, clb, clf, data) values (?, ?, ?, ?, ?, ?, ?, ?)", tblMessages));
            if (this.version2) {
                this.pstUpdateDtend = this.module.getDatabase().getConnection().prepareStatement(String.format("update %s set dtend=? where idmsg=? and idtag=? and dtend is null", tblMessages));
                this.pstUpdateDtack = this.module.getDatabase().getConnection().prepareStatement(String.format("update %s set dtack=? where idmsg=? and idtag=? and dtack is null", tblMessages));
            }
            this.module.getDatabase().commit();
        }
        catch (SQLException e) {
            this.env.logError(this.logger, e, this.module.getName());
            this.module.getDatabase().rollback();
        }
    }

    protected void closePreparedStatements() {
        this.closePreparedStatement(this.pstInsert);
        this.pstInsert = null;
        if (this.version2) {
            this.closePreparedStatement(this.pstUpdateDtend);
            this.closePreparedStatement(this.pstUpdateDtack);
            this.pstUpdateDtend = null;
            this.pstUpdateDtack = null;
        }
    }

    private void closePreparedStatement(PreparedStatement pst) {
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                this.env.printError(this.logger, e, new String[0]);
            }
        }
    }
}

