/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.arcsvr.MesBase;
import promauto.jroboplc.plugin.arcsvr.MesHolder;
import promauto.jroboplc.plugin.arcsvr.MesRec;

public class MesPlain
extends MesBase {
    private final Logger logger = LoggerFactory.getLogger(MesPlain.class);

    public MesPlain(MesHolder holder, int idmsg) {
        super(holder, idmsg);
    }

    @Override
    public boolean load(Object conf) {
        if (!super.load(conf)) {
            return false;
        }
        Configuration cm = this.env.getConfiguration();
        String placename = cm.get(conf, "place", this.module.getPlaceName());
        Pattern p1 = Pattern.compile("(.*):(.*);(.*)");
        Pattern p2 = Pattern.compile("(.*)\\.(.*);(.*)");
        try {
            for (Object o : cm.toList(cm.get(conf, "tags"))) {
                String s = o.toString();
                Matcher m = p1.matcher(s);
                if (!m.find() && !(m = p2.matcher(s)).find()) {
                    this.env.printError(this.logger, this.module.getName(), "idmsg=" + this.idmsg, "Bad string in tags: " + s);
                    return false;
                }
                MesRec rec = new MesRec();
                String tagname = m.group(1) + "." + m.group(2);
                rec.descr = m.group(3);
                rec.placename = placename;
                this.recs.put(tagname, rec);
            }
        }
        catch (PatternSyntaxException e) {
            this.env.printError(this.logger, e, this.module.getName(), "idmsg=" + this.idmsg, "Load error");
            return false;
        }
        return true;
    }

    @Override
    public void link() {
        this.recs.values().stream().forEach(rec -> {
            rec.phantom = true;
        });
        for (JrModule mod : this.env.getModuleManager().getModules()) {
            for (Tag tag : mod.getTagTable().values()) {
                String tagname;
                MesRec rec2;
                if (tag.getType() == Tag.Type.STRING || tag.getStatus() == Tag.Status.Deleted || (rec2 = (MesRec)this.recs.get(tagname = tag.hasFlags(4) ? tag.getName() : mod.getName() + "." + tag.getName())) == null) continue;
                if (rec2.tag != tag) {
                    rec2.value = tag.getInt();
                    rec2.active = (Boolean)this.eventfunc.apply(rec2.value);
                }
                rec2.mod = mod;
                rec2.tag = tag;
                rec2.phantom = false;
            }
        }
        this.recs.values().stream().filter(rec -> rec.phantom).forEach(rec -> {
            rec.mod = null;
            rec.tag = null;
        });
    }

    @Override
    protected void initTags(Statement st) throws SQLException {
        Map<String, MesBase.DescrTagid> tmp = this.getTaglistMap(st);
        for (Map.Entry ent : this.recs.entrySet()) {
            String tagname = (String)ent.getKey();
            MesRec rec = (MesRec)ent.getValue();
            MesBase.DescrTagid dti = tmp.get(tagname);
            if (dti == null) {
                rec.idtag = this.createTaglistRec(st, tagname, rec.descr, rec.placeid);
                continue;
            }
            rec.idtag = dti.tagid;
            if (!rec.descr.equals(dti.descr) || rec.placeid != dti.placeid) {
                this.updateTaglistRec(st, rec.idtag, rec.descr, rec.placeid);
            }
            tmp.remove(tagname);
        }
        for (String tagname : tmp.keySet()) {
            this.deleteTaglistRec(st, tmp.get((Object)tagname).tagid, tagname);
        }
        this.perfomPostFactum(st);
    }
}

