/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.PatternList;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.arcsvr.MesBase;
import promauto.jroboplc.plugin.arcsvr.MesHolder;
import promauto.jroboplc.plugin.arcsvr.MesRec;

public class MesRegex
extends MesBase {
    private final Logger logger = LoggerFactory.getLogger(MesRegex.class);
    String tagdescr;
    Pattern tagregex;
    PatternList filters = new PatternList();
    private boolean needInit;
    private boolean phantomsOnly;
    private String placename;

    public MesRegex(MesHolder holder, int idmsg) {
        super(holder, idmsg);
    }

    @Override
    public boolean load(Object conf) {
        if (!super.load(conf)) {
            return false;
        }
        Configuration cm = this.env.getConfiguration();
        this.placename = cm.get(conf, "place", this.module.getPlaceName());
        this.tagdescr = cm.get(conf, "tagdescr", "");
        String stagregex = cm.get(conf, "tagregex", "");
        this.tagregex = stagregex.isEmpty() ? null : Pattern.compile(stagregex);
        try {
            this.filters.load(conf, "tags");
        }
        catch (PatternSyntaxException e) {
            this.env.printError(this.logger, e, this.module.getName(), "idmsg=" + this.idmsg, "Load error");
            return false;
        }
        return true;
    }

    @Override
    public void link() {
        this.recs.values().stream().forEach(rec -> {
            rec.tobeRemoved = true;
        });
        for (JrModule mod : this.env.getModuleManager().getModules()) {
            for (Tag tag : mod.getTagTable().values()) {
                String tagname;
                if (tag.getType() == Tag.Type.STRING || tag.getStatus() == Tag.Status.Deleted || !this.filters.match(tagname = tag.hasFlags(4) ? tag.getName() : mod.getName() + "." + tag.getName())) continue;
                MesRec rec2 = (MesRec)this.recs.get(tagname);
                if (rec2 == null) {
                    rec2 = this.createRec(tagname);
                    this.needInit = true;
                }
                this.needInit |= rec2.phantom;
                if (rec2.tag != tag) {
                    rec2.value = tag.getInt();
                    rec2.active = (Boolean)this.eventfunc.apply(rec2.value);
                    rec2.descr = this.makeTagDescr(tagname);
                }
                rec2.mod = mod;
                rec2.tag = tag;
                rec2.phantom = false;
                rec2.tobeRemoved = false;
            }
        }
        this.needInit |= this.recs.values().removeIf(rec -> !rec.phantom && rec.tobeRemoved);
        this.phantomsOnly = this.recs.values().stream().allMatch(rec -> rec.phantom);
    }

    private String makeTagDescr(String tagname) {
        if (this.tagregex == null) {
            return tagname;
        }
        Matcher m = this.tagregex.matcher(tagname);
        if (!m.find()) {
            return tagname;
        }
        String result_tagdescr = this.tagdescr;
        for (int i = 1; i <= m.groupCount(); ++i) {
            result_tagdescr = result_tagdescr.replace("{" + i + "}", m.group(i));
        }
        return result_tagdescr;
    }

    @Override
    protected void initTags(Statement st) throws SQLException {
        Map<String, MesBase.DescrTagid> tmp = this.getTaglistMap(st);
        for (Map.Entry ent : this.recs.entrySet()) {
            String tagname = (String)ent.getKey();
            MesRec rec = (MesRec)ent.getValue();
            MesBase.DescrTagid dti = tmp.get(tagname);
            if (dti == null) {
                rec.idtag = this.createTaglistRec(st, tagname, tagname, rec.placeid);
                continue;
            }
            rec.idtag = dti.tagid;
            if (!rec.descr.equals(dti.descr) || rec.placeid != dti.placeid) {
                this.updateTaglistRec(st, rec.idtag, rec.descr, rec.placeid);
            }
            tmp.remove(tagname);
        }
        for (String tagname : tmp.keySet()) {
            if (this.filters.match(tagname)) {
                MesRec rec = this.createRec(tagname);
                rec.idtag = tmp.get((Object)tagname).tagid;
                rec.descr = this.makeTagDescr(tagname);
                rec.phantom = true;
                continue;
            }
            this.deleteTaglistRec(st, tmp.get((Object)tagname).tagid, tagname);
        }
    }

    private MesRec createRec(String tagname) {
        MesRec rec = new MesRec();
        rec.placename = this.placename;
        this.recs.put(tagname, rec);
        return rec;
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.needInit) {
            this.init();
        }
        if (this.phantomsOnly) {
            return true;
        }
        return super.execute();
    }
}

