/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.arcsvr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.plugin.arcsvr.MesHolder;
import promauto.jroboplc.plugin.arcsvr.MesPlain;
import promauto.jroboplc.plugin.arcsvr.MesRec;
import promauto.utils.IniFile;

public class MesRobo
extends MesPlain {
    private final Logger logger = LoggerFactory.getLogger(MesRobo.class);

    public MesRobo(MesHolder holder, int idmsg) {
        super(holder, idmsg);
    }

    public void load(IniFile ini, String section, String tagpath, String placename) throws Exception {
        this.idmsg = ini.getInt(section, "MesId", 0);
        this.mestext = ini.getString(section, "Name", "");
        this.alarm = ini.getInt(section, "Alarm", this.alarm);
        this.clb_inp = ini.getInt(section, "Clb_inp", this.clb_inp);
        this.clf_inp = ini.getInt(section, "Clf_inp", this.clf_inp);
        this.clb_inp = ini.getInt(section, "Clb_inp", this.clb_inp);
        this.clf_inp = ini.getInt(section, "Clf_inp", this.clf_inp);
        this.clb_inp = ini.getInt(section, "Clb_inp", this.clb_inp);
        this.clf_inp = ini.getInt(section, "Clf_inp", this.clf_inp);
        this.noaffirm = (this.alarm & 4) > 0;
        this.eventtype = ini.getInt(section, "EventType", this.eventtype);
        this.eventval = ini.getInt(section, "EventVal", this.eventval);
        this.initEventFunc();
        Pattern p1 = Pattern.compile("\\s*([^;]+)\\s*;\\s*([^;]*)");
        Pattern p2 = Pattern.compile("\\{place=(.*)\\}");
        int tagcount = ini.getInt(section, "TagCount", 0);
        for (int i = 0; i < tagcount; ++i) {
            String s = ini.getString(section, "Tag" + i, "");
            Matcher m = p1.matcher(s);
            if (!m.find()) {
                throw new Exception("Tag rec error: " + section + ", " + i + " = " + s);
            }
            Object tagname = tagpath == null || tagpath.trim().isEmpty() ? m.group(1) : tagpath + "." + m.group(1);
            MesRec rec = new MesRec();
            this.recs.put(tagname, rec);
            rec.descr = m.group(2);
            m = p2.matcher(rec.descr);
            if (m.find()) {
                rec.placename = m.group(1);
                rec.descr = m.replaceFirst("");
                continue;
            }
            rec.placename = placename;
        }
    }
}

