/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.ModuleManagerImpl;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.TagRepository;
import promauto.jroboplc.plugin.database.CmdExec;
import promauto.jroboplc.plugin.database.CmdSql;
import promauto.jroboplc.plugin.database.Dbscr;
import promauto.jroboplc.plugin.database.SimpleTagRepository;
import promauto.jroboplc.plugin.database.Tabletags;
import promauto.utils.ParamsMap;

public abstract class DatabaseModule
extends AbstractModule
implements Database {
    private final Logger logger = LoggerFactory.getLogger(DatabaseModule.class);
    protected Properties databaseProperties = new Properties();
    protected String type;
    protected String host;
    protected int port;
    protected String dbname;
    protected String user;
    protected String password;
    protected String scripFileName;
    protected int reconnectTimeSec;
    protected int timeout_s;
    protected boolean logdbscr;
    protected Tag tagConnected;
    protected Tag tagReconnectCounter;
    protected Tag tagDisconnectCounter;
    protected boolean connected = false;
    private long cooldownTime = 0L;
    protected Connection connection = null;
    protected String connectionUrl = "";
    protected Set<String> notifications = new HashSet<String>();
    protected String lastErrorMessage;
    private boolean reloading = false;
    private Map<String, Dbscr> dbscrs = new HashMap<String, Dbscr>();
    private long serverTimeOffset;
    private final List<Startup> startups = new ArrayList<Startup>();
    private final Tabletags tabletags = new Tabletags(this);

    public DatabaseModule(Plugin plugin, String name) {
        super(plugin, name);
        this.env.getCmdDispatcher().addCommand(this, CmdExec.class);
        this.env.getCmdDispatcher().addCommand(this, CmdSql.class);
    }

    @Override
    public final boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.type = cm.get(conf, "type", "");
        this.host = cm.get(conf, "host", "localhost");
        this.port = cm.get(conf, "port", this.getDefaultPort());
        this.dbname = cm.get(conf, "dbname", "");
        this.user = cm.get(conf, "user", this.getDefaultUser());
        this.password = cm.get(conf, "password", this.getDefaultPassword());
        this.scripFileName = cm.get(conf, "script", "");
        this.reconnectTimeSec = cm.get(conf, "recon_s", 10);
        this.timeout_s = cm.get(conf, "timeout_s", 10);
        this.logdbscr = cm.get(conf, "logdbscr", false);
        this.databaseProperties.clear();
        cm.toMap(cm.get(conf, "properties")).forEach((key, value) -> this.databaseProperties.put(key, value));
        for (Object obj : cm.toList(cm.get(conf, "startups"))) {
            String filename = "";
            ParamsMap params = new ParamsMap(new String[0]);
            if (obj instanceof Map) {
                Map.Entry<String, Object> ent = cm.toMap(obj).entrySet().iterator().next();
                filename = ent.getKey();
                cm.toMap(ent.getValue()).forEach((key, value) -> params.put(key, value.toString()));
            } else if (obj instanceof String) {
                filename = obj.toString();
            }
            List<String> loaded = this.loadScriptFromFile(filename);
            if (loaded == null) {
                return false;
            }
            loaded.stream().forEach(dbscrname -> {
                Startup startup = new Startup();
                startup.dbscrname = dbscrname;
                startup.params = params;
                this.startups.add(startup);
            });
        }
        this.tabletags.load(conf);
        if (!this.reloading) {
            this.tagConnected = this.tagtable.createBool("connected", false);
            this.tagReconnectCounter = this.tagtable.createInt("reconnect.cnt", 0);
            this.tagDisconnectCounter = this.tagtable.createInt("disconnect.cnt", 0);
        }
        return this.loadDatabaseModule(conf);
    }

    @Override
    public final boolean prepareModule() {
        this.tagReconnectCounter.setInt(0);
        this.tagDisconnectCounter.setInt(0);
        this.connect();
        if (!this.connected) {
            this.env.printInfo(this.logger, this.name, "No connection", this.lastErrorMessage);
            Pattern p = Pattern.compile(this.getDatabaseNotExistsRegex(), 8);
            if (p.matcher(this.lastErrorMessage).find()) {
                this.env.printInfo(this.logger, this.name, "Attempting to create database...");
                if (this.createDatabase()) {
                    this.connect();
                }
            }
        }
        return true;
    }

    @Override
    public boolean closedownModule() {
        if (!this.enable) {
            return true;
        }
        this.disconnect();
        return true;
    }

    @Override
    public boolean executeModule() {
        if (this.cooldownTime > 0L) {
            if (this.isCooldownOver()) {
                this.resetCooldown();
                this.connect();
            }
        } else {
            boolean ok = this.isConnected();
            if (ok) {
                try {
                    SQLWarning w;
                    ok = this.updateServerTimeOffset();
                    if (w != null) {
                        for (w = this.connection.getWarnings(); w != null; w = w.getNextWarning()) {
                            this.env.printInfo(this.logger, this.name, "SQLWarning:", w.getMessage());
                        }
                        this.connection.clearWarnings();
                    }
                }
                catch (Exception e) {
                    ok = false;
                }
            }
            if (ok) {
                this.tabletags.execute();
            } else {
                this.disconnect();
                this.setupCooldown();
                int cnt = this.tagDisconnectCounter.getInt() + 1;
                this.tagDisconnectCounter.setInt(cnt);
                this.env.printInfo(this.logger, this.name, "Connection lost, cnt:", "" + cnt);
            }
        }
        return true;
    }

    private boolean isCooldownOver() {
        return this.cooldownTime < System.currentTimeMillis();
    }

    private void setupCooldown() {
        this.cooldownTime = System.currentTimeMillis() + (long)(this.reconnectTimeSec * 1000);
    }

    private void resetCooldown() {
        this.cooldownTime = 0L;
    }

    private void connect() {
        if (this.connected) {
            return;
        }
        int reconnectCnt = this.tagReconnectCounter.getInt();
        this.tagReconnectCounter.setInt(reconnectCnt + 1);
        this.connection = null;
        String url = "";
        try {
            DriverManager.setLoginTimeout(this.timeout_s);
            url = this.getConnectionUrl();
            this.connection = DriverManager.getConnection(url, this.databaseProperties);
            this.connection.setAutoCommit(false);
            this.connected = !this.connection.isClosed() && this.connection.isValid(0);
        }
        catch (SQLException e) {
            this.lastErrorMessage = e.getMessage();
        }
        if (this.connected) {
            this.connected &= this.doAfterConnected();
        }
        if (this.connected) {
            this.tagConnected.setBool(true);
            if (reconnectCnt > 0) {
                this.env.printInfo(this.logger, this.name, "Connection restored");
            }
            this.resetCooldown();
            this.postSignal(Signal.SignalType.CONNECTED);
            this.executeStartups();
            this.tabletags.connect();
        } else {
            this.setupCooldown();
            this.disconnect();
        }
    }

    private void executeStartups() {
        this.startups.forEach(startup -> {
            Database.ScriptResult sr = this.executeScript(startup.dbscrname, startup.params);
            if (sr.success) {
                if (sr.executedDoCount > 0) {
                    this.env.printInfo(this.logger, this.name, "Startup script executed: " + startup.dbscrname + (String)(startup.params.size() > 0 ? " " + startup.params.toString() : ""));
                }
            } else {
                this.env.printError(this.logger, this.name, "Database script failed: " + startup.dbscrname);
            }
        });
    }

    public void disconnect() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.doAfterDisconnected();
        this.connection = null;
        this.connected = false;
        this.postSignal(Signal.SignalType.DISCONNECTED);
    }

    public boolean updateServerTimeOffset() {
        boolean res;
        block18: {
            res = false;
            if (this.connection != null) {
                try (Statement st = this.connection.createStatement();){
                    if (this.connection.isClosed()) break block18;
                    try (ResultSet rs = st.executeQuery(this.getCurrentTimestampSql());){
                        if (rs.next()) {
                            this.serverTimeOffset = rs.getTimestamp(1).toInstant().toEpochMilli() - System.currentTimeMillis();
                            res = true;
                        }
                    }
                    this.connection.commit();
                }
                catch (SQLException e) {
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        return res;
    }

    @Override
    public List<String> loadScriptFromResource(Class<?> classOfLoader, String resourceName) {
        List<String> list;
        block8: {
            InputStream in = ModuleManagerImpl.class.getClassLoader().getResourceAsStream(resourceName);
            try {
                list = this.loadScriptFromMap((Map)new Yaml().load(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.env.printError(this.logger, e, this.name, "Failed to load script from resource:", resourceName);
                    return null;
                }
            }
            in.close();
        }
        return list;
    }

    @Override
    public List<String> loadScriptFromFile(String filename) {
        List<String> list;
        block9: {
            Path path = Paths.get(filename, new String[0]);
            if (!path.isAbsolute()) {
                path = this.env.getConfiguration().getConfDir().resolve(path);
            }
            Yaml yaml = new Yaml();
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                list = this.loadScriptFromMap((Map)yaml.load(in));
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.env.printError(this.logger, e, this.name, "Load script from file:", filename);
                    return null;
                }
            }
            in.close();
        }
        return list;
    }

    public List<String> loadScriptFromMap(Map<Object, Object> map) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> ent : map.entrySet()) {
            String key = ent.getKey().toString();
            if (!key.startsWith("dbscr.")) continue;
            String dbscrName = key.substring(6);
            Dbscr dbscr = new Dbscr(this, dbscrName);
            if (!dbscr.load(ent.getValue())) {
                return null;
            }
            this.dbscrs.put(dbscrName, dbscr);
            result.add(dbscrName);
        }
        return result;
    }

    @Override
    public Database.ScriptResult executeScript(String scriptName) {
        return this.executeScript(scriptName, null);
    }

    @Override
    public Database.ScriptResult executeScript(String scriptName, Map<String, String> params) {
        Dbscr dbscr = this.dbscrs.get(scriptName);
        if (dbscr == null) {
            this.env.printError(this.logger, "Script not found: " + scriptName);
            return new Database.ScriptResult();
        }
        return dbscr.execute(params);
    }

    @Override
    public boolean hasScript(String scriptName) {
        return this.dbscrs.containsKey(scriptName);
    }

    @Override
    public String makeSchemaObjectName(String schema, String objname) {
        if (schema.isEmpty()) {
            return objname;
        }
        return schema + this.getSchemaDelimiter() + objname;
    }

    @Override
    public String getInfo() {
        return this.enable ? (!this.connected ? "\u001b[31m\u001b[01mERROR! \u001b[0m" : "") + "errcnt=" + this.tagDisconnectCounter.getString() + " " + this.type + ":" + this.host + "/" + this.port + ":" + this.dbname : "disabled";
    }

    @Override
    protected boolean reload() {
        String old_type = this.type;
        String old_host = this.host;
        int old_port = this.port;
        String old_dbname = this.dbname;
        String old_user = this.user;
        String old_password = this.password;
        String old_scripFileName = this.scripFileName;
        int old_reconnectTimeSec = this.reconnectTimeSec;
        int old_timeout_s = this.timeout_s;
        Properties old_databaseProperties = new Properties();
        old_databaseProperties.putAll((Map<?, ?>)this.databaseProperties);
        ArrayList<Startup> old_startups = new ArrayList<Startup>();
        old_startups.addAll(this.startups);
        HashMap<String, Dbscr> old_dbscrs = new HashMap<String, Dbscr>();
        old_dbscrs.putAll(this.dbscrs);
        this.reloading = true;
        boolean closed = false;
        boolean result = false;
        if (this.load() && this.type.equals(old_type)) {
            this.closedown();
            closed = true;
            if (this.prepare()) {
                result = true;
            }
        }
        if (!result) {
            this.type = old_type;
            this.host = old_host;
            this.port = old_port;
            this.dbname = old_dbname;
            this.user = old_user;
            this.password = old_password;
            this.scripFileName = old_scripFileName;
            this.reconnectTimeSec = old_reconnectTimeSec;
            this.timeout_s = old_timeout_s;
            this.databaseProperties.clear();
            this.databaseProperties.putAll((Map<?, ?>)old_databaseProperties);
            this.startups.clear();
            this.startups.addAll(old_startups);
            this.dbscrs.clear();
            this.dbscrs.putAll(old_dbscrs);
            if (closed) {
                this.prepare();
            }
        }
        return result;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void registerEventNotification(String notification) {
        if (!this.notifications.contains(notification)) {
            this.listenEventNotification(notification);
            this.notifications.add(notification);
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection != null) {
            this.connection.commit();
        }
    }

    @Override
    public void rollback() {
        if (this.connection != null) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                this.env.printError(this.logger, e, this.name, "Rollback");
            }
        }
    }

    @Override
    public TagRepository createTagRepository(String schema, String table) {
        return new SimpleTagRepository(this, schema, table);
    }

    @Override
    public long getServerTimerOffset() {
        return this.serverTimeOffset;
    }

    @Override
    public LocalDateTime getServerDatetime() {
        return LocalDateTime.now().plus(this.serverTimeOffset, ChronoUnit.MILLIS);
    }

    @Override
    public String formatDatetimeWithOffset(LocalDateTime ldt) {
        return ldt.plus(this.serverTimeOffset, ChronoUnit.MILLIS).format(this.getTimestampFormatter());
    }

    @Override
    public String formatDatetime(LocalDateTime ldt) {
        return ldt.format(this.getTimestampFormatter());
    }

    protected abstract void listenEventNotification(String var1);

    protected abstract boolean loadDatabaseModule(Object var1);

    protected abstract int getDefaultPort();

    protected abstract String getDefaultUser();

    protected abstract String getDefaultPassword();

    protected abstract boolean createDatabase();

    protected abstract String getDatabaseNotExistsRegex();

    protected abstract String getConnectionUrl();

    protected abstract boolean doAfterConnected();

    protected abstract void doAfterDisconnected();

    protected abstract String getCurrentTimestampSql();

    private static class Startup {
        public String dbscrname;
        public ParamsMap params;

        private Startup() {
        }
    }
}

