/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.format.DateTimeFormatter;
import org.firebirdsql.event.DatabaseEvent;
import org.firebirdsql.event.EventListener;
import org.firebirdsql.event.EventManager;
import org.firebirdsql.event.FBEventManager;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.management.FBManager;
import org.firebirdsql.management.FBServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.plugin.database.DatabaseModule;

public class FirebirdDatabaseModule
extends DatabaseModule
implements EventListener {
    private final Logger logger = LoggerFactory.getLogger(FirebirdDatabaseModule.class);
    private static DateTimeFormatter timestapFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final int EXPECTED_SERVER_MAJOR_VERSION = 3;
    private EventManager eventManager = null;
    private boolean eventManagerConnected = false;

    public FirebirdDatabaseModule(Plugin plugin, String name) {
        super(plugin, name);
        try {
            Class.forName("org.firebirdsql.jdbc.FBDriver");
        }
        catch (ClassNotFoundException e) {
            this.env.printError(this.logger, e, name);
        }
    }

    @Override
    protected boolean loadDatabaseModule(Object conf) {
        this.databaseProperties.put("soTimeout", "" + this.timeout_s * 1000);
        this.databaseProperties.put("user", this.user);
        this.databaseProperties.put("password", this.password);
        if (!this.databaseProperties.containsKey("encoding")) {
            this.databaseProperties.put("encoding", "WIN1251");
        }
        return true;
    }

    @Override
    public Database.DatabaseType getType() {
        return Database.DatabaseType.FIREBIRD;
    }

    @Override
    public DateTimeFormatter getTimestampFormatter() {
        return timestapFormatter;
    }

    @Override
    protected int getDefaultPort() {
        return 3050;
    }

    @Override
    protected String getDefaultUser() {
        return "SYSDBA";
    }

    @Override
    protected String getDefaultPassword() {
        return "masterkey";
    }

    @Override
    protected String getConnectionUrl() {
        return "jdbc:firebirdsql://" + this.host + ":" + this.port + "/" + this.dbname;
    }

    @Override
    protected String getDatabaseNotExistsRegex() {
        return "(.*GDS Exception. 335544344.*|.*ISC error code:335544344.*)";
    }

    @Override
    public String getCurrentTimestampSql() {
        return "select current_timestamp from rdb$database";
    }

    @Override
    protected boolean createDatabase() {
        try {
            FBManager manager = new FBManager(GDSType.getType("PURE_JAVA"));
            manager.setDialect(3);
            manager.setServer(this.host);
            manager.setPort(this.port);
            String encoding = this.databaseProperties.getProperty("encoding");
            if (encoding != null && !encoding.isEmpty()) {
                manager.setDefaultCharacterSet(encoding);
            }
            manager.start();
            manager.createDatabase(this.dbname, this.user, this.password);
            manager.stop();
            return true;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name, "Create database error:", this.name);
            return false;
        }
    }

    @Override
    protected boolean doAfterConnected() {
        FBServiceManager manager = new FBServiceManager();
        manager.setHost(this.host);
        manager.setPort(this.port);
        manager.setUser(this.user);
        manager.setPassword(this.password);
        try {
            int ver = manager.getServerVersion().getMajorVersion();
            if (ver < 3) {
                this.env.printError(this.logger, this.name, "Incompatible server version!\r\nExpected: >= 3\r\nCurrent : " + manager.getServerVersion().getFullVersion());
            }
        }
        catch (SQLException ver) {
            // empty catch block
        }
        this.eventManagerConnected = false;
        if (this.notifications.size() > 0) {
            try {
                this.eventManager = FBEventManager.createFor(this.connection);
                this.eventManager.connect();
                this.eventManagerConnected = true;
            }
            catch (SQLException e) {
                this.env.printError(this.logger, e, this.name, "After connect error");
            }
            for (String notification : this.notifications) {
                this.listenEventNotification(notification);
            }
        }
        return true;
    }

    @Override
    protected void doAfterDisconnected() {
        if (this.eventManagerConnected && this.eventManager != null) {
            try {
                this.eventManagerConnected = false;
                this.eventManager.close();
                this.eventManager = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void listenEventNotification(String notification) {
        if (this.eventManagerConnected) {
            try {
                this.eventManager.addEventListener(notification, this);
            }
            catch (SQLException e) {
                this.env.printError(this.logger, e, this.name);
            }
        }
    }

    @Override
    public void eventOccurred(DatabaseEvent event) {
        this.postSignal(Signal.SignalType.NOTIFICATION, event.getEventName());
    }

    @Override
    public String getSchemaDelimiter() {
        return "_";
    }

    @Override
    public boolean hasSchema(Statement statement, String schema) throws SQLException {
        return statement.executeQuery("SELECT RDB$RELATION_ID FROM RDB$RELATIONS WHERE RDB$RELATION_NAME STARTING WITH UPPER('" + this.makeSchemaObjectName(schema, "") + "')").next();
    }

    @Override
    public boolean hasDomain(Statement statement, String schema, String domain) throws SQLException {
        return statement.executeQuery("SELECT RDB$FIELD_NAME FROM RDB$FIELDS WHERE RDB$FIELD_NAME = UPPER('" + this.makeSchemaObjectName(schema, domain) + "')").next();
    }

    @Override
    public boolean hasTable(Statement statement, String schema, String table) throws SQLException {
        return statement.executeQuery("SELECT RDB$RELATION_ID FROM RDB$RELATIONS WHERE RDB$RELATION_NAME = UPPER('" + this.makeSchemaObjectName(schema, table) + "')").next();
    }

    @Override
    public boolean hasColumn(Statement statement, String schema, String table, String column) throws SQLException {
        return statement.executeQuery("SELECT RDB$FIELD_ID FROM RDB$RELATION_FIELDS WHERE RDB$RELATION_NAME = UPPER('" + this.makeSchemaObjectName(schema, table) + "') AND RDB$FIELD_NAME = UPPER('" + column + "')").next();
    }

    @Override
    public boolean hasConstraint(Statement statement, String schema, String table, String constraint) throws SQLException {
        return statement.executeQuery("SELECT RDB$CONSTRAINT_NAME FROM RDB$RELATION_CONSTRAINTS WHERE RDB$RELATION_NAME = UPPER('" + this.makeSchemaObjectName(schema, table) + "') AND RDB$CONSTRAINT_NAME = UPPER('" + constraint + "')").next();
    }

    @Override
    public boolean hasIndex(Statement statement, String schema, String index) throws SQLException {
        return statement.executeQuery("SELECT RDB$INDEX_NAME FROM RDB$INDICES WHERE RDB$INDEX_NAME = UPPER('" + index + "')").next();
    }

    @Override
    public boolean hasTrigger(Statement statement, String schema, String trigger) throws SQLException {
        return statement.executeQuery("SELECT RDB$TRIGGER_NAME FROM RDB$TRIGGERS WHERE RDB$TRIGGER_NAME = UPPER('" + trigger + "')").next();
    }

    @Override
    public boolean hasProcedure(Statement statement, String schema, String procedure) throws SQLException {
        return statement.executeQuery("SELECT RDB$PROCEDURE_NAME FROM RDB$PROCEDURES WHERE RDB$PROCEDURE_NAME = UPPER('" + procedure + "')").next();
    }

    @Override
    public boolean hasRecord(Statement statement, String sql) throws SQLException {
        return statement.executeQuery(sql).next();
    }

    @Override
    public Integer insertReturningId(Statement statement, String sql, String ... optional) throws SQLException {
        String columnNameID = optional.length > 0 ? optional[0] : "id";
        sql = (String)sql + " returning " + columnNameID;
        try (ResultSet rs = statement.executeQuery((String)sql);){
            if (rs.next()) {
                Integer n = rs.getInt(1);
                return n;
            }
        }
        return null;
    }
}

