/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Database;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.api.TagRepository;
import promauto.jroboplc.core.tags.TagRW;

public class SimpleTagRepository
implements TagRepository {
    private final Logger logger = LoggerFactory.getLogger(SimpleTagRepository.class);
    private final Database db;
    public final String schema;
    public final String table;
    public final Map<String, Rec> data = new HashMap<String, Rec>();
    private boolean hasChanges = false;
    private Map<Tag, GroupKey> groupKeyCache = new HashMap<Tag, GroupKey>();

    public SimpleTagRepository(Database db, String schema, String table) {
        this.db = db;
        this.table = table;
        this.schema = schema;
    }

    private String makeKey(String group, Tag tag) {
        GroupKey gk = this.groupKeyCache.get(tag);
        if (gk != null) {
            if (gk.group.equals(group)) {
                return gk.key;
            }
        } else {
            gk = new GroupKey();
            this.groupKeyCache.put(tag, gk);
        }
        gk.group = group;
        gk.key = group + ":" + tag.getName();
        return gk.key;
    }

    @Override
    public void load(String group, Tag tag) {
        String key = this.makeKey(group, tag);
        Rec rec = this.data.get(key);
        if (rec != null) {
            tag.setString(rec.value);
            if (tag instanceof TagRW) {
                ((TagRW)tag).acceptWriteValue();
            }
        }
    }

    @Override
    public void load(String group, List<Tag> tags) {
        tags.forEach(tag -> this.load(group, (Tag)tag));
    }

    @Override
    public void save(String group, Tag tag) {
        String key = this.makeKey(group, tag);
        Rec rec = this.data.get(key);
        if (rec == null) {
            rec = new Rec(tag.getString(), true);
            this.data.put(key, rec);
            this.hasChanges = true;
        } else if (!tag.getString().equals(rec.value)) {
            rec.value = tag.getString();
            this.hasChanges = true;
            rec.hasChanges = true;
        }
    }

    @Override
    public void save(String group, List<Tag> tags) {
        tags.forEach(tag -> this.save(group, (Tag)tag));
    }

    @Override
    public boolean init() {
        String sql;
        Statement st;
        this.data.clear();
        this.hasChanges = false;
        try {
            st = this.db.getConnection().createStatement();
            try {
                if (!this.db.hasTable(st, "", this.table)) {
                    sql = String.format("create table %s (name varchar(128) not null primary key, val varchar(128) not null)", this.table);
                    st.executeUpdate(sql);
                }
                this.db.commit();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        catch (SQLException e) {
            EnvironmentInst.get().printError(this.logger, e, this.schema, this.table);
            return false;
        }
        try {
            st = this.db.getConnection().createStatement();
            try {
                sql = String.format("select name, val from %s", this.table);
                try (ResultSet rs = st.executeQuery(sql);){
                    while (rs.next()) {
                        String name = rs.getString(1);
                        String value = rs.getString(2);
                        this.data.put(name, new Rec(value, false));
                    }
                }
                this.db.commit();
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        catch (SQLException e) {
            EnvironmentInst.get().printError(this.logger, e, this.schema, this.table);
            return false;
        }
        return true;
    }

    @Override
    public void persist() throws SQLException {
        if (!this.hasChanges) {
            return;
        }
        try (Statement st = this.db.getConnection().createStatement();){
            for (Map.Entry<String, Rec> ent : this.data.entrySet()) {
                Rec rec = ent.getValue();
                if (!rec.hasChanges) continue;
                String name = ent.getKey();
                String sql = String.format("update or insert into %s (name, val) values ('%s', '%s')", this.table, name, rec.value);
                st.executeUpdate(sql);
                rec.hasChanges = false;
            }
        }
        this.hasChanges = false;
    }

    private static class GroupKey {
        String group;
        String key;

        private GroupKey() {
        }
    }

    private static class Rec {
        String value;
        boolean hasChanges;

        Rec(String value, boolean hasChanges) {
            this.value = value;
            this.hasChanges = hasChanges;
        }
    }
}

