/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.jrbustcp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.plugin.jrbustcp.JrbustcpServerModule;
import promauto.jroboplc.plugin.jrbustcp.ServerSession;

public class ServerHandler
extends ChannelInboundHandlerAdapter {
    private final Logger logger = LoggerFactory.getLogger(ServerHandler.class);
    private Environment env;
    private final JrbustcpServerModule module;

    public ServerHandler(JrbustcpServerModule module) {
        this.module = module;
        this.env = EnvironmentInst.get();
    }

    private String getAddress(ChannelHandlerContext ctx) {
        return ctx.channel().remoteAddress().toString();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.env.isRunning()) {
            this.env.printInfo(this.logger, this.module.getName(), "Connected: ", this.getAddress(ctx));
            this.module.getClientChannels().add(ctx.channel());
            ServerSession session = new ServerSession(this.module);
            ctx.channel().attr(JrbustcpServerModule.CHDATA).set(session);
            session.onConnected(ctx.channel());
        } else {
            this.env.printInfo(this.logger, this.module.getName(), "Rejected: ", this.getAddress(ctx));
            ctx.channel().close();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ServerSession sess = ctx.channel().attr(JrbustcpServerModule.CHDATA).get();
        if (sess != null) {
            ctx.channel().attr(JrbustcpServerModule.CHDATA).get().onDisconnected(ctx.channel());
            this.env.printInfo(this.logger, this.module.getName(), "Disconnected: ", this.getAddress(ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        try {
            ctx.channel().attr(JrbustcpServerModule.CHDATA).get().onMessageReceived(ctx.channel(), buf);
        }
        finally {
            buf.release();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.env.printInfo(this.logger, this.module.getName(), "Close inactive channel: ", this.getAddress(ctx));
            ctx.close();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.env.printError(this.logger, cause, this.module.getName(), this.getAddress(ctx));
        ctx.close();
    }
}

