/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.jrbustcp;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import promauto.jroboplc.plugin.jrbustcp.JrbustcpServerModule;
import promauto.jroboplc.plugin.jrbustcp.ServerHandler;
import promauto.jroboplc.plugin.jrbustcp.TrafficHandler;

public class ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final JrbustcpServerModule module;
    private final SslContext sslCtx;

    public ServerInitializer(JrbustcpServerModule module, SslContext sslCtx) {
        this.module = module;
        this.sslCtx = sslCtx;
    }

    @Override
    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addFirst("ipfilter", this.module.getIpSubnetFilter());
        pipeline.addFirst("traffic", (ChannelHandler)new TrafficHandler());
        pipeline.addLast(new IdleStateHandler(0, this.module.getIdleTimeout(), 0));
        if (this.sslCtx != null) {
            pipeline.addLast(this.sslCtx.newHandler(ch.alloc()));
        }
        if (this.module.getCompress().equals("gzip")) {
            pipeline.addLast(ZlibCodecFactory.newZlibEncoder(ZlibWrapper.GZIP));
            pipeline.addLast(ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        pipeline.addLast(new LengthFieldBasedFrameDecoder(16384, 0, 2, 0, 2));
        pipeline.addLast(new LengthFieldPrepender(2));
        pipeline.addLast(new ServerHandler(this.module));
    }
}

