/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkormsvr;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.ANSI;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.RefGroup;
import promauto.jroboplc.core.tags.RefItem;
import promauto.jroboplc.plugin.kkormsvr.KkGroup;
import promauto.jroboplc.plugin.kkormsvr.KkLine;
import promauto.jroboplc.plugin.kkormsvr.KkStorage;
import promauto.jroboplc.plugin.kkormsvr.KkTask;
import promauto.jroboplc.plugin.kkormsvr.KkormsvrModule;

public class KkDoser {
    private final Logger logger = LoggerFactory.getLogger(KkDoser.class);
    private static final int STATE_IDLE = 1;
    private static final int STATE_WAITING_FOR_TASK = 2;
    private static final int STATE_LOADING = 4;
    private static final int STATE_UNLOADING = 8;
    private static final int STATE_ALARM = 16;
    private static final int ERROR_NONE = 0;
    private static final int ERROR_NOLINK = 1;
    private static final int ERROR_DISCONNECT = 2;
    private static final int ERROR_CRC = 3;
    private static final int ERROR_TASKDIFFER = 4;
    public final KkormsvrModule module;
    public final KkLine line;
    private KkGroup group = null;
    private String name;
    private String bindModuleName;
    int grouplevel;
    private List<KkStorage> stors = new ArrayList<KkStorage>();
    private KkStorage[] storsByAddr;
    private RefGroup refgr = EnvironmentInst.get().getRefFactory().createRefGroup();
    private RefItem refCurStor;
    private RefItem refCurWeight;
    private RefItem refState;
    private RefItem refErrorFlag;
    private RefItem refSendTask;
    private RefItem refCmdStartCycle;
    private RefItem refCmdStartTask;
    private RefItem refSumWeightMax;
    private int error;
    private Tag tagError;
    private Tag tagCurStorNum;
    private Tag tagCurStorName;
    private Tag tagCurProduct;
    private Tag tagReqWeightZero;
    private boolean hasTask;
    private boolean connected;

    KkDoser(KkLine line) {
        this.line = line;
        this.module = line.module;
        this.error = 0;
        this.hasTask = false;
        this.connected = false;
    }

    boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.name = cm.get(conf, "name", "");
        this.bindModuleName = cm.get(conf, "bind", this.name);
        this.grouplevel = cm.get(conf, "grouplevel", 0);
        try {
            Map storsconf = cm.toGenericMap(cm.get(conf, "storages"));
            TreeSet addrs = new TreeSet(storsconf.keySet());
            Iterator iterator = addrs.iterator();
            while (iterator.hasNext()) {
                KkStorage stor2 = new KkStorage(this);
                Integer addr = (Integer)iterator.next();
                if (!stor2.load(addr, storsconf.get(addr))) {
                    return false;
                }
                stor2.createRefs(this.refgr, this.bindModuleName);
                this.stors.add(stor2);
            }
        }
        catch (ClassCastException e) {
            EnvironmentInst.get().printError(this.logger, this.module.getName(), this.name, "Storage address must be a number");
            return false;
        }
        int maxStorAddr = this.stors.stream().mapToInt(stor -> stor.getAddr()).max().orElse(0);
        this.storsByAddr = new KkStorage[maxStorAddr + 1];
        this.stors.forEach(stor -> {
            this.storsByAddr[stor.getAddr()] = stor;
        });
        this.refCurStor = this.refgr.createItem(this.bindModuleName, "CurStor");
        this.refCurWeight = this.refgr.createItem(this.bindModuleName, "CurWeight");
        this.refState = this.refgr.createItem(this.bindModuleName, "State");
        this.refErrorFlag = this.refgr.createItemCrc(this.bindModuleName, "SYSTEM.ErrorFlag");
        this.refSendTask = this.refgr.createItem(this.bindModuleName, "SendTask");
        this.refCmdStartCycle = this.refgr.createItem(this.bindModuleName, "CmdStartCycle");
        this.refCmdStartTask = this.refgr.createItem(this.bindModuleName, "CmdStartTask");
        this.refSumWeightMax = this.refgr.createItem(this.bindModuleName, "SumWeightMax");
        this.refgr.createItemCrcSum(this.bindModuleName, "Crc32");
        TagTable tt = this.module.getTagTable();
        this.tagError = tt.createInt(this.prefix() + "Error", 0);
        this.tagCurStorNum = tt.createInt(this.prefix() + "CurStorNum", 0);
        this.tagCurStorName = tt.createString(this.prefix() + "CurStorName", "");
        this.tagCurProduct = tt.createString(this.prefix() + "CurProduct", "");
        this.tagReqWeightZero = tt.createBool(this.prefix() + "ReqWeightZero", false);
        return true;
    }

    String prefix() {
        return this.name + ".";
    }

    void initLiveData() {
        this.stors.forEach(KkStorage::initLiveData);
    }

    void readLiveData() {
        this.stors.forEach(KkStorage::readLiveData);
    }

    void updateLiveData() {
        this.stors.forEach(KkStorage::updateLiveData);
    }

    void prepare() {
        this.refgr.prepare();
    }

    void init() throws SQLException {
        for (KkStorage stor : this.stors) {
            stor.init();
        }
        this.checkHasTask();
    }

    void execute() throws SQLException {
        this.error = 0;
        this.connected = this.refgr.link();
        if (!this.connected) {
            this.error = 1;
        }
        if (this.connected) {
            this.refgr.read();
            boolean bl = this.connected = this.refErrorFlag.getValue().getInt() == 0;
            if (!this.connected) {
                this.error = 2;
            }
        }
        if (this.connected) {
            if (this.refgr.checkCrc32()) {
                for (KkStorage stor : this.stors) {
                    stor.execute();
                }
            } else {
                this.error = 3;
            }
            if (this.isState(4) && this.isReqWeightDiffer()) {
                this.error = 4;
            }
        }
        this.updateTags();
    }

    private void updateTags() {
        this.tagError.setInt(this.error);
        if (this.connected) {
            KkStorage stor2 = null;
            int curstor = this.refCurStor.getValue().getInt();
            if (curstor >= 0 && curstor < this.storsByAddr.length) {
                stor2 = this.storsByAddr[curstor];
            }
            if (stor2 == null) {
                this.tagCurStorNum.setInt(0);
                this.tagCurStorName.setString("");
                this.tagCurProduct.setString("");
            } else {
                this.tagCurStorNum.setInt(stor2.getNum());
                this.tagCurStorName.setString(stor2.getName());
                this.tagCurProduct.setString(stor2.getProduct());
            }
        }
        this.tagReqWeightZero.setBool(this.stors.stream().allMatch(stor -> stor.reqWeight <= 0L));
    }

    void prepareTaskSend() {
        if (this.connected && !this.isState(16)) {
            this.refCmdStartCycle.getTag().setInt(1);
            this.refSendTask.getTag().setInt(0);
        }
    }

    void sendTask() {
        if (this.connected) {
            this.refSendTask.getTag().setInt(1);
        }
    }

    void startDosing() {
        if (this.connected) {
            this.refCmdStartTask.getTag().setInt(1);
        }
    }

    private boolean isState(int state) {
        if (this.connected) {
            return (this.refState.getValue().getInt() & state) > 0;
        }
        return false;
    }

    private boolean isReqWeightDiffer() {
        return this.stors.stream().anyMatch(stor -> stor.reqWeight != stor.refReqWeight.getValue().getLong());
    }

    boolean isTaskSendReady() {
        return this.connected && this.refSendTask.getValue().getInt() == 0 && this.isState(2);
    }

    boolean isTaskAccepted() {
        return this.connected && this.refSendTask.getValue().getInt() > 0;
    }

    boolean isTaskRejected() {
        return this.connected && this.refSendTask.getValue().getInt() < 0;
    }

    boolean isDosingFinished() {
        return this.connected && this.isState(1);
    }

    private void checkHasTask() {
        this.hasTask = this.stors.stream().anyMatch(stor -> stor.reqWeight > 0L);
    }

    void applyTask(KkTask task) {
        this.stors.forEach(stor -> stor.applyTask(task));
        this.checkHasTask();
    }

    public String getName() {
        return this.name;
    }

    boolean isHasTask() {
        return this.hasTask;
    }

    long getSumWeightMax() {
        return this.refSumWeightMax.getValue().getLong();
    }

    KkGroup getGroup() {
        return this.group;
    }

    void setGroup(KkGroup group) {
        assert (this.group == null);
        this.group = group;
    }

    String getProblems() {
        Object res = this.refgr.check();
        if (this.error == 3) {
            res = (String)res + (((String)res).isEmpty() ? "" : "\r\n") + "Crc32 error!";
        }
        if (!((String)res).isEmpty()) {
            res = "Doser \"" + this.bindModuleName + "\":\r\n" + (String)res;
        }
        return res;
    }

    public String getInfo() {
        return "    " + this.name + ": " + (String)(this.bindModuleName.equals(this.name) ? "" : "bind=" + this.bindModuleName + " ") + this.getStateStr() + " " + ANSI.redBold(this.getErrorStr()) + "\r\n" + this.stors.stream().map(KkStorage::getInfo).collect(Collectors.joining("\r\n"));
    }

    private String getStateStr() {
        return (this.isState(1) ? "IDLE " : "") + (this.isState(2) ? "TASK READY " : "") + (this.isState(4) ? "LOADING " : "") + (this.isState(8) ? "UNLOADING " : "") + (this.isState(16) ? "ALARM " : "");
    }

    private String getErrorStr() {
        switch (this.error) {
            case 1: {
                return "NOLINK";
            }
            case 2: {
                return "DISCONNECT";
            }
            case 3: {
                return "CRC";
            }
            case 4: {
                return "TASKDIFFER";
            }
        }
        return "";
    }
}

