/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.kkormsvr;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.stream.Collectors;
import promauto.jroboplc.core.TagTable;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.kkormsvr.KkDoser;
import promauto.jroboplc.plugin.kkormsvr.KkGroup;
import promauto.jroboplc.plugin.kkormsvr.KkTask;
import promauto.jroboplc.plugin.kkormsvr.KkormsvrModule;

public class KkLine {
    private static final int TASK_STATUS_EXECUTED = 1;
    private static final int TASK_STATUS_ERROR = 2;
    private static final int TASK_STATUS_FAKE_TASK = 4;
    private static final int STATE_IDLE = 0;
    private static final int STATE_RUN = 1;
    private static final int STATE_SUSPEND = 2;
    private static final int STATE_ERROR_TASK_NOT_APPLIED = 3;
    private static final int STATE_ERROR_TASK_REJECTED = 4;
    private static final String ZERO_RECEIPT_NAME = "\u0414\u041e\u0417\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u0415 \u0411\u0415\u0417 \u0417\u0410\u0414\u0410\u0427\u0418 (\u0420\u0423\u0427\u041d\u041e\u0415)";
    private static final String ZERO_RECEIPT_DESCR = "\u041f\u0443\u0441\u0442\u043e\u0439 \u0440\u0435\u0446\u0435\u043f\u0442. \u0421\u043e\u0437\u0434\u0430\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0443\u0447\u0435\u0442\u0430 \u043e\u0442\u0432\u0435\u0448\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u0437\u0430\u0434\u0430\u0447\u0438 \u043d\u0430 \u043b\u0438\u043d\u0438\u0438.)";
    private static final String ZERO_PRODUCT_NAME = "\u041d\u0415\u0418\u0417\u0412\u0415\u0421\u0422\u041d\u042b\u0419 \u041f\u0420\u041e\u0414\u0423\u041a\u0422";
    private static final String ZERO_PRODUCT_DESCR = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442. \u0421\u043e\u0437\u0434\u0430\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438.";
    public final KkormsvrModule module;
    private int id;
    private int linenum;
    private String name;
    private List<KkDoser> dosers = new ArrayList<KkDoser>();
    private List<KkGroup> groups = new ArrayList<KkGroup>();
    private int taskId;
    private int receiptId;
    private Tag tagCycleReq;
    private int cycleCnt;
    private int state;
    private String prmTaskId;
    private String prmReceiptId;
    private String prmCycleReq;
    private String prmCycleCnt;
    private String prmState;
    private Tag tagTaskId;
    private Tag tagCycleCnt;
    private Tag tagState;
    private Tag tagReset;
    private Tag tagSuspend;
    private TagRW tagReceiptName;

    public KkLine(KkormsvrModule module) {
        this.module = module;
        this.taskId = 0;
        this.cycleCnt = 0;
        this.state = 0;
    }

    public boolean load(Object conf) {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        this.linenum = cm.get(conf, "linenum", 0);
        this.name = cm.get(conf, "name", "Line" + this.linenum);
        TreeMap<Integer, KkGroup> grmap = new TreeMap<Integer, KkGroup>();
        for (Object doserconf : cm.toList(cm.get(conf, "dosers"))) {
            KkDoser doser = new KkDoser(this);
            this.dosers.add(doser);
            if (!doser.load(doserconf)) {
                return false;
            }
            KkGroup gr = (KkGroup)grmap.get(doser.grouplevel);
            if (gr == null) {
                gr = new KkGroup(this, doser.grouplevel);
            }
            gr.addDoser(doser);
            doser.setGroup(gr);
            grmap.put(doser.grouplevel, gr);
        }
        this.groups = new ArrayList(grmap.values());
        this.groups.forEach(KkGroup::load);
        TagTable tt = this.module.getTagTable();
        this.tagTaskId = tt.createInt(this.prefix() + "TaskId", 0);
        this.tagReceiptName = tt.createRWString(this.prefix() + "Receipt", "");
        this.tagCycleCnt = tt.createInt(this.prefix() + "CycleCnt", 0);
        this.tagCycleReq = tt.createInt(this.prefix() + "CycleReq", 0);
        this.tagState = tt.createInt(this.prefix() + "State", 0);
        this.tagReset = tt.createBool(this.prefix() + "Reset", false);
        this.tagSuspend = tt.createBool(this.prefix() + "Suspend", false);
        this.initLiveData();
        return true;
    }

    public String prefix() {
        return "Line" + this.linenum + ".";
    }

    private void initLiveData() {
        this.prmTaskId = this.prefix() + "TaskId";
        this.prmReceiptId = this.prefix() + "ReceiptId";
        this.prmCycleCnt = this.prefix() + "CycleCnt";
        this.prmCycleReq = this.prefix() + "CycleReq";
        this.prmState = this.prefix() + "State";
        this.groups.forEach(KkGroup::initLiveData);
        this.dosers.forEach(KkDoser::initLiveData);
    }

    void loadLiveData() {
        this.taskId = this.module.livedata.getInt(this.prmTaskId, this.taskId);
        this.receiptId = this.module.livedata.getInt(this.prmReceiptId, this.taskId);
        this.cycleCnt = this.module.livedata.getInt(this.prmCycleCnt, this.cycleCnt);
        this.state = this.module.livedata.getInt(this.prmState, this.state);
        this.tagCycleReq.setInt(this.module.livedata.getInt(this.prmCycleReq, this.tagCycleReq.getInt()));
        this.groups.forEach(KkGroup::readLiveData);
        this.dosers.forEach(KkDoser::readLiveData);
    }

    private void updateLiveData() {
        this.module.livedata.set(this.prmTaskId, this.taskId);
        this.module.livedata.set(this.prmReceiptId, this.receiptId);
        this.module.livedata.set(this.prmCycleCnt, this.cycleCnt);
        this.module.livedata.set(this.prmCycleReq, this.tagCycleReq.getInt());
        this.module.livedata.set(this.prmState, this.state);
        this.groups.forEach(KkGroup::updateLiveData);
        this.dosers.forEach(KkDoser::updateLiveData);
    }

    public void prepare() {
        this.dosers.forEach(KkDoser::prepare);
    }

    public void init() throws SQLException {
        Statement st = this.module.getStatement();
        String sql = String.format("select id, name from kk_line where linenum=%d", this.linenum);
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                this.id = rs.getInt("id");
                if (!rs.getString("name").equals(this.name)) {
                    sql = String.format("update kk_line set name='%s' where id=%d", this.name, this.id);
                    st.executeUpdate(sql);
                }
            } else {
                sql = String.format("insert into kk_line (linenum, name) values (%d, '%s')", this.linenum, this.name);
                this.id = this.module.getDatabase().insertReturningId(st, sql, new String[0]);
            }
        }
        if (this.receiptId > 0) {
            sql = String.format("select name from kk_receipt where id=%d", this.receiptId);
            rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    this.tagReceiptName.setReadValString(rs.getString(1));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        for (KkDoser doser : this.dosers) {
            doser.init();
        }
        this.updateLineStatus();
    }

    public void execute() throws SQLException {
        KkTask task;
        if (this.isResetRequested()) {
            this.state = 0;
            this.reset(true);
        }
        for (KkDoser doser : this.dosers) {
            doser.execute();
        }
        for (KkGroup group : this.groups) {
            group.execute();
        }
        if (this.state == 0 && (task = this.findTask()) != null) {
            this.state = this.applyTask(task) ? 1 : 3;
        }
        if (this.state == 2 && !this.tagSuspend.getBool()) {
            this.state = 1;
        }
        if (this.state == 1) {
            if (this.tagSuspend.getBool()) {
                this.state = 2;
            }
            this.cycleCnt = this.getMinGroupCycleCnt();
            if (this.isAllGroupsIdle() && this.cycleCnt >= this.tagCycleReq.getInt()) {
                this.state = 0;
                this.reset(false);
            } else if (this.isGroupsError()) {
                this.state = 4;
            }
        }
        if (this.taskId != this.tagTaskId.getInt() || this.cycleCnt != this.tagCycleCnt.getInt() || this.state != this.tagState.getInt()) {
            this.updateLineStatus();
        }
        this.updateTags();
        this.updateLiveData();
    }

    private void updateTags() {
        this.tagTaskId.setInt(this.taskId);
        this.tagCycleCnt.setInt(this.cycleCnt);
        this.tagState.setInt(this.state);
    }

    private boolean isAllGroupsIdle() {
        return this.groups.stream().allMatch(KkGroup::isIdle);
    }

    private boolean isGroupsError() {
        return this.groups.stream().anyMatch(KkGroup::isError);
    }

    private int getMinGroupCycleCnt() {
        return this.groups.stream().mapToInt(KkGroup::getCycleCnt).min().orElse(0);
    }

    private boolean applyTask(KkTask task) throws SQLException {
        this.taskId = task.taskId;
        this.receiptId = task.receiptId;
        this.tagReceiptName.setReadValString(task.receiptName);
        this.tagCycleReq.setInt(task.cycleReq);
        this.cycleCnt = 0;
        this.groups.forEach(KkGroup::reset);
        for (KkDoser doser : this.dosers) {
            doser.applyTask(task);
        }
        boolean res = task.applied();
        this.updateTaskStatus(res ? 1 : 2);
        return res;
    }

    private void reset(boolean resetReceptCounters) {
        this.taskId = 0;
        this.groups.forEach(KkGroup::reset);
        if (resetReceptCounters) {
            this.receiptId = 0;
            this.tagReceiptName.setReadValString("");
            this.cycleCnt = 0;
            this.tagCycleReq.setInt(0);
        }
    }

    private boolean isResetRequested() throws SQLException {
        String sql;
        boolean res = this.tagReset.getBool();
        if (!res) {
            sql = String.format("select resetflag from kk_line where id=%d", this.id);
            try (ResultSet rs = this.module.getStatement().executeQuery(sql);){
                if (rs.next()) {
                    res = rs.getInt(1) > 0;
                }
            }
        }
        if (res) {
            this.tagReset.setBool(false);
            sql = String.format("update kk_line set  resetflag=0 where id=%d", this.id);
            this.module.getStatement().executeUpdate(sql);
            return true;
        }
        return false;
    }

    private void updateTaskStatus(int taskStatus) throws SQLException {
        String dt = LocalDateTime.now().format(this.module.getFormatter());
        String sql = String.format("update kk_task set status=%d, dtexec='%s' where id=%d", taskStatus, dt, this.taskId);
        this.module.getStatement().executeUpdate(sql);
    }

    private void updateLineStatus() throws SQLException {
        int status = 0;
        switch (this.state) {
            case 0: {
                status = 0;
                break;
            }
            case 1: 
            case 2: {
                status = 2;
                break;
            }
            case 3: 
            case 4: {
                status = 1;
            }
        }
        String sql = String.format("update kk_line set status=%d, cur_task_id=%d, cur_cyclenum=%d where id=%d", status, this.taskId, this.cycleCnt, this.id);
        this.module.getStatement().executeUpdate(sql);
    }

    void saveWeight(int storageId, int productId, int aCycleCnt, long weight, long weightBeg, long weightEnd) throws SQLException {
        if (this.receiptId > 0 && !this.isExistReceiptId()) {
            this.receiptId = 0;
        }
        if (this.receiptId == 0) {
            this.createZeroReceipt();
        }
        if (this.taskId == 0 || !this.isExistTaskId()) {
            this.createZeroReceipt();
            this.createFakeTask();
        }
        if (this.receiptId == 0) {
            productId = this.getCurrentProductId(storageId);
        }
        if (productId > 0 && !this.isExistProductId(productId)) {
            productId = 0;
        }
        if (productId == 0) {
            this.createZeroProduct();
        }
        int executeId = this.findOrCreateExecuteId(aCycleCnt);
        this.insertIntoRashod(storageId, productId, executeId, weight, weightBeg, weightEnd);
        this.updateOrCreateOutput(executeId);
    }

    private boolean isExistTaskId() throws SQLException {
        String sql = String.format("select 1 from kk_task where id=%d", this.taskId);
        try (ResultSet rs = this.module.getStatement().executeQuery(sql);){
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean isExistReceiptId() throws SQLException {
        String sql = String.format("select 1 from kk_receipt where id=%d", this.receiptId);
        try (ResultSet rs = this.module.getStatement().executeQuery(sql);){
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean isExistProductId(int productId) throws SQLException {
        String sql = String.format("select 1 from kk_product where id=%d", productId);
        try (ResultSet rs = this.module.getStatement().executeQuery(sql);){
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void createZeroReceipt() throws SQLException {
        this.receiptId = 0;
        this.tagReceiptName.setReadValString(ZERO_RECEIPT_NAME);
        if (!this.isExistReceiptId()) {
            String sql = "insert into kk_receipt (id, name, descr) values (0, '\u0414\u041e\u0417\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u0415 \u0411\u0415\u0417 \u0417\u0410\u0414\u0410\u0427\u0418 (\u0420\u0423\u0427\u041d\u041e\u0415)', '\u041f\u0443\u0441\u0442\u043e\u0439 \u0440\u0435\u0446\u0435\u043f\u0442. \u0421\u043e\u0437\u0434\u0430\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0443\u0447\u0435\u0442\u0430 \u043e\u0442\u0432\u0435\u0448\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043f\u0440\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439 \u0437\u0430\u0434\u0430\u0447\u0438 \u043d\u0430 \u043b\u0438\u043d\u0438\u0438.)')";
            this.module.getStatement().executeUpdate(sql);
        }
    }

    private void createZeroProduct() throws SQLException {
        if (!this.isExistProductId(0)) {
            String sql = "insert into kk_product (id, name, descr) values (0, '\u041d\u0415\u0418\u0417\u0412\u0415\u0421\u0422\u041d\u042b\u0419 \u041f\u0420\u041e\u0414\u0423\u041a\u0422', '\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442. \u0421\u043e\u0437\u0434\u0430\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438.')";
            this.module.getStatement().executeUpdate(sql);
        }
    }

    private void createFakeTask() throws SQLException {
        String dt = LocalDateTime.now().format(this.module.getFormatter());
        String sql = String.format("insert into kk_task (line_id, receipt_id, dt, dtexec, cycleqnt, status, errcode, enabled ) values (%d, %d, '%s', '%s', %d, %d, %d, %d)", this.id, this.receiptId, dt, dt, 0, 4, 0, 1);
        this.taskId = this.module.getDatabase().insertReturningId(this.module.getStatement(), sql, new String[0]);
    }

    private int getCurrentProductId(int storageId) throws SQLException {
        String sql = String.format("select product_id from kk_storage where id=%d", storageId);
        try (ResultSet rs = this.module.getStatement().executeQuery(sql);){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    private int findOrCreateExecuteId(int aCycleCnt) throws SQLException {
        String sql = String.format("select id from kk_execute where task_id=%d and cyclenum=%d", this.taskId, aCycleCnt + 1);
        int executeId = 0;
        try (ResultSet rs = this.module.getStatement().executeQuery(sql);){
            if (rs.next()) {
                executeId = rs.getInt(1);
            }
        }
        if (executeId == 0) {
            String dt = LocalDateTime.now().format(this.module.getFormatter());
            sql = String.format("insert into kk_execute (task_id, dt, cyclenum, status, mixtime) values (%d, '%s', %d, %d, %d)", this.taskId, dt, aCycleCnt + 1, 0, 0);
            executeId = this.module.getDatabase().insertReturningId(this.module.getStatement(), sql, new String[0]);
        }
        return executeId;
    }

    private void updateOrCreateOutput(int executeId) throws SQLException {
        Statement st = this.module.getStatement();
        String sql = String.format("select id from kk_output where execute_id=%d", executeId);
        int outputId = 0;
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                outputId = rs.getInt(1);
            }
        }
        sql = String.format("select sum(kg) from kk_rashod where execute_id=%d", executeId);
        double sumKg = 0.0;
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                sumKg = rs.getDouble(1);
            }
        }
        String dt = LocalDateTime.now().format(this.module.getFormatter());
        if (outputId == 0) {
            sql = String.format(Locale.ROOT, "insert into kk_output (execute_id, receipt_id, dt, kg) values (%d, %d, '%s', %f)", executeId, this.receiptId, dt, sumKg);
            st.executeUpdate(sql);
        } else {
            sql = String.format("delete from kk_output where id=%d", outputId);
            st.executeUpdate(sql);
            sql = String.format(Locale.ROOT, "insert into kk_output (id, execute_id, receipt_id, dt, kg) values (%d, %d, %d, '%s', %f)", outputId, executeId, this.receiptId, dt, sumKg);
            st.executeUpdate(sql);
        }
    }

    private void insertIntoRashod(int storageId, int productId, int executeId, long weight, long weightBeg, long weightEnd) throws SQLException {
        String dt = LocalDateTime.now().format(this.module.getFormatter());
        String sql = String.format(Locale.ROOT, "insert into kk_rashod (storage_id, product_id, execute_id, dt, kg, w1, w2) values (%d, %d, %d, '%s', %f, %d, %d)", storageId, productId, executeId, dt, (double)weight / 1000.0, weightBeg, weightEnd);
        this.module.getStatement().executeUpdate(sql);
    }

    private KkTask findTask() throws SQLException {
        Statement st = this.module.getStatement();
        String sql = String.format("select id from kk_task where line_id=%d and dtexec is null and enabled=1 order by dt", this.id);
        int newTaskId = 0;
        try (ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                newTaskId = rs.getInt(1);
            }
        }
        if (newTaskId == 0) {
            return null;
        }
        sql = String.format("select t.id, t.receipt_id, t.cycleqnt, tc.product_id, tc.storage_id, tc.kg, r.name rname, p.name pname from kk_task t join kk_taskcontent tc on tc.task_id=t.id join kk_receipt r on r.id=t.receipt_id join kk_product p on p.id=tc.product_id where t.id=%d", newTaskId);
        KkTask task = null;
        try (ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                if (task == null) {
                    task = new KkTask(rs.getInt("id"), rs.getInt("receipt_id"), rs.getString("rname"), rs.getInt("cycleqnt"));
                }
                task.addDetail(rs.getString("pname"), rs.getInt("product_id"), rs.getInt("storage_id"), Math.round(rs.getDouble("kg") * 1000.0));
            }
        }
        return task;
    }

    public int getId() {
        return this.id;
    }

    int getCycleReq() {
        return this.tagCycleReq.getInt();
    }

    int getCycleCnt() {
        return this.cycleCnt;
    }

    public boolean isRunning() {
        return this.state == 1;
    }

    public String getProblems() {
        Object res = this.dosers.stream().map(KkDoser::getProblems).filter(check -> !check.isEmpty()).collect(Collectors.joining("\r\n \r\n"));
        if (!((String)res).isEmpty()) {
            res = "Line \"" + this.name + "\":\r\n" + (String)res;
        }
        return res;
    }

    public String getInfo() {
        return "line" + this.linenum + ": " + this.name + ", " + this.getStateStr() + " task=" + this.taskId + " req=" + String.valueOf(this.tagCycleReq) + " cnt=" + this.cycleCnt + " [" + String.valueOf(this.tagReceiptName) + "]\r\n" + this.groups.stream().map(KkGroup::getInfo).collect(Collectors.joining("\r\n"));
    }

    private String getStateStr() {
        switch (this.state) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "RUN";
            }
            case 2: {
                return "SUSPEND";
            }
            case 3: {
                return "ERROR TASK NOT APPLIED";
            }
            case 4: {
                return "ERROR TASK REJECTED";
            }
        }
        return "";
    }
}

