/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class BuhlerFBALModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(BuhlerFBALModule.class);
    private static int CMD_START = 2;
    private static int CMD_STOP = 0;
    private static int BUFF_SIZE = 64;
    protected int[] buffin = new int[BUFF_SIZE];
    protected int[] buffout = new int[BUFF_SIZE];
    protected int[] buffcmd = new int[BUFF_SIZE];
    protected Tag tagCrc;
    protected Tag tagSumWesHigh;
    protected Tag tagSumWesLow;
    protected Tag tagWNum;
    protected Tag tagLastWes;
    protected Tag tagCurWes;
    protected Tag tagStageNum;
    protected Tag tagErrCode;
    protected Tag tagWCycle;
    protected TagRW tagReqOutput;
    protected Tag tagReqDose;
    protected Tag tagCmdStop;
    protected TagRW tagCmdStart;
    protected Tag tagCmdSetOutput;
    protected Tag tagCmdSetDose;
    protected Tag tagTotalWeight;
    protected Tag tagAlarm;
    protected Tag tagStatus;
    protected Tag tagCapacity;
    protected Tag tagErzWeightLow;
    protected Tag tagDecimalPoint;
    protected TagRW tagMinOutput;
    protected TagRW tagMaxOutput;
    protected TagRW tagResetErr;
    protected TagRW tagWesSvrState;
    private long wesSvrStateTimer;

    public BuhlerFBALModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagCrc = this.tagtable.createInt("Crc", 0);
        this.tagSumWesHigh = this.tagtable.createInt("SumWesHigh", 0, 8);
        this.tagSumWesLow = this.tagtable.createInt("SumWesLow", 0, 8);
        this.tagWNum = this.tagtable.createInt("WNum", 0, 8);
        this.tagLastWes = this.tagtable.createInt("LastWes", 0, 8);
        this.tagCurWes = this.tagtable.createInt("CurWes", 0, 8);
        this.tagStageNum = this.tagtable.createInt("StageNum", 0, 8);
        this.tagErrCode = this.tagtable.createInt("ErrCode", 0, 8);
        this.tagWCycle = this.tagtable.createInt("WCycle", 0, 8);
        this.tagReqOutput = this.tagtable.createRWInt("ReqOutput", 0, 8);
        this.tagReqDose = this.tagtable.createInt("ReqDose", 0, 8);
        this.tagCmdStop = this.tagtable.createInt("CmdStop", 0, 8);
        this.tagCmdStart = this.tagtable.createRWInt("CmdStart", 0, 8);
        this.tagCmdSetOutput = this.tagtable.createInt("CmdSetOutput", 0, 8);
        this.tagCmdSetDose = this.tagtable.createInt("CmdSetDose", 0, 8);
        this.tagTotalWeight = this.tagtable.createInt("TotalWeight", 0, 8);
        this.tagAlarm = this.tagtable.createInt("Alarm", 0, 8);
        this.tagStatus = this.tagtable.createInt("Status", 0, 8);
        this.tagCapacity = this.tagtable.createInt("Capacity", 0, 8);
        this.tagErzWeightLow = this.tagtable.createInt("ErzWeightLow", 0, 8);
        this.tagDecimalPoint = this.tagtable.createInt("DecimalPoint", 0, 8);
        this.tagMinOutput = this.tagtable.createRWInt("MinOutput", 0, 8);
        this.tagMaxOutput = this.tagtable.createRWInt("MaxOutput", 0, 8);
        this.tagResetErr = this.tagtable.createRWInt("ResetErr", 0, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (!this.emulated) {
            try {
                result = this.request('h', 40, 0);
                if (result) {
                    this.tagStatus.setInt(Numbers.asciiToInt(this.buffin, 1, 3));
                    this.tagStageNum.setInt(Numbers.asciiToInt(this.buffin, 3, 5));
                    this.tagErrCode.setInt(Numbers.asciiToInt(this.buffin, 5, 7));
                    this.tagCapacity.setInt(Numbers.asciiToInt(this.buffin, 7, 13));
                    this.tagCurWes.setInt(Numbers.asciiToInt(this.buffin, 13, 19));
                    this.tagErzWeightLow.setInt(Numbers.asciiToInt(this.buffin, 19, 27));
                    int valWes = Numbers.asciiToInt(this.buffin, 27, 35);
                    this.tagSumWesHigh.setInt(valWes / 65536);
                    this.tagSumWesLow.setInt(valWes % 65536);
                    this.tagTotalWeight.setInt(valWes);
                }
                if (this.tagReqOutput.hasWriteValue()) {
                    int i;
                    int posPrepend = 6;
                    int value = this.tagReqOutput.getWriteValInt();
                    String strCmd = String.valueOf(value);
                    posPrepend -= strCmd.length();
                    for (i = 0; i < posPrepend; ++i) {
                        this.buffcmd[i] = 48;
                    }
                    for (i = 0; i < strCmd.length(); ++i) {
                        this.buffcmd[i + posPrepend] = strCmd.charAt(i);
                    }
                    result = this.request('Q', 2, 6);
                    if (!result) {
                        this.tagReqOutput.setInt(value);
                    } else {
                        this.tagReqOutput.setReadValInt(value);
                    }
                }
                if (this.tagCmdStart.hasWriteValue()) {
                    this.tagCmdStop.setInt(0);
                    int value = this.tagCmdStart.getWriteValInt();
                    this.buffcmd[0] = String.valueOf(value).charAt(0);
                    result = this.request('S', 2, 1);
                    if (result) {
                        this.tagCmdStart.setReadValInt(value);
                    }
                    this.tagCmdStart.setInt(value);
                }
                if (this.tagCmdStop.getInt() == 1) {
                    this.tagCmdStart.setInt(0);
                    this.buffcmd[0] = 48;
                    result = this.request('S', 2, 1);
                    if (result) {
                        this.tagCmdStop.setInt(0);
                    }
                }
                if (this.tagResetErr.hasWriteValue()) {
                    this.buffcmd[0] = 57;
                    this.buffcmd[1] = 48;
                    this.buffcmd[2] = 48;
                    this.buffcmd[3] = 48;
                    this.buffcmd[4] = 48;
                    this.buffcmd[5] = 48;
                    this.buffcmd[6] = 48;
                    this.buffcmd[7] = 48;
                    this.buffcmd[8] = 48;
                    this.buffcmd[9] = 48;
                    this.buffcmd[10] = 48;
                    this.buffcmd[11] = 48;
                    this.buffcmd[12] = 48;
                    this.buffcmd[13] = 48;
                    this.buffcmd[14] = 48;
                    this.buffcmd[15] = 48;
                    this.buffcmd[16] = 48;
                    this.buffcmd[17] = 48;
                    this.buffcmd[18] = 48;
                    this.buffcmd[19] = 48;
                    result = this.request('A', 2, 20);
                    if (!result) {
                        // empty if block
                    }
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                result = false;
            }
        }
        String crcstr = this.tagTotalWeight.getString() + ";" + this.tagWNum.getString();
        this.tagCrc.setInt(CRC.getCrc8(crcstr));
        this.wesSvrStateTimer = BuhlerFBALModule.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }

    private boolean request(char param, int sizeAnsw, int sizeAsk) throws Exception {
        if (this.port == null) {
            return false;
        }
        int posPrm = 3;
        int crc = 0;
        this.buffout[0] = 62;
        Numbers.intToHexByte(this.netaddr, this.buffout, 1);
        this.buffout[posPrm] = param;
        for (int i = 0; i < sizeAsk; ++i) {
            this.buffout[++posPrm] = this.buffcmd[i];
        }
        crc = this.calcCrc(this.buffout, 1, posPrm);
        Numbers.intToHexByte(crc, this.buffout, ++posPrm);
        ++posPrm;
        int n = ++posPrm;
        ++posPrm;
        this.buffout[n] = 13;
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            StringBuilder strBuf1 = new StringBuilder();
            for (int i = 0; i < posPrm; ++i) {
                strBuf1.append((char)this.buffout[i]);
            }
            this.port.discard();
            this.port.writeBytes(this.buffout, posPrm);
            int n2 = this.port.readBytes(this.buffin, sizeAnsw);
            if (n2 == sizeAnsw) {
                int crcRcvd;
                if (this.buffin[0] != 65) continue;
                if (sizeAnsw <= 2) {
                    return true;
                }
                StringBuilder strBuf = new StringBuilder();
                for (int i = sizeAnsw - 3; i < sizeAnsw - 1; ++i) {
                    strBuf.append((char)this.buffin[i]);
                }
                crc = this.calcCrc(this.buffin, 1, sizeAnsw - 4);
                if (crc != (crcRcvd = Integer.parseInt(strBuf.toString(), 16))) continue;
                return true;
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }

    private int calcCrc(int[] bytes, int begin, int end) {
        int crc = 0;
        for (int index = begin; index <= end; ++index) {
            int data = bytes[index];
            crc += data;
        }
        return crc & 0xFF;
    }
}

