/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolKontakt1;
import promauto.utils.Numbers;

public class Kontakt1Tur01Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(Kontakt1Tur01Module.class);
    protected ProtocolKontakt1 protocol = new ProtocolKontakt1(this);
    public Tag tagValue;
    public Tag tagPrimeval;
    public Tag tagPercent;
    public Tag tagMax;
    public Tag tagMin;
    public Tag tagPointV1;
    public Tag tagPointP1;
    public Tag tagPointV2;
    public Tag tagPointP2;
    public Tag tagSPmax;
    public Tag tagSPmin;
    public Tag tagBlok;
    public Tag tagBlokValue;
    public Tag tagTmprCnt;
    public Tag[] tagT;
    protected int size;

    public Kontakt1Tur01Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.size = cm.get(conf, "size", 0);
        this.tagValue = this.tagtable.createInt("Value", 0, 8);
        this.tagPrimeval = this.tagtable.createInt("Primeval", 0, 8);
        this.tagPercent = this.tagtable.createInt("Percent", 0, 8);
        this.tagMax = this.tagtable.createInt("Max", 0, 8);
        this.tagMin = this.tagtable.createInt("Min", 0, 8);
        this.tagPointV1 = this.tagtable.createInt("PointV1", 0, 1);
        this.tagPointP1 = this.tagtable.createInt("PointP1", 0, 1);
        this.tagPointV2 = this.tagtable.createInt("PointV2", 0, 1);
        this.tagPointP2 = this.tagtable.createInt("PointP2", 0, 1);
        this.tagSPmax = this.tagtable.createInt("SPmax", 0, 1);
        this.tagSPmin = this.tagtable.createInt("SPmin", 0, 1);
        this.tagBlok = this.tagtable.createInt("Blok", 0, 1);
        this.tagBlokValue = this.tagtable.createInt("BlokValue", 0, 1);
        this.tagTmprCnt = this.tagtable.createInt("TmprCnt", 0, 8);
        this.tagT = new Tag[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.tagT[i] = this.tagtable.createInt(String.format("T%02d", i), 0, 8);
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < this.size; ++i) {
            this.addChannelMapTag(chtags, this.tagT[i], "" + i);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            if (this.firstPass || this.tagError.getBool()) {
                this.protocol.buffout[1] = 180;
                this.protocol.buffout[2] = 2;
                this.protocol.buffout[3] = 1;
                result = this.protocol.request(6, 6);
                this.tagTmprCnt.setInt(this.protocol.buffin[3]);
                this.protocol.setupBuffIn(this.tagTmprCnt.getInt());
            }
            this.protocol.buffout[1] = 1;
            this.protocol.buffout[2] = 2;
            this.protocol.buffout[3] = 1;
            if (result && (result = this.protocol.request(6, 10))) {
                this.tagPrimeval.setInt(Numbers.bytesToWord(this.protocol.buffin, 3));
                if (!this.tagBlok.getBool()) {
                    if (this.tagPointP1.getInt() < this.tagPointP2.getInt() && this.tagPointV1.getInt() < this.tagPointV2.getInt()) {
                        float p = this.tagPrimeval.getInt();
                        float p1 = this.tagPointP1.getInt();
                        float p2 = this.tagPointP2.getInt();
                        float v1 = this.tagPointV1.getInt();
                        float v2 = this.tagPointV2.getInt();
                        this.tagValue.setInt(Math.round((p - p1) * (v2 - v1) / (p2 - p1) + v1));
                    } else {
                        this.tagPrimeval.copyValueTo(this.tagValue);
                    }
                }
            }
            if (this.tagBlok.getBool()) {
                this.tagValue.setInt(this.tagBlokValue.getInt());
            }
            if (this.tagSPmin.getInt() < this.tagSPmax.getInt()) {
                this.tagMin.setBool(this.tagValue.getInt() <= this.tagSPmin.getInt());
                this.tagMax.setBool(this.tagValue.getInt() >= this.tagSPmax.getInt());
                if (this.tagMin.getBool()) {
                    this.tagPercent.setInt(0);
                } else if (this.tagMax.getBool()) {
                    this.tagPercent.setInt(100);
                } else {
                    this.tagPercent.setDouble(Math.round(100.0 * (double)(this.tagValue.getInt() - this.tagSPmin.getInt()) / (double)(this.tagSPmax.getInt() - this.tagSPmin.getInt())));
                }
            } else {
                this.tagPercent.setInt(0);
            }
            this.protocol.buffout[1] = 1;
            this.protocol.buffout[2] = 2;
            this.protocol.buffout[3] = 2;
            if (result && (result = this.protocol.request(6, this.protocol.calcTmprPackageLen(this.tagTmprCnt.getInt())))) {
                int n = Math.min(this.tagTmprCnt.getInt(), this.size);
                for (int i = 0; i < n; ++i) {
                    short v = (short)Numbers.bytesToWord(this.protocol.buffin, i * 2 + 3);
                    this.tagT[i].setDouble((double)v * 10.0 / 16.0);
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        return result;
    }

    @Override
    protected boolean reload() {
        int i;
        Kontakt1Tur01Module tmp = new Kontakt1Tur01Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        if (this.size < tmp.size) {
            System.arraycopy(this.tagT, 0, tmp.tagT, 0, this.size);
            this.tagT = tmp.tagT;
            for (i = this.size; i < tmp.size; ++i) {
                this.tagtable.add(this.tagT[i]);
            }
        }
        if (this.size > tmp.size) {
            System.arraycopy(this.tagT, 0, tmp.tagT, 0, tmp.size);
            for (i = tmp.size; i < this.size; ++i) {
                this.tagtable.remove(this.tagT[i]);
            }
            this.tagT = tmp.tagT;
        }
        this.size = tmp.size;
        return true;
    }
}

