/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;

public class LsisSvIp5aModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(LsisSvIp5aModule.class);
    private static int C_EOC = 4;
    private static int C_ENQ = 5;
    private static int C_ACK = 6;
    private static int C_NACK = 21;
    private static int CMD_READ = 82;
    private static int CMD_WRITE = 87;
    private static String S_addrFreqRefer = "0005";
    private static String S_addrRunCmd = "0006";
    private static String S_addrAccelTime = "0007";
    private static String S_addrDecelTime = "0008";
    private static String S_addrOutCurrent = "0009";
    private static String S_addrOutFreq = "000A";
    private static String S_addrOutVoltage = "000B";
    private static String S_addrStatus = "000E";
    private static String S_addrTripInfo = "000F";
    protected TagRW tagReg0005;
    protected TagRW tagReg0006;
    protected TagRW tagReg0007;
    protected TagRW tagReg0008;
    protected Tag tagReg0009;
    protected Tag tagReg000A;
    protected Tag tagReg000B;
    protected Tag tagReg000C;
    protected Tag tagReg000D;
    protected Tag tagReg000E;
    protected Tag tagReg000F;
    private static int BUFF_SIZE = 64;
    protected int[] buffin = new int[BUFF_SIZE];
    protected int[] buffout = new int[BUFF_SIZE];

    public LsisSvIp5aModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagReg0005 = this.tagtable.createRWInt("Reg.R005", 0, 8);
        this.tagReg0006 = this.tagtable.createRWInt("Reg.R006", 0, 8);
        this.tagReg0007 = this.tagtable.createRWInt("Reg.R007", 0, 8);
        this.tagReg0008 = this.tagtable.createRWInt("Reg.R008", 0, 8);
        this.tagReg0009 = this.tagtable.createInt("Reg.R009", 0, 8);
        this.tagReg000A = this.tagtable.createInt("Reg.R00A", 0, 8);
        this.tagReg000B = this.tagtable.createInt("Reg.R00B", 0, 8);
        this.tagReg000C = this.tagtable.createInt("Reg.R00C", 0, 8);
        this.tagReg000D = this.tagtable.createInt("Reg.R00D", 0, 8);
        this.tagReg000E = this.tagtable.createInt("Reg.R00E", 0, 8);
        this.tagReg000F = this.tagtable.createInt("Reg.R00F", 0, 8);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.tagReg0005.acceptWriteValue();
            this.tagReg0006.acceptWriteValue();
            this.tagReg0007.acceptWriteValue();
            this.tagReg0008.acceptWriteValue();
            return true;
        }
        boolean result = true;
        try {
            int value = 0;
            if (this.tagReg0005.hasWriteValue()) {
                value = this.tagReg0005.getWriteValInt();
                this.tagReg0005.setReadValInt(value);
                result = this.request_write(S_addrFreqRefer, value);
            }
            if (this.tagReg0006.hasWriteValue()) {
                value = this.tagReg0006.getWriteValInt();
                this.tagReg0006.setReadValInt(value);
                result = this.request_write(S_addrRunCmd, value);
            }
            if (this.tagReg0007.hasWriteValue()) {
                value = this.tagReg0007.getWriteValInt();
                this.tagReg0007.setReadValInt(value);
                result = this.request_write(S_addrAccelTime, value);
            }
            if (this.tagReg0008.hasWriteValue()) {
                value = this.tagReg0008.getWriteValInt();
                this.tagReg0008.setReadValInt(value);
                result = this.request_write(S_addrDecelTime, value);
            }
            if (!result) {
                return result;
            }
            result = this.request_read(S_addrAccelTime, 6);
            if (result) {
                int ival;
                Object str;
                int i;
                block14: for (i = 0; i < 4; ++i) {
                    str = "";
                    str = (String)str + Character.toString((char)this.buffin[4 + i * 4]);
                    str = (String)str + Character.toString((char)this.buffin[5 + i * 4]);
                    str = (String)str + Character.toString((char)this.buffin[6 + i * 4]);
                    str = (String)str + Character.toString((char)this.buffin[7 + i * 4]);
                    ival = Integer.parseInt((String)str, 16);
                    switch (i) {
                        case 0: {
                            this.tagReg0007.setReadValInt(ival);
                            continue block14;
                        }
                        case 1: {
                            this.tagReg0008.setReadValInt(ival);
                            continue block14;
                        }
                        case 2: {
                            this.tagReg0009.setInt(ival);
                            continue block14;
                        }
                        case 3: {
                            this.tagReg000A.setInt(ival);
                            continue block14;
                        }
                        case 4: {
                            this.tagReg000B.setInt(ival);
                            continue block14;
                        }
                        case 5: {
                            this.tagReg000C.setInt(ival);
                        }
                    }
                }
                result = this.request_read(S_addrStatus, 2);
                if (result) {
                    block15: for (i = 0; i < 2; ++i) {
                        str = "";
                        str = (String)str + Character.toString((char)this.buffin[4 + i * 4]);
                        str = (String)str + Character.toString((char)this.buffin[5 + i * 4]);
                        str = (String)str + Character.toString((char)this.buffin[6 + i * 4]);
                        str = (String)str + Character.toString((char)this.buffin[7 + i * 4]);
                        ival = Integer.parseInt((String)str, 16);
                        switch (i) {
                            case 0: {
                                this.tagReg000E.setInt(ival);
                                continue block15;
                            }
                            case 1: {
                                this.tagReg000F.setInt(ival);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean request_read(String strAddr, int iBytes) throws Exception {
        this.buffout[3] = CMD_READ;
        this.buffout[8] = String.format("%01x", iBytes).charAt(0);
        int iAns = 7 + iBytes * 4;
        return this.request(strAddr, iAns, iBytes, 9);
    }

    private boolean request_write(String strAddr, int iValue) throws Exception {
        this.buffout[3] = CMD_WRITE;
        this.buffout[8] = 49;
        String strVal = String.format("%04x", iValue);
        for (int i = 0; i < 4; ++i) {
            this.buffout[9 + i] = strVal.charAt(i);
        }
        return this.request(strAddr, 11, 1, 13);
    }

    private boolean request(String strRegAddr, int sizeAnsw, int bytesToProcs, int iSumPos) throws Exception {
        if (this.port == null) {
            return false;
        }
        int crc = 0;
        String sAddr = String.format("%02x", this.netaddr).toUpperCase();
        this.buffout[0] = C_ENQ;
        this.buffout[1] = sAddr.charAt(0);
        this.buffout[2] = sAddr.charAt(1);
        for (int i = 0; i < 4; ++i) {
            this.buffout[i + 4] = strRegAddr.charAt(i);
        }
        crc = this.calcCrc(this.buffout, 1, iSumPos - 1);
        String sCrc = String.format("%02x", crc).toUpperCase();
        this.buffout[iSumPos] = sCrc.charAt(0);
        this.buffout[iSumPos + 1] = sCrc.charAt(1);
        this.buffout[iSumPos + 2] = C_EOC;
        this.port.discard();
        this.port.writeBytes(this.buffout, iSumPos + 3);
        for (int n = 0; n < sizeAnsw; ++n) {
            this.buffin[n] = this.port.readByte();
            if (n != 0 || this.buffin[n] != C_NACK && this.buffin[n] == C_ACK) continue;
            this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
            return false;
        }
        crc = this.calcCrc(this.buffin, 1, sizeAnsw - 4);
        sCrc = String.format("%02x", crc).toUpperCase();
        Object sCrcReceived = Character.toString((char)this.buffin[sizeAnsw - 3]);
        if (sCrc.compareTo((String)(sCrcReceived = (String)sCrcReceived + Character.toString((char)this.buffin[sizeAnsw - 2]))) != 0) {
            this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
            return false;
        }
        return true;
    }

    private int calcCrc(int[] bytes, int begin, int end) {
        int crc = 0;
        for (int index = begin; index <= end; ++index) {
            int data = bytes[index];
            crc += data;
        }
        return crc & 0xFF;
    }
}

