/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.core.tags.TagRWBool;
import promauto.jroboplc.core.tags.TagRWDouble;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.core.tags.TagRWLong;
import promauto.jroboplc.core.tags.TagRWString;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;
import promauto.utils.Numbers;

public class ModbusTag {
    public String name = "";
    public String tracktagName = "";
    public Type type = Type.UINT16;
    public Region region = Region.HLDREG;
    public Access access = Access.RW;
    public boolean inverted = false;
    public int address = 0;
    public int size = 1;
    public boolean littleEndian = false;
    public boolean readEnd = false;
    public boolean readOnce = false;
    public boolean writeSingle = true;
    public boolean writeMultiple = true;
    public boolean enable = true;
    public boolean bitNameOnly = false;
    public int mul = 1;
    public TagRW tag;
    public ModbusTag tracktag;
    public boolean needWrite;

    public static ModbusTag create(String name, int address) {
        return new ModbusTag().name(name).address(address);
    }

    public ModbusTag name(String name) {
        this.name = name;
        return this;
    }

    public ModbusTag type(Type type) {
        this.type = type;
        return this;
    }

    public ModbusTag inverted(boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    public ModbusTag region(Region region) {
        this.region = region;
        return this;
    }

    public ModbusTag access(Access access) {
        this.access = access;
        return this;
    }

    public ModbusTag address(int address) {
        this.address = address;
        return this;
    }

    public ModbusTag littleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
        return this;
    }

    public ModbusTag readEnd(boolean readEnd) {
        this.readEnd = readEnd;
        return this;
    }

    public ModbusTag writeSingle(boolean writeSingle) {
        this.writeSingle = writeSingle;
        return this;
    }

    public ModbusTag writeMultiple(boolean writeMultiple) {
        this.writeMultiple = writeMultiple;
        return this;
    }

    public ModbusTag enable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public ModbusTag size(int size) {
        this.size = size;
        return this;
    }

    public ModbusTag trackName(String tracktagName) {
        this.tracktagName = tracktagName;
        return this;
    }

    public boolean isWriteOnly() {
        return this.access == Access.WO;
    }

    public void init() {
        if (this.region == Region.DSCINP || this.region == Region.INPREG || this.type == Type.STRING) {
            this.access = Access.RO;
        }
        if (this.region == Region.COIL || this.region == Region.DSCINP) {
            this.type = Type.BOOL;
            this.size = 1;
        } else {
            switch (this.type.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: {
                    this.size = 1;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    this.size = 2;
                    break;
                }
                case 7: {
                    this.size = Math.max(this.size, 1);
                }
            }
        }
        switch (this.type.ordinal()) {
            case 0: {
                this.tag = new TagRWBool(this.name, false, 8);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.tag = new TagRWInt(this.name, 0, 8);
                break;
            }
            case 4: {
                this.tag = new TagRWLong(this.name, 0L, 8);
                break;
            }
            case 5: 
            case 6: {
                this.tag = new TagRWDouble(this.name, 0.0, 8);
                break;
            }
            case 7: {
                this.tag = new TagRWString(this.name, "", 8);
            }
        }
        if (this.mul == 0) {
            this.mul = 1;
        }
    }

    public void putValueIntoBuff(int[] buff, int pos) {
        switch (this.type.ordinal()) {
            case 0: {
                buff[pos] = this.tag.getWriteValBool() ^ this.inverted ? 1 : 0;
                break;
            }
            case 1: 
            case 2: {
                buff[pos] = this.transformWrite(this.tag.getWriteValInt()) & 0xFFFF;
                break;
            }
            case 3: 
            case 4: {
                long l = (long)this.transformWrite(this.tag.getWriteValInt()) & 0xFFFFFFFFL;
                if (this.littleEndian) {
                    buff[pos + 1] = (int)(l >> 16);
                    buff[pos] = (int)(l & 0xFFFFL);
                    break;
                }
                buff[pos] = (int)(l >> 16);
                buff[pos + 1] = (int)(l & 0xFFFFL);
                break;
            }
            case 5: {
                buff[pos] = Numbers.encodeFloat16((float)this.transformWrite(this.tag.getWriteValDouble()));
                break;
            }
            case 6: {
                long l = (long)Numbers.encodeFloat32((float)this.transformWrite(this.tag.getWriteValDouble())) & 0xFFFFFFFFL;
                if (this.littleEndian) {
                    buff[pos + 1] = (int)(l >> 16);
                    buff[pos] = (int)(l & 0xFFFFL);
                    break;
                }
                buff[pos] = (int)(l >> 16);
                buff[pos + 1] = (int)(l & 0xFFFFL);
                break;
            }
        }
    }

    public void fetchValueFromProtocolBuffin(ProtocolModbus protocol, int pos) {
        switch (this.type.ordinal()) {
            case 0: {
                this.tag.setReadValBool(protocol.getAnswerWord(pos) != 0 ^ this.inverted);
                break;
            }
            case 1: {
                this.tag.setReadValInt((short)this.transformRead(protocol.getAnswerWord(pos)));
                break;
            }
            case 2: {
                this.tag.setReadValInt(this.transformRead(protocol.getAnswerWord(pos)));
                break;
            }
            case 3: {
                this.tag.setReadValInt(this.transformRead(protocol.getAnswerInt32(pos, this.littleEndian)));
                break;
            }
            case 4: {
                this.tag.setReadValLong(this.transformRead((long)protocol.getAnswerInt32(pos, this.littleEndian) & 0xFFFFFFFFL));
                break;
            }
            case 5: {
                this.tag.setReadValDouble(this.transformRead(Numbers.decodeFloat16(protocol.getAnswerWord(pos))));
                break;
            }
            case 6: {
                this.tag.setReadValDouble(this.transformRead(Numbers.decodeFloat32(protocol.getAnswerInt32(pos, this.littleEndian))));
                break;
            }
            case 7: {
                this.tag.setReadValString(protocol.getAnswerString(pos, this.size));
            }
        }
    }

    private int transformRead(int value) {
        return value * this.mul;
    }

    private long transformRead(long value) {
        return value * (long)this.mul;
    }

    private double transformRead(double value) {
        return value * (double)this.mul;
    }

    private int transformWrite(int value) {
        if (this.mul == 1) {
            return value;
        }
        return (int)Math.round((double)value / (double)this.mul);
    }

    private double transformWrite(double value) {
        return value / (double)this.mul;
    }

    public static enum Type {
        BOOL,
        INT16,
        UINT16,
        INT32,
        UINT32,
        FLOAT16,
        FLOAT32,
        STRING;

    }

    public static enum Region {
        COIL,
        DSCINP,
        HLDREG,
        INPREG;

    }

    public static enum Access {
        RO,
        WO,
        RW;

    }
}

