/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class NotisA100Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(NotisA100Module.class);
    private static int BUFF_SIZE = 12;
    protected int[] buffin = new int[BUFF_SIZE];
    protected int[] buffout = new int[BUFF_SIZE];
    protected Tag tagCrc;
    protected Tag tagSumWeight;
    protected Tag tagSumNum;
    protected Tag tagState;
    protected Tag tagCode;
    protected Tag tagOutput;
    protected TagRW tagWesSvrState;
    private long wesSvrStateTimer;

    public NotisA100Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.tagCrc = this.tagtable.createInt("Crc", 0);
        this.tagSumWeight = this.tagtable.createInt("SumWeight", 0, 8);
        this.tagSumNum = this.tagtable.createInt("SumNum", 0, 8);
        this.tagState = this.tagtable.createInt("State", 0, 8);
        this.tagCode = this.tagtable.createInt("Code", 0, 8);
        this.tagOutput = this.tagtable.createInt("Output", 0, 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result = true;
        if (!this.emulated) {
            try {
                result = this.request(20);
                if (result) {
                    this.tagState.setInt(this.buffin[4]);
                    this.tagCode.setInt(this.buffin[5]);
                    this.tagSumWeight.setInt(Numbers.bytesToIntReverse(this.buffin, 6));
                }
                if (result && (result = this.request(19))) {
                    this.tagSumNum.setInt(Numbers.bytesToIntReverse(this.buffin, 6));
                }
            }
            catch (Exception e) {
                this.env.printError(this.logger, e, this.name);
                result = false;
            }
        }
        String crcstr = this.tagSumWeight.getString() + ";" + this.tagSumNum.getString();
        this.tagCrc.setInt(CRC.getCrc8(crcstr));
        this.wesSvrStateTimer = NotisA100Module.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }

    private boolean request(int param) throws Exception {
        if (this.port == null) {
            return false;
        }
        this.buffout[0] = 128 + this.netaddr;
        this.buffout[1] = 0;
        this.buffout[2] = 24;
        this.buffout[3] = param;
        this.buffout[4] = 0;
        this.buffout[5] = 0;
        this.buffout[6] = 0;
        this.buffout[7] = 0;
        this.buffout[8] = 0;
        this.buffout[9] = 0;
        this.buffout[10] = 0;
        this.buffout[11] = this.calcCrc(this.buffout, 11);
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            this.port.discard();
            this.port.writeBytes(this.buffout, BUFF_SIZE);
            int n = this.port.readBytes(this.buffin, BUFF_SIZE);
            if (n == BUFF_SIZE && this.buffin[11] == this.calcCrc(this.buffin, 11)) {
                int highbits = this.buffin[10];
                int i = 3;
                while (i < 11) {
                    int n2 = i++;
                    this.buffin[n2] = this.buffin[n2] | (highbits & 1) * 128;
                    highbits >>= 1;
                }
                return true;
            }
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
        return false;
    }

    private int calcCrc(int[] data, int size) {
        int crc = 0;
        for (int i = 0; i < size; ++i) {
            int b = data[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                crc = crc << 1 & 0xFF;
                if ((b & 1) > 0) {
                    ++crc;
                }
                if ((crc & 0x80) > 0) {
                    crc ^= 9;
                }
                b = b >> 1 & 0xFF;
            }
        }
        return crc & 0x7F;
    }
}

