/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.core.tags.TagRWBool;
import promauto.jroboplc.core.tags.TagRWDouble;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.core.tags.TagRWLong;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolOmronFins;
import promauto.utils.Numbers;

public class OmronFinsModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(OmronFinsModule.class);
    protected ProtocolOmronFins protocol = new ProtocolOmronFins(this);
    protected TagRW tagAnswerStatus;
    protected int maxDataSize;
    protected List<FinsTag> finstags = new ArrayList<FinsTag>();

    public OmronFinsModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        this.finstags.clear();
        Configuration cm = this.env.getConfiguration();
        this.maxDataSize = Math.min(cm.get(conf, "maxDataSize", 250), 2000);
        try {
            for (Object conf_tag : cm.toList(cm.get(conf, "tags"))) {
                FinsTag ftag = new FinsTag();
                ftag.name = cm.get(conf_tag, "name", "");
                ftag.type = FinsTagType.valueOf(cm.get(conf_tag, "type", "uint16").toUpperCase());
                ftag.cmdread = FinsCommandRead.valueOf(cm.get(conf_tag, "cmdread", "area").toUpperCase());
                ftag.inverted = cm.get(conf_tag, "inverted", false);
                ftag.region = cm.get(conf_tag, "region", 176);
                ftag.access = FinsTagAccess.valueOf(cm.get(conf_tag, "access", "rw").toUpperCase());
                ftag.addressbit = (cm.get(conf_tag, "address", 0) << 4) + (cm.get(conf_tag, "bit", 0) & 0xF);
                ftag.readEnd = cm.get(conf_tag, "readEnd", false);
                ftag.enable = cm.get(conf_tag, "enable", true);
                ftag.tracktagName = cm.get(conf_tag, "tracktag", "");
                ftag.init();
                if (ftag.elementsize == 0) {
                    this.env.printError(this.logger, this.name, ftag.name, "Bad region:", "" + ftag.region);
                    return false;
                }
                if (ftag.cmdread == FinsCommandRead.MULTI && ftag.duplex > 0) {
                    this.env.printError(this.logger, this.name, ftag.name, "Incompatible tagtype and cmdread");
                    return false;
                }
                this.tagtable.add(ftag.tag);
                this.finstags.add(ftag);
            }
        }
        catch (IllegalArgumentException e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
        this.init();
        this.tagAnswerStatus = this.tagtable.createRWInt("AnswerStatus", 0);
        return true;
    }

    private void init() {
        this.finstags.sort((a, b) -> {
            int x = ((a.cmdread == FinsCommandRead.MULTI ? 1 : 0) << 28) + (a.region << 20) + a.addressbit;
            int y = ((b.cmdread == FinsCommandRead.MULTI ? 1 : 0) << 28) + (b.region << 20) + b.addressbit;
            return x - y;
        });
        Map<String, FinsTag> map = this.finstags.stream().collect(Collectors.toMap(c -> c.name, c -> c));
        for (FinsTag ftag : this.finstags) {
            if (ftag.tracktagName.isEmpty()) continue;
            ftag.tracktag = map.get(ftag.tracktagName);
        }
    }

    @Override
    public boolean executePeripherialModule() {
        boolean res = true;
        if (this.tagAnswerStatus.hasWriteValue()) {
            this.protocol.resetLastBadAnswerStatus();
        }
        if (this.emulated) {
            for (FinsTag ftag : this.finstags) {
                ftag.tag.acceptWriteValue();
            }
            return res;
        }
        boolean needWrite = false;
        for (FinsTag ftag : this.finstags) {
            if (ftag.access == FinsTagAccess.RO) continue;
            ftag.needWrite = ftag.enable && (ftag.tag.hasWriteValue() || ftag.tracktag != null && !ftag.tag.equalsValue(ftag.tracktag.tag));
            needWrite |= ftag.needWrite;
        }
        if (needWrite) {
            res &= this.write();
        }
        this.tagAnswerStatus.setReadValInt(this.protocol.getLastBadAnswerStatus());
        return res &= this.read();
    }

    private boolean write() {
        int begidx = 0;
        int lastidx = 0;
        FinsTag begtag = null;
        FinsTag lasttag = null;
        for (int i = 0; i < this.finstags.size(); ++i) {
            FinsTag ftag = this.finstags.get(i);
            if (!ftag.needWrite) continue;
            if (lasttag != null) {
                boolean finish = ftag.region != lasttag.region;
                finish |= ftag.address - lasttag.address + lasttag.duplex != 1;
                int readsize = (ftag.address + ftag.duplex - begtag.address + 1) * ftag.elementsize;
                if (finish |= readsize > this.maxDataSize) {
                    if (!this.writeRequest(begidx, lastidx)) {
                        return false;
                    }
                    lasttag = null;
                } else {
                    begtag = ftag;
                    lasttag = ftag;
                    lastidx = i;
                }
            }
            if (lasttag != null) continue;
            begidx = i;
            lastidx = i;
            begtag = ftag;
            lasttag = ftag;
        }
        return lasttag == null || this.writeRequest(begidx, lastidx);
    }

    private boolean writeRequest(int begidx, int lastidx) {
        boolean result;
        FinsTag begtag = this.finstags.get(begidx);
        FinsTag lasttag = this.finstags.get(lastidx);
        int num = lasttag.address + lasttag.duplex - begtag.address + 1;
        ProtocolOmronFins.SetDataBuffoutFunction setdatafunc = (i, k) -> {
            FinsTag ftag = this.finstags.get(i);
            ftag.putValueIntoBuff(this.protocol.buffout, k);
            if (ftag.access == FinsTagAccess.WO) {
                ftag.tag.copyLastWriteToRead();
            }
            return ftag.datasize;
        };
        try {
            result = this.protocol.request0102(begtag.region, begtag.elementsize, begtag.addressbit, num, begidx, lastidx, setdatafunc);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        if (!result) {
            for (int i2 = begidx; i2 <= lastidx; ++i2) {
                this.finstags.get((int)i2).tag.raiseWriteValue();
            }
        }
        return result;
    }

    private boolean read() {
        int begidx = 0;
        int lastidx = 0;
        FinsTag begtag = null;
        FinsTag lasttag = null;
        for (int i = 0; i < this.finstags.size(); ++i) {
            FinsTag ftag = this.finstags.get(i);
            if (ftag.access == FinsTagAccess.WO) continue;
            if (lasttag != null) {
                boolean finish = lasttag.readEnd;
                finish |= ftag.cmdread != lasttag.cmdread;
                if (ftag.cmdread == FinsCommandRead.AREA) {
                    finish |= ftag.region != lasttag.region;
                    int readsize = (ftag.address + ftag.duplex - begtag.address + 1) * ftag.elementsize;
                    finish |= readsize > this.maxDataSize;
                } else {
                    int writesize = (i - begidx + 1) * 4;
                    finish |= writesize > this.maxDataSize;
                }
                if (finish) {
                    if (!this.readRequest(begidx, lastidx)) {
                        return false;
                    }
                    lasttag = null;
                } else {
                    lastidx = i;
                    lasttag = ftag;
                }
            }
            if (lasttag != null) continue;
            begtag = ftag;
            lasttag = ftag;
            begidx = i;
            lastidx = i;
        }
        return lasttag == null || this.readRequest(begidx, lastidx);
    }

    private boolean readRequest(int begidx, int lastidx) {
        FinsCommandRead cmdread = this.finstags.get((int)begidx).cmdread;
        if (cmdread == FinsCommandRead.AREA) {
            return this.readRequestArea(begidx, lastidx);
        }
        return this.readRequestMulti(begidx, lastidx);
    }

    private boolean readRequestArea(int begidx, int lastidx) {
        boolean result;
        FinsTag begtag = this.finstags.get(begidx);
        FinsTag lasttag = this.finstags.get(lastidx);
        int num = lasttag.address + lasttag.duplex - begtag.address + 1;
        try {
            result = this.protocol.request0101(begtag.region, begtag.elementsize, begtag.addressbit, num);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        if (result && this.protocol.isAnswerStatusOk()) {
            for (int i = begidx; i <= lastidx; ++i) {
                FinsTag ftag = this.finstags.get(i);
                int k = (ftag.address - begtag.address) * ftag.elementsize;
                ftag.fetchValueFromProtocolBuffin(this.protocol, k);
            }
        }
        return result;
    }

    private boolean readRequestMulti(int begidx, int lastidx) {
        boolean result;
        int num = lastidx - begidx + 1;
        int readsize = this.finstags.subList(begidx, lastidx + 1).stream().mapToInt(x -> x.datasize + 1).sum();
        ProtocolOmronFins.SetDataBuffoutFunction setdatafunc = (i, k) -> {
            FinsTag ftag = this.finstags.get(i);
            this.protocol.buffout[k] = ftag.region;
            this.protocol.buffout[k + 1] = ftag.addressbit >> 12 & 0xFF;
            this.protocol.buffout[k + 2] = ftag.addressbit >> 4 & 0xFF;
            this.protocol.buffout[k + 3] = ftag.addressbit & 0xF;
            return 4;
        };
        try {
            result = this.protocol.request0104(num, readsize, begidx, lastidx, setdatafunc);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        if (result && this.protocol.isAnswerStatusOk()) {
            int k2 = 0;
            for (int i2 = begidx; i2 <= lastidx; ++i2) {
                FinsTag ftag = this.finstags.get(i2);
                ftag.fetchValueFromProtocolBuffin(this.protocol, k2);
                k2 += ftag.datasize + 1;
            }
        }
        return result;
    }

    @Override
    protected boolean reload() {
        OmronFinsModule tmp = new OmronFinsModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.maxDataSize = tmp.maxDataSize;
        for (FinsTag mtag : this.finstags) {
            Tag found = tmp.tagtable.get(mtag.tag.getName());
            if (found != null && found.getType() == mtag.tag.getType() && found instanceof TagRW) continue;
            this.tagtable.remove(mtag.tag);
        }
        for (FinsTag mtag : tmp.finstags) {
            TagRW tag = (TagRW)this.tagtable.get(mtag.tag.getName());
            if (tag == null) {
                this.tagtable.add(mtag.tag);
                continue;
            }
            mtag.tag = tag;
        }
        this.finstags = tmp.finstags;
        this.init();
        this.updateTagsStatus();
        return true;
    }

    protected static class FinsTag {
        public String name;
        public FinsTagType type;
        public boolean inverted;
        public int datasize;
        public int elementsize;
        public int region;
        public FinsTagAccess access;
        public FinsCommandRead cmdread;
        public int addressbit;
        public int address;
        public int duplex;
        public boolean readEnd;
        public boolean enable;
        public TagRW tag;
        public boolean needWrite;
        public String tracktagName;
        public FinsTag tracktag;

        protected FinsTag() {
        }

        public void init() {
            this.elementsize = ProtocolOmronFins.getElementSize(this.region);
            if (this.elementsize == 1) {
                this.datasize = 1;
                this.address = this.addressbit;
                this.duplex = 0;
            } else if (this.elementsize == 2) {
                this.datasize = this.type == FinsTagType.FLOAT32 || this.type == FinsTagType.INT32 || this.type == FinsTagType.UINT32 ? 4 : 2;
                this.address = this.addressbit >> 4;
                this.duplex = this.datasize / this.elementsize - 1;
            }
            switch (this.type.ordinal()) {
                case 0: {
                    this.tag = new TagRWBool(this.name, false, 8);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.tag = new TagRWInt(this.name, 0, 8);
                    break;
                }
                case 4: {
                    this.tag = new TagRWLong(this.name, 0L, 8);
                    break;
                }
                case 5: 
                case 6: {
                    this.tag = new TagRWDouble(this.name, 0.0, 8);
                }
            }
        }

        public void putValueIntoBuff(int[] buff, int pos) {
            if (this.elementsize == 1) {
                buff[pos] = this.type == FinsTagType.BOOL ? (this.tag.getWriteValBool() ^ this.inverted ? 1 : 0) : this.tag.getWriteValInt() & 0xFF;
            } else if (this.elementsize == 2) {
                switch (this.type.ordinal()) {
                    case 0: {
                        buff[pos] = 0;
                        buff[pos + 1] = this.tag.getWriteValBool() ^ this.inverted ? 1 : 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        int i = this.tag.getWriteValInt() & 0xFFFF;
                        buff[pos] = i >> 8;
                        buff[pos + 1] = i & 0xFF;
                        break;
                    }
                    case 3: 
                    case 4: {
                        long l = this.tag.getWriteValInt() & 0xFFFFFFFF;
                        buff[pos] = (int)(l >> 24 & 0xFFL);
                        buff[pos + 1] = (int)(l >> 16 & 0xFFL);
                        buff[pos + 2] = (int)(l >> 8 & 0xFFL);
                        buff[pos + 3] = (int)(l & 0xFFL);
                        break;
                    }
                    case 5: {
                        int i = Numbers.encodeFloat16((float)this.tag.getWriteValDouble());
                        buff[pos] = i >> 8;
                        buff[pos + 1] = i & 0xFF;
                        break;
                    }
                    case 6: {
                        long l = (long)Numbers.encodeFloat32((float)this.tag.getWriteValDouble()) & 0xFFFFFFFFL;
                        buff[pos] = (int)(l >> 24 & 0xFFL);
                        buff[pos + 1] = (int)(l >> 16 & 0xFFL);
                        buff[pos + 2] = (int)(l >> 8 & 0xFFL);
                        buff[pos + 3] = (int)(l & 0xFFL);
                        break;
                    }
                }
            }
        }

        public void fetchValueFromProtocolBuffin(ProtocolOmronFins protocol, int pos) {
            if (this.cmdread == FinsCommandRead.MULTI) {
                ++pos;
            }
            if (this.elementsize == 1) {
                if (this.type == FinsTagType.BOOL) {
                    this.tag.setReadValBool(protocol.getDataByte(pos) != 0 ^ this.inverted);
                } else {
                    this.tag.setReadValInt(protocol.getDataByte(pos));
                }
            } else if (this.elementsize == 2) {
                switch (this.type.ordinal()) {
                    case 0: {
                        this.tag.setReadValBool(protocol.getDataWord(pos) != 0 ^ this.inverted);
                        break;
                    }
                    case 1: {
                        this.tag.setReadValInt((short)protocol.getDataWord(pos));
                        break;
                    }
                    case 2: {
                        this.tag.setReadValInt(protocol.getDataWord(pos));
                        break;
                    }
                    case 3: {
                        if (this.cmdread == FinsCommandRead.MULTI) break;
                        this.tag.setReadValInt(protocol.getAnswerInt(pos));
                        break;
                    }
                    case 4: {
                        if (this.cmdread == FinsCommandRead.MULTI) break;
                        this.tag.setReadValLong(protocol.getAnswerInt(pos) & 0xFFFFFFFF);
                        break;
                    }
                    case 5: {
                        this.tag.setReadValDouble(Numbers.decodeFloat16(protocol.getDataWord(pos)));
                        break;
                    }
                    case 6: {
                        if (this.cmdread == FinsCommandRead.MULTI) break;
                        this.tag.setReadValDouble(Numbers.decodeFloat32(protocol.getAnswerInt(pos)));
                    }
                }
            }
        }
    }

    protected static enum FinsTagType {
        BOOL,
        INT16,
        UINT16,
        INT32,
        UINT32,
        FLOAT16,
        FLOAT32;

    }

    protected static enum FinsCommandRead {
        AREA,
        MULTI;

    }

    protected static enum FinsTagAccess {
        RO,
        WO,
        RW;

    }
}

