/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;
import promauto.utils.Numbers;

public class PaGeliosFlowModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaGeliosFlowModule.class);
    public static final int CONSOLE_ADDR_INPUT = 8192;
    public static final int CONSOLE_ADDR_OUTPUT = 8193;
    public static final int CONSOLE_LINE_COUNT = 4;
    public static final int CONSOLE_LINE_SIZE = 10;
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    protected Tag tagCrc;
    protected Tag tagState;
    protected Tag tagCurOutput;
    protected Tag tagWeight;
    protected Tag tagSumWeightHigh;
    protected Tag tagSumWeightLow;
    protected Tag tagSumWeight;
    protected Tag tagCmd;
    protected Tag tagReset;
    protected TagRW tagReqOutput;
    protected Tag tagErrorCode;
    protected TagRW tagConsoleTimer;
    protected TagRW tagConsoleInput;
    protected Tag tagConsoleOutput;
    protected TagRW tagWesSvrState;
    protected Tag[] crcTags;
    private int[] buffCalcCrc;
    private long wesSvrStateTimer;
    private int curOutputAvgSize = 0;
    private int curOutputAvgIdx = 0;
    private int[] curOutputAvgCache;
    private TagRW tagFirmware;

    public PaGeliosFlowModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.curOutputAvgSize = cm.get(conf, "averaging", 0);
        this.curOutputAvgCache = new int[this.curOutputAvgSize];
        this.tagCrc = this.tagtable.createInt("Crc", 0);
        this.tagState = this.tagtable.createInt("State", 0, 8);
        this.tagCurOutput = this.tagtable.createInt("CurOutput", 0, 8);
        this.tagWeight = this.tagtable.createInt("CurWeight", 0, 8);
        this.tagSumWeightHigh = this.tagtable.createInt("SumWeightHigh", 0, 8);
        this.tagSumWeightLow = this.tagtable.createInt("SumWeightLow", 0, 8);
        this.tagSumWeight = this.tagtable.createLong("SumWeight", 0L, 8);
        this.crcTags = new Tag[]{this.tagSumWeightHigh, this.tagSumWeightLow};
        this.buffCalcCrc = new int[this.crcTags.length * 2];
        this.tagCmd = this.tagtable.createInt("Cmd", 0, 8);
        this.tagReset = this.tagtable.createInt("Reset", 0, 8);
        this.tagReqOutput = this.tagtable.createRWInt("ReqOutput", 0, 8);
        this.tagErrorCode = this.tagtable.createInt("ErrorCode", 0, 8);
        this.tagConsoleTimer = this.tagtable.createRWInt("ConsoleTimer", 0);
        this.tagConsoleInput = this.tagtable.createRWString("ConsoleInput", "", 8);
        this.tagConsoleOutput = this.tagtable.createString("ConsoleOutput", "", 8);
        this.tagWesSvrState = this.tagtable.createRWInt("WesSvrState", 0);
        this.tagFirmware = this.tagtable.createRWString("firmware", "");
        return true;
    }

    @Override
    public boolean preparePeripherialModule() {
        this.curOutputAvgIdx = 0;
        for (int i = 0; i < this.curOutputAvgSize; ++i) {
            this.curOutputAvgCache[i] = -1;
        }
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        boolean result;
        block17: {
            result = true;
            if (!this.emulated) {
                try {
                    if (this.tagReqOutput.hasWriteValue()) {
                        int value = this.tagReqOutput.getWriteValInt();
                        boolean bl = result = this.protocol.requestCmd6(7, value >> 16 & 0xFFFF) && this.protocol.requestCmd6(8, value & 0xFFFF);
                        if (!result) {
                            this.tagReqOutput.setInt(value);
                        }
                    }
                    if (result && this.tagState.getInt() < 2 && this.tagState.getInt() != this.tagCmd.getInt()) {
                        result = this.protocol.requestCmd6(0, this.tagCmd.getInt());
                    }
                    if (result && this.tagReset.getInt() > 0) {
                        int reset2 = 0;
                        if (this.tagState.getInt() == 2 && !(result = this.protocol.requestCmd6(0, this.tagCmd.getInt()))) {
                            reset2 = 1;
                        }
                        this.tagReset.setInt(reset2);
                    }
                    if (result &= this.protocol.requestCmd3(0, 17)) {
                        this.tagState.setInt(Numbers.bytesToWord(this.protocol.buffin, 3));
                        this.tagCurOutput.setInt(this.calcCurOutputAverage(Numbers.bytesToInt(this.protocol.buffin, 5)));
                        this.tagWeight.setInt(Numbers.bytesToInt(this.protocol.buffin, 9));
                        this.tagSumWeightHigh.setInt(Numbers.bytesToWord(this.protocol.buffin, 13));
                        this.tagSumWeightLow.setInt(Numbers.bytesToWord(this.protocol.buffin, 15));
                        this.tagSumWeight.setLong(this.tagSumWeightHigh.getLong() * 65536L + this.tagSumWeightLow.getLong());
                        this.tagReqOutput.setReadValInt(Numbers.bytesToInt(this.protocol.buffin, 17));
                        this.tagErrorCode.setInt(Numbers.bytesToWord(this.protocol.buffin, 21));
                    }
                    this.tagConsoleTimer.acceptWriteValue();
                    if (this.tagConsoleTimer.getInt() > 0) {
                        String consoleOutput;
                        this.tagConsoleTimer.setReadValInt(this.tagConsoleTimer.getInt() - 1);
                        if (this.tagConsoleInput.hasWriteValue()) {
                            String consoleInput = this.tagConsoleInput.getWriteValString();
                            if (consoleInput.isEmpty()) {
                                this.tagConsoleInput.setReadValString("");
                            } else {
                                Byte b;
                                byte[] byArray = consoleInput.getBytes();
                                int n = byArray.length;
                                for (int i = 0; i < n && (result = this.protocol.requestCmd6(8192, Numbers.asciiDigitToInt((b = Byte.valueOf(byArray[i])).byteValue()))); ++i) {
                                }
                                this.tagConsoleInput.setReadValString((result ? "" : "!") + consoleInput);
                            }
                        }
                        StringBuilder sb = new StringBuilder();
                        int addr = 8193;
                        for (int i = 0; i < 4 && (result &= this.protocol.requestCmd3(addr, 11)); ++i) {
                            sb.append(this.protocol.getAnswerGeliosString(0, 10));
                            if (i == 3 || this.protocol.getAnswerWord(10) == 0) break;
                            sb.append('|');
                            addr += 10;
                        }
                        String string = consoleOutput = result ? sb.toString() : "CONNECTION ERROR";
                        if (!this.tagConsoleOutput.getString().equals(consoleOutput)) {
                            this.tagConsoleOutput.setString(consoleOutput);
                        }
                        break block17;
                    }
                    this.tagConsoleOutput.setString("");
                }
                catch (Exception e) {
                    this.env.printError(this.logger, e, this.name);
                    result = false;
                }
            } else {
                this.tagReqOutput.acceptWriteValue();
            }
        }
        this.calcTagCrc8(this.crcTags, this.tagCrc, this.buffCalcCrc);
        this.wesSvrStateTimer = PaGeliosFlowModule.updateWesSvrState(this.tagWesSvrState, this.wesSvrStateTimer);
        return result;
    }

    private int calcCurOutputAverage(int value) {
        if (this.curOutputAvgSize == 0) {
            return value;
        }
        if (value == 0) {
            if (this.curOutputAvgCache[0] != -1) {
                this.curOutputAvgIdx = 0;
                for (int i = 0; i < this.curOutputAvgSize; ++i) {
                    this.curOutputAvgCache[i] = -1;
                }
            }
            return value;
        }
        int n = 0;
        int sum = 0;
        if (this.curOutputAvgIdx >= this.curOutputAvgSize) {
            this.curOutputAvgIdx = 0;
        }
        this.curOutputAvgCache[this.curOutputAvgIdx] = value;
        ++this.curOutputAvgIdx;
        for (int i = 0; i < this.curOutputAvgSize; ++i) {
            if (this.curOutputAvgCache[i] < 0) continue;
            sum += this.curOutputAvgCache[i];
            ++n;
        }
        return n > 0 ? sum / n : 0;
    }

    @Override
    protected boolean reload() {
        PaGeliosFlowModule tmp = new PaGeliosFlowModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        if (this.curOutputAvgSize != tmp.curOutputAvgSize) {
            this.curOutputAvgSize = tmp.curOutputAvgSize;
            this.curOutputAvgCache = tmp.curOutputAvgCache;
            this.prepare();
        }
        return true;
    }
}

