/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.io.BufferedReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagInt;
import promauto.jroboplc.core.tags.TagRW;
import promauto.jroboplc.core.tags.TagRWInt;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.utils.CRC;
import promauto.utils.Numbers;

public class PaRoboModule
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaRoboModule.class);
    private static final int PACK_SIZE = 400;
    protected ExtTag[] exttags;
    protected Tag tagTimeWrite;
    protected Tag tagTimeReadIrr;
    protected Tag tagTimeReadAll;
    protected Tag tagTimeReadPer;
    protected Tag tagTimeReadReq;
    protected Tag tagTimeReadTCycle;
    protected Tag tagTimeCycle;
    protected Tag tagErrorCode;
    protected int sizeTotal;
    protected int sizePer;
    protected int sizeReq;
    protected int sizeIrr;
    protected String progid;
    protected int indexIrrBegin;
    protected int packAmountTotal;
    protected int packAmountPer;
    private long t1;
    private long t2;
    private int readIndex;
    private boolean needToReadAll;
    private int[] buffin = new int[2048];
    private int[] buffout = new int[14];
    private int sizein;

    public PaRoboModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        boolean useDescr;
        this.tagTimeWrite = this.tagtable.createInt(this.systagpref + "TimeWrite", 0);
        this.tagTimeReadIrr = this.tagtable.createInt(this.systagpref + "TimeReadIrr", 0);
        this.tagTimeReadAll = this.tagtable.createInt(this.systagpref + "TimeReadAll", 0);
        this.tagTimeReadPer = this.tagtable.createInt(this.systagpref + "TimeReadPer", 0);
        this.tagTimeReadReq = this.tagtable.createInt(this.systagpref + "TimeReadReq", 0);
        this.tagTimeReadTCycle = this.tagtable.createInt(this.systagpref + "TimeReadTCycle", 0);
        this.tagTimeCycle = this.tagtable.createInt(this.systagpref + "TimeCycle", 0);
        this.tagErrorCode = this.tagtable.createInt(this.systagpref + "ErrorCode", 0);
        Configuration cm = this.env.getConfiguration();
        Path pathMtr = cm.getPath(conf, "mtr", "");
        String s = cm.get(conf, "mtr", "");
        String rpp = s.substring(0, s.length() - 3) + "rpp";
        Path pathRpp = cm.getPath(conf, "rpp", rpp);
        boolean hiddenDescr = false;
        s = cm.get(conf, "use.descr", "");
        if (s.equals("hidden")) {
            hiddenDescr = true;
            useDescr = true;
        } else {
            useDescr = Boolean.parseBoolean(s);
        }
        String charsetname = cm.get(conf, "encoding", "windows-1251");
        this.indexIrrBegin = 0;
        this.sizeIrr = 0;
        this.sizeReq = 0;
        this.sizePer = 0;
        this.sizeTotal = 0;
        boolean res = this.loadMtr(pathMtr, charsetname);
        if (useDescr) {
            res &= this.loadDescr(pathRpp, hiddenDescr);
        }
        this.packAmountTotal = (this.sizeTotal - 1) / 400 + 1;
        this.packAmountPer = (this.sizePer - 1) / 400 + 1;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean loadDescr(Path pathRpp, boolean hidden) {
        boolean res;
        block19: {
            if (!Files.exists(pathRpp, new LinkOption[0])) {
                return true;
            }
            XMLInputFactory xmlif = this.env.getXMLInputFactory();
            XMLStreamReader xmlr = null;
            HashSet<String> devTypesWithDescr = new HashSet<String>(Arrays.asList("MCHB", "MDTA", "ZDVA", "ZDVB", "ZDVH", "ZDVS", "ZDVT", "SEQD"));
            int flags = hidden ? 2 : 0;
            res = false;
            try (InputStream prjstream = Files.newInputStream(pathRpp, new OpenOption[0]);){
                xmlr = xmlif.createXMLStreamReader(prjstream);
                while (xmlr.hasNext()) {
                    if (xmlr.next() != 1 || !xmlr.getName().getLocalPart().equals("dev")) continue;
                    String devtype = xmlr.getAttributeValue("", "DevType");
                    String tagname = xmlr.getAttributeValue("", "TagName");
                    String name = xmlr.getAttributeValue("", "Name");
                    if (!devTypesWithDescr.contains(devtype)) continue;
                    this.tagtable.createRWString(String.format("%s_%s.descr", devtype, tagname), name, flags);
                }
                res = true;
            }
            try {
                xmlr.close();
            }
            catch (XMLStreamException e) {
                this.env.printError(this.logger, e, this.name);
            }
            break block19;
            catch (Exception e) {
                try {
                    this.env.printError(this.logger, e, new String[]{this.name, pathRpp.toString(), xmlr == null ? "" : "line: " + xmlr.getLocation().getLineNumber()});
                }
                catch (Throwable throwable) {
                    try {
                        xmlr.close();
                    }
                    catch (XMLStreamException e2) {
                        this.env.printError(this.logger, e2, this.name);
                    }
                    throw throwable;
                }
                try {
                    xmlr.close();
                }
                catch (XMLStreamException e3) {
                    this.env.printError(this.logger, e3, this.name);
                }
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadMtr(Path pathMtr, String charsetname) {
        try (BufferedReader reader = Files.newBufferedReader(pathMtr, Charset.forName(charsetname));){
            String line;
            this.exttags = null;
            int exttagcnt = 0;
            Pattern p1 = Pattern.compile("%(\\w+)=(\\w+)");
            Pattern p2 = Pattern.compile("@(\\w+):(\\w+)\\.(\\w+) (..) - - 00\\.(.+)$");
            block23: while ((line = reader.readLine()) != null) {
                Matcher m;
                if (this.exttags == null && line.startsWith("%") && (m = p1.matcher(line)).find()) {
                    switch (m.group(1)) {
                        case "EXTERNAL": {
                            this.sizeTotal = Integer.parseInt(m.group(2), 16);
                            break;
                        }
                        case "EXTMAIN": {
                            this.sizePer = Integer.parseInt(m.group(2), 16);
                            break;
                        }
                        case "EXTREQ": {
                            this.sizeReq = Integer.parseInt(m.group(2), 16);
                            break;
                        }
                        case "EXTIRR": {
                            this.sizeIrr = Integer.parseInt(m.group(2), 16);
                            break;
                        }
                        case "PROGID": {
                            this.progid = m.group(2);
                            continue block23;
                        }
                    }
                    continue;
                }
                if (!line.startsWith("@") || !(m = p2.matcher(line)).find()) continue;
                if (this.exttags == null) {
                    this.exttags = new ExtTag[this.sizeTotal];
                    this.indexIrrBegin = this.sizePer + this.sizeReq;
                }
                ExtTag exttag = new ExtTag();
                int index = Integer.parseInt(m.group(1), 16);
                exttag.addr = Integer.parseInt(m.group(2), 16);
                exttag.num = Integer.parseInt(m.group(3), 16);
                exttag.readonly = m.group(4).equals("RO");
                exttag.tag = this.tagtable.createRWInt(m.group(5), 0, 8);
                if (index < this.sizePer) {
                    exttag.exttype = ExtType.Periodic;
                } else if (index < this.indexIrrBegin) {
                    exttag.exttype = ExtType.Requested;
                } else {
                    exttag.exttype = ExtType.Irregular;
                    exttag.tag.setObject(new TagInt("IRR", 0));
                }
                if (index < 0 || index >= this.sizeTotal) {
                    this.env.printError(this.logger, this.name, "Tag index out of bounds:", line);
                    boolean bl = false;
                    return bl;
                }
                if (this.exttags[index] != null) {
                    this.env.printError(this.logger, this.name, "Tag index duplicate:", line);
                    boolean bl = false;
                    return bl;
                }
                this.exttags[index] = exttag;
                ++exttagcnt;
            }
            if (exttagcnt == this.sizeTotal) return true;
            this.env.printError(this.logger, this.name, "Bad tag amount:", exttagcnt + " != " + this.sizeTotal);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            return false;
        }
    }

    @Override
    public boolean preparePeripherialModule() {
        this.needToReadAll = true;
        return true;
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            this.executeEmulate();
            return true;
        }
        int res = 0;
        try {
            this.t1 = System.currentTimeMillis();
            res |= this.writeTags() ? 0 : 1;
            this.fixTime(this.tagTimeWrite);
            res |= this.readIrregulars() ? 0 : 2;
            this.fixTime(this.tagTimeReadIrr);
            if (this.needToReadAll) {
                res |= this.readAll() ? 0 : 4;
                this.fixTime(this.tagTimeReadAll);
                if (this.readIndex != this.sizeTotal) {
                    res |= 8;
                }
            } else {
                res |= this.readPeriodic() ? 0 : 16;
                this.fixTime(this.tagTimeReadPer);
                res |= this.readRequested() ? 0 : 32;
                this.fixTime(this.tagTimeReadReq);
            }
            res |= this.readTimeCycle() ? 0 : 64;
            this.fixTime(this.tagTimeReadTCycle);
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            res |= 0x80;
        }
        if (res > 0) {
            this.tagErrorCnt.setInt(this.tagErrorCnt.getInt() + 1);
            if (this.canLogError()) {
                this.logError("executePeripherialModule, Err1: " + res);
            }
        }
        this.tagErrorCode.setInt(res);
        return res == 0;
    }

    private void fixTime(Tag tagTime) {
        this.t2 = System.currentTimeMillis();
        tagTime.setInt((int)(this.t2 - this.t1));
        this.t1 = this.t2;
    }

    private boolean writeTags() throws Exception {
        for (ExtTag exttag : this.exttags) {
            Tag tag;
            if (exttag.readonly || !exttag.tag.hasWriteValue()) continue;
            this.buffout[0] = 64;
            Numbers.intToHexWord(exttag.addr, this.buffout, 1);
            Numbers.intToHexByte(exttag.num, this.buffout, 5);
            Numbers.intToHexWord(exttag.tag.getWriteValInt(), this.buffout, 7);
            Numbers.intToHexByte(CRC.getCrc8(this.buffout, 0, 10), this.buffout, 11);
            this.buffout[13] = 13;
            if (!this.request(14, () -> {
                if (this.sizein != 15 || this.buffin[0] != 33) {
                    return false;
                }
                for (int i = 0; i < 13; ++i) {
                    if (this.buffin[i + 1] == this.buffout[i]) continue;
                    return false;
                }
                return true;
            })) {
                exttag.tag.raiseWriteValue();
                return false;
            }
            if (exttag.exttype != ExtType.Irregular || (tag = (Tag)exttag.tag.getObject()) == null) continue;
            tag.setInt(1);
        }
        return true;
    }

    private boolean readIrregulars() throws Exception {
        for (int i = this.indexIrrBegin; i < this.sizeTotal; ++i) {
            if (this.exttags[i].tag.getObject() == null || ((Tag)this.exttags[i].tag.getObject()).getInt() == 0) continue;
            ExtTag exttag = this.exttags[i];
            this.buffout[0] = 36;
            Numbers.intToHexWord(exttag.addr, this.buffout, 1);
            Numbers.intToHexByte(exttag.num, this.buffout, 5);
            Numbers.intToHexByte(CRC.getCrc8(this.buffout, 0, 6), this.buffout, 7);
            this.buffout[9] = 13;
            if (!this.request(10, () -> this.buffin[0] == 33 && this.checkCrc8('='))) {
                return false;
            }
            int k = this.getPos(61, 1, this.sizein);
            if (k == -1) {
                return false;
            }
            int value = Numbers.hexToInt(this.buffin, 1, k - 1);
            exttag.tag.setReadValInt(value);
            ((Tag)this.exttags[i].tag.getObject()).setInt(0);
        }
        return true;
    }

    private boolean readAll() throws Exception {
        if (!this.readContiguous('%', this.packAmountTotal)) {
            return false;
        }
        Thread.sleep(100L);
        this.buffout[0] = 59;
        this.buffout[1] = 82;
        this.buffout[2] = 81;
        this.buffout[3] = 69;
        this.buffout[4] = 78;
        this.buffout[5] = 13;
        if (!this.port.writeBytes(this.buffout, 6)) {
            return false;
        }
        Thread.sleep(100L);
        this.needToReadAll = false;
        return true;
    }

    private boolean readPeriodic() throws Exception {
        return this.readContiguous('+', this.packAmountPer);
    }

    private boolean readContiguous(char cmd, int packAmount) throws Exception {
        int packnum = 0;
        while (packnum < packAmount) {
            int packnum_fin;
            this.buffout[0] = cmd;
            int i = Numbers.intToHex(packnum, this.buffout, 1);
            this.buffout[i++] = 13;
            if (!this.request(i, () -> this.lambda$readContiguous$2(packnum_fin = packnum++))) {
                if (this.canLogError()) {
                    this.logError("readContiguous, Err2");
                }
                return false;
            }
            Thread.sleep(10L);
        }
        return true;
    }

    private boolean parseContiguousValues(int packnum) {
        int k = this.getPos(62, 0, this.sizein);
        if (k == -1) {
            if (this.canLogError()) {
                this.logError("parseContiguousValues, Err3");
            }
            return false;
        }
        int packnumTheirs = Numbers.hexToInt(this.buffin, 0, k);
        if (packnum != packnumTheirs) {
            if (this.canLogError()) {
                this.logError("parseContiguousValues, Err4: parseContiguousValues: " + packnum + "!=" + packnumTheirs);
            }
            return false;
        }
        this.readIndex = packnum * 400;
        int value = 0;
        while (true) {
            int b;
            if ((b = this.buffin[++k]) == 59) {
                if (this.readIndex >= this.sizeTotal) {
                    ++this.readIndex;
                    break;
                }
                this.exttags[this.readIndex++].tag.setReadValInt(value);
                value = 0;
                continue;
            }
            if (b == 124) break;
            value = (value << 4) + Numbers.asciiDigitToInt(b);
        }
        return true;
    }

    private boolean readRequested() throws Exception {
        this.buffout[0] = 58;
        this.buffout[1] = 13;
        if (!this.request(2, () -> this.buffin[0] == 58 || this.checkCrc16('|', this.sizein - 2))) {
            if (this.canLogError()) {
                this.logError("readRequested, Err5");
            }
            return false;
        }
        if (this.buffin[0] == 58) {
            if (this.buffin[1] == 78) {
                return true;
            }
            this.needToReadAll = true;
            return this.readAll();
        }
        int k = -1;
        this.readIndex = -1;
        int value = 0;
        while (true) {
            int b;
            if ((b = this.buffin[++k]) == 58) {
                this.readIndex = value + this.sizePer;
                value = 0;
                continue;
            }
            if (b == 59) {
                if (this.readIndex < 0 || this.readIndex >= this.sizeTotal) {
                    if (this.canLogError()) {
                        this.logError("readRequested, Err6: index=" + this.readIndex + ", sizeTotal=" + this.sizeTotal);
                    }
                    return false;
                }
                this.exttags[this.readIndex].tag.setReadValInt(value);
                this.readIndex = -1;
                value = 0;
                continue;
            }
            if (b == 124) break;
            value = (value << 4) + Numbers.asciiDigitToInt(b);
        }
        this.buffout[0] = 59;
        this.buffout[1] = 79;
        this.buffout[2] = 75;
        this.buffout[3] = 13;
        if (!this.request(4, () -> this.sizein == 1)) {
            if (this.canLogError()) {
                this.logError("readRequested, Err7");
            }
            return false;
        }
        Thread.sleep(50L);
        return true;
    }

    private boolean readTimeCycle() throws Exception {
        this.buffout[0] = 42;
        this.buffout[1] = 13;
        if (!this.request(2, () -> this.buffin[0] == 33)) {
            if (this.canLogError()) {
                this.logError("readTimeCycle, Err8");
            }
            return false;
        }
        int value = Numbers.hexToInt(this.buffin, 1, this.sizein - 2);
        this.tagTimeCycle.setInt(value);
        return true;
    }

    private boolean request(int sizeout, BooleanSupplier fnCheck) throws Exception {
        for (int trynum = 0; trynum < this.retrial; ++trynum) {
            int i;
            if (!this.port.writeBytes(this.buffout, sizeout)) {
                if (this.canLogError()) {
                    this.logError("request, Err9");
                }
                return false;
            }
            this.sizein = this.port.readBytesDelim(this.buffin, 13);
            if (this.sizein > 0 && fnCheck.getAsBoolean()) {
                return true;
            }
            Thread.sleep(50L);
            if (!this.canLogError()) continue;
            Object s = "\r\nout:";
            if (sizeout > 0) {
                for (i = 0; i < sizeout; ++i) {
                    s = (String)s + (char)this.buffout[i];
                }
            }
            s = (String)s + "\r\ninp:";
            for (i = 0; i < Math.abs(this.sizein); ++i) {
                s = (String)s + (char)this.buffin[i];
            }
            this.logError("request, Err10: try=" + trynum + (String)s);
        }
        return false;
    }

    private boolean checkCrc8(char delim) {
        int crcOurs;
        int last = this.sizein - 2;
        int k = this.getPosReverse(delim, last);
        if (k == -1) {
            return false;
        }
        int crcTheirs = Numbers.hexToInt(this.buffin, k + 1, last - k);
        return crcTheirs == (crcOurs = CRC.getCrc8(this.buffin, 0, k));
    }

    private boolean checkCrc16(char delim, int last) {
        int crcOurs;
        int k = this.getPosReverse(delim, last);
        if (k == -1) {
            return false;
        }
        int crcTheirs = Numbers.hexToInt(this.buffin, k + 1, last - k);
        return crcTheirs == (crcOurs = CRC.getCrc16(this.buffin, k));
    }

    private int getPos(int ch, int pos, int size) {
        while (pos < size) {
            if (this.buffin[pos] == ch) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private int getPosReverse(int ch, int pos) {
        while (pos >= 0) {
            if (this.buffin[pos] == ch) {
                return pos;
            }
            --pos;
        }
        return -1;
    }

    private void executeEmulate() {
        for (ExtTag exttag : this.exttags) {
            exttag.tag.acceptWriteValue();
        }
    }

    @Override
    public String getInfo() {
        return super.getInfo() + (String)(this.enable ? " progid:" + this.progid : "");
    }

    @Override
    protected boolean reload() {
        PaRoboModule tmp = new PaRoboModule(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        this.tagTimeWrite.setInt(tmp.tagTimeWrite.getInt());
        this.tagTimeReadIrr.setInt(tmp.tagTimeReadIrr.getInt());
        this.tagTimeReadAll.setInt(tmp.tagTimeReadAll.getInt());
        this.tagTimeReadPer.setInt(tmp.tagTimeReadPer.getInt());
        this.tagTimeReadReq.setInt(tmp.tagTimeReadReq.getInt());
        this.tagTimeReadTCycle.setInt(tmp.tagTimeReadTCycle.getInt());
        this.tagTimeCycle.setInt(tmp.tagTimeCycle.getInt());
        this.tagErrorCode.setInt(tmp.tagErrorCode.getInt());
        for (ExtTag exttag : this.exttags) {
            if (tmp.tagtable.get(exttag.tag.getName()) != null) continue;
            this.tagtable.remove(exttag.tag);
        }
        for (ExtTag exttag : tmp.exttags) {
            Tag tag = this.tagtable.get(exttag.tag.getName());
            if (tag == null || !(tag instanceof TagRWInt)) {
                this.tagtable.add(exttag.tag);
                continue;
            }
            Tag auxtag = (Tag)exttag.tag.getObject();
            if (auxtag == null != (tag.getObject() == null)) {
                tag.setObject(auxtag);
            }
            exttag.tag = (TagRWInt)tag;
        }
        this.exttags = tmp.exttags;
        this.sizeTotal = tmp.sizeTotal;
        this.sizePer = tmp.sizePer;
        this.sizeReq = tmp.sizeReq;
        this.sizeIrr = tmp.sizeIrr;
        this.progid = tmp.progid;
        this.indexIrrBegin = tmp.indexIrrBegin;
        this.packAmountTotal = tmp.packAmountTotal;
        this.packAmountPer = tmp.packAmountPer;
        this.needToReadAll = true;
        this.updateTagsStatus();
        return true;
    }

    private /* synthetic */ boolean lambda$readContiguous$2(int packnum_fin) {
        return this.checkCrc16('|', this.sizein - 2) && this.parseContiguousValues(packnum_fin);
    }

    public static class ExtTag {
        public TagRW tag;
        public int index;
        public int addr;
        public int num;
        public ExtType exttype;
        public boolean readonly;
    }

    static enum ExtType {
        Periodic,
        Requested,
        Irregular;

    }
}

