/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.peripherial;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.peripherial.PeripherialModule;
import promauto.jroboplc.plugin.peripherial.ProtocolModbus;
import promauto.utils.Numbers;

public class PaTermo5Module
extends PeripherialModule {
    private final Logger logger = LoggerFactory.getLogger(PaTermo5Module.class);
    protected ProtocolModbus protocol = new ProtocolModbus(this);
    public static final int PDV_COUNT = 12;
    public static final int SENSOR_COUNT = 6;
    public Pdv[] pdvs = new Pdv[12];
    protected Tag tagAnswer;
    private static final float Rmin = 41.2f;
    private static final float Rmax = 80.6f;
    private static final float Rdel = 475.0f;
    private static final float Dmin = 0.079814024f;
    private static final float Dmax = 0.14506839f;
    private static final float Dsub = 0.06525437f;
    private static final float[] Rld = new float[]{0.21f, 0.46f, 0.71f, 0.96f, 1.21f, 1.46f};
    private static final float A = 0.0043f;

    public PaTermo5Module(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    public boolean loadPeripherialModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        Object pdvconf = cm.get(conf, "params");
        Pattern p = Pattern.compile("^\\s*([c,p])\\s+(\\d+\\.*\\d*)\\s+(\\d+\\.*\\d*)\\s*$");
        for (int i = 0; i < 12; ++i) {
            this.pdvs[i] = new Pdv();
            Object s = "Pdv" + i + ".";
            for (int j = 0; j < 6; ++j) {
                this.pdvs[i].sensors[j] = new Sensor();
                this.pdvs[i].sensors[j].T = this.tagtable.createInt((String)s + "T" + j, 0, 8);
                this.pdvs[i].sensors[j].U = this.tagtable.createInt((String)s + "U" + j, 0, 8);
                this.pdvs[i].sensors[j].R = this.tagtable.createInt((String)s + "R" + j, 0, 8);
            }
            this.pdvs[i].Umin = this.tagtable.createInt((String)s + "Umin", 0, 8);
            this.pdvs[i].Umax = this.tagtable.createInt((String)s + "Umax", 0, 8);
            this.pdvs[i].Time = this.tagtable.createInt((String)s + "Time", 0, 8);
            this.pdvs[i].Tmax = this.tagtable.createInt((String)s + "TMax", 0, 8);
            s = cm.get(pdvconf, "p" + i, "c 53 0");
            Matcher m = p.matcher((CharSequence)s);
            if (!m.find()) {
                this.env.printError(this.logger, new String[]{this.name, "pdv" + i + ":", s});
                return false;
            }
            this.pdvs[i].pdvType = m.group(1).equals("c") ? PdvType.Classic : PdvType.Compensate;
            this.pdvs[i].Rzero = Float.parseFloat(m.group(2));
            this.pdvs[i].Rwire = Float.parseFloat(m.group(3));
        }
        return true;
    }

    @Override
    protected void initChannelMap(List<String> chtags) {
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.addChannelMapTag(chtags, this.pdvs[i].sensors[j].T, i + "." + j);
            }
        }
    }

    @Override
    public boolean executePeripherialModule() {
        if (this.emulated) {
            return true;
        }
        boolean result = true;
        try {
            result = this.protocol.requestCmd3(4192, 12);
            if (result) {
                int ofs = 1;
                for (Pdv pdv : this.pdvs) {
                    pdv.Time.setInt(Numbers.bytesToWord(this.protocol.buffin, ofs += 2));
                }
            }
            if (result) {
                int reqofs = 4096;
                int reqsize = 16;
                int answerOfs1 = 3;
                int answerOfs2 = answerOfs1 + reqsize;
                int idxPdv = 0;
                for (int i = 0; i < 6 && (result = this.protocol.requestCmd3(reqofs, reqsize)); ++i) {
                    this.fetchPdvData(idxPdv++, answerOfs1);
                    this.fetchPdvData(idxPdv++, answerOfs2);
                    reqofs += reqsize;
                }
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            result = false;
        }
        return result;
    }

    private void fetchPdvData(int idxPdv, int ofs) {
        Pdv pdv = this.pdvs[idxPdv];
        ofs -= 2;
        for (Sensor sensor : pdv.sensors) {
            sensor.U.setInt(Numbers.bytesToWord(this.protocol.buffin, ofs += 2));
        }
        int Umin = Numbers.bytesToWord(this.protocol.buffin, ofs += 2);
        int Umax = Numbers.bytesToWord(this.protocol.buffin, ofs += 2);
        pdv.Umin.setInt(Umin);
        pdv.Umax.setInt(Umax);
        int i = 0;
        float Tmax = Float.MIN_VALUE;
        for (Sensor sensor : pdv.sensors) {
            float r = this.calcR(sensor.U.getInt(), Umin, Umax);
            sensor.R.setInt((int)Math.round((double)r * 10.0));
            float t = this.calcT(r, pdv, i++);
            sensor.T.setInt((int)Math.round((double)t * 10.0));
            if (!(t > Tmax)) continue;
            Tmax = t;
        }
        pdv.Tmax.setDouble((double)Tmax * 10.0);
    }

    private float calcR(float Ur, float Umin, float Umax) {
        float v = (Umax - Umin) / 0.06525437f;
        float dv = Umax - 0.14506839f * v;
        return 475.0f * (Ur - dv) / (v - Ur + dv);
    }

    private float calcT(float Rall, Pdv pdv, int sensorIdx) {
        float r = pdv.pdvType == PdvType.Classic ? Rall - Rld[sensorIdx] - pdv.Rwire : Rall - pdv.Rwire;
        float t = (r / pdv.Rzero - 1.0f) / 0.0043f;
        return t;
    }

    @Override
    protected boolean reload() {
        PaTermo5Module tmp = new PaTermo5Module(this.plugin, this.name);
        if (!tmp.load()) {
            return false;
        }
        this.copySettingsFrom(tmp);
        for (int i = 0; i < 12; ++i) {
            this.pdvs[i].Rzero = tmp.pdvs[i].Rzero;
            this.pdvs[i].Rwire = tmp.pdvs[i].Rwire;
            this.pdvs[i].pdvType = tmp.pdvs[i].pdvType;
        }
        return true;
    }

    public static class Pdv {
        public Sensor[] sensors = new Sensor[6];
        public Tag Umin;
        public Tag Umax;
        public Tag Time;
        public Tag Tmax;
        public float Rzero;
        public float Rwire;
        public PdvType pdvType;
    }

    public static class Sensor {
        public Tag T;
        public Tag U;
        public Tag R;
    }

    public static enum PdvType {
        Classic,
        Compensate;

    }
}

