/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.redisexp;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import promauto.jroboplc.core.AbstractModule;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.core.api.Signal;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.redisexp.ExportTag;
import promauto.jroboplc.plugin.redisexp.TagInfo;
import promauto.jroboplc.plugin.redisexp.TagInfoCodec;

public class RedisExpModule
extends AbstractModule
implements Signal.Listener,
RedisPubSubListener<String, String> {
    private static final int MESSAGE_QUEUE_SIZE_MAX = 1000000;
    public static final int SCAN_LIMIT = 100000;
    private final Map<String, ExportTag> etags = new HashMap<String, ExportTag>();
    private String descr;
    private String host;
    private int port;
    private int dbnum;
    private String domain;
    private boolean ssl;
    private int timeoutConn;
    private int timeoutCmd;
    private String filter;
    private boolean readonly;
    private boolean noScanDelete;
    private volatile boolean needCollect;
    private volatile boolean needResetAll;
    private volatile int cntUpdatingLast;
    private volatile int cntUpdatingWait;
    private Tag tagConnected;
    private Tag tagDisconnectCnt;
    private Tag tagLastError;
    private RedisURI uri;
    private RedisClient redisClient;
    private StatefulRedisConnection<String, String> connectionCmd;
    private StatefulRedisPubSubConnection<String, String> connectionPubSub;
    private RedisAsyncCommands<String, String> asyncCmd;
    private RedisPubSubAsyncCommands<String, String> asyncPubSub;
    private final Queue<String> queueWrites = new ConcurrentLinkedQueue<String>();
    private final AtomicInteger cntWrites = new AtomicInteger(0);
    private final Queue<String> queueResets = new ConcurrentLinkedQueue<String>();
    private final AtomicInteger cntResets = new AtomicInteger(0);
    private String serverTimeKey;
    private String tagsKey;
    private String channelUpdate;
    private String channelDelete;
    private String channelWrite;
    private String channelReset;
    private boolean firstPass;
    private boolean opened;
    private int cntWait;
    private int cntLast;

    public RedisExpModule(Plugin plugin, String name) {
        super(plugin, name);
    }

    @Override
    protected boolean loadModule(Object conf) {
        Configuration cm = this.env.getConfiguration();
        this.descr = cm.get(conf, "descr", "jrobo-" + this.name);
        this.host = cm.get(conf, "host", "localhost");
        this.port = cm.get(conf, "port", 6379);
        this.dbnum = cm.get(conf, "dbnum", 0);
        this.domain = cm.get(conf, "domain", "").trim();
        this.ssl = cm.get(conf, "ssl", false);
        this.timeoutConn = cm.get(conf, "timeoutConn_s", 10);
        this.timeoutCmd = cm.get(conf, "timeoutCmd_s", 60);
        String username = cm.get(conf, "username", "");
        String password = cm.get(conf, "password", "");
        this.buildUri(username, password);
        this.filter = cm.get(conf, "filter", "");
        this.readonly = cm.get(conf, "readonly", false);
        this.noScanDelete = cm.get(conf, "noScanDelete", false);
        this.tagConnected = this.tagtable.getOrCreateBool("client.connected", false);
        this.tagDisconnectCnt = this.tagtable.getOrCreateInt("client.disconnect.cnt", 0);
        this.tagLastError = this.tagtable.getOrCreateString("client.last.error", "");
        if (!this.domain.isEmpty()) {
            this.domain = this.domain + ".";
        }
        this.serverTimeKey = this.domain + "server.time";
        this.tagsKey = this.domain + "tags";
        this.channelUpdate = this.domain + "update";
        this.channelDelete = this.domain + "delete";
        this.channelWrite = this.domain + "write";
        this.channelReset = this.domain + "reset";
        return true;
    }

    private void buildUri(String username, CharSequence password) {
        RedisURI.Builder uriBuilder = RedisURI.builder().withHost(this.host).withSsl(this.ssl).withPort(this.port).withDatabase(this.dbnum);
        if (!this.descr.isEmpty()) {
            uriBuilder = uriBuilder.withClientName(this.descr);
        }
        if (!username.isEmpty()) {
            uriBuilder = uriBuilder.withAuthentication(username, password);
        } else if (password.length() > 0) {
            uriBuilder = uriBuilder.withPassword(password);
        }
        this.uri = uriBuilder.build();
    }

    @Override
    public void onSignal(JrModule sender, Signal signal) {
        if (signal.type == Signal.SignalType.RELOADED) {
            this.needCollect = true;
        }
    }

    @Override
    protected boolean prepareModule() {
        this.firstPass = true;
        this.needCollect = true;
        this.needResetAll = false;
        this.cntUpdatingLast = 0;
        this.cntUpdatingWait = 0;
        this.tagConnected.setBool(false);
        this.tagDisconnectCnt.setInt(0);
        this.tagLastError.setString("");
        this.addAsSignalListerToAllOthers();
        this.createClient();
        return true;
    }

    @Override
    protected boolean closedownModule() {
        this.shutdownClient();
        this.removeAsSignalListerFromAllOthers();
        return true;
    }

    @Override
    protected boolean executeModule() {
        try {
            if (this.connectionCmd == null) {
                this.opened = false;
                if (!this.connect()) {
                    if (this.firstPass) {
                        this.env.printInfo(this.logger, this.name, "No connection");
                    }
                    return false;
                }
            }
            if (!this.connectionCmd.isOpen() && this.opened) {
                this.tagDisconnectCnt.setInt(this.tagDisconnectCnt.getInt() + 1);
                this.opened = false;
                this.tagConnected.setBool(false);
                this.env.printInfo(this.logger, this.name, "Connection lost: " + this.tagDisconnectCnt.getInt());
                return false;
            }
            if (this.connectionCmd.isOpen() && !this.opened) {
                if (!this.firstPass) {
                    this.env.printInfo(this.logger, this.name, "Connection restored");
                }
                this.opened = true;
                this.tagConnected.setBool(true);
                this.collectTags();
                this.deleteKeys();
                this.resetAllValues();
            }
            if (!this.connectionCmd.isOpen()) {
                return false;
            }
            this.collectTags();
            this.processWrites();
            this.processResets();
            this.updateValues();
            this.updateServerTime();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
            this.disconnect();
        }
        this.firstPass = false;
        return true;
    }

    private void updateServerTime() {
        this.asyncCmd.set(this.serverTimeKey, "" + System.currentTimeMillis());
        this.asyncCmd.flushCommands();
    }

    private void createClient() {
        SocketOptions socketOptions = SocketOptions.builder().connectTimeout(Duration.ofSeconds(this.timeoutConn)).keepAlive(true).build();
        ClientOptions clientOptions = ClientOptions.builder().socketOptions(socketOptions).build();
        if (this.redisClient != null) {
            this.shutdownClient();
        }
        this.redisClient = RedisClient.create();
        this.redisClient.setOptions(clientOptions);
    }

    private void shutdownClient() {
        try {
            this.disconnect();
            this.redisClient.shutdown();
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        this.redisClient = null;
        this.connectionCmd = null;
        this.connectionPubSub = null;
    }

    private boolean connect() {
        if (this.connectionCmd != null || this.connectionPubSub != null) {
            this.disconnect();
        }
        try {
            this.connectionCmd = this.redisClient.connect(this.uri);
            this.connectionCmd.setAutoFlushCommands(false);
            this.asyncCmd = this.connectionCmd.async();
            this.connectionPubSub = this.redisClient.connectPubSub(this.uri);
            this.connectionPubSub.addListener(this);
            this.asyncPubSub = this.connectionPubSub.async();
            this.asyncPubSub.subscribe((String[])new String[]{this.channelWrite, this.channelReset});
            return true;
        }
        catch (Exception e) {
            this.tagLastError.setString(e.getLocalizedMessage());
            return false;
        }
    }

    private void disconnect() {
        this.tagConnected.setBool(false);
        try {
            if (this.connectionCmd != null) {
                this.connectionCmd.close();
            }
            this.connectionCmd = null;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
        try {
            if (this.connectionPubSub != null) {
                this.connectionPubSub.close();
            }
            this.connectionPubSub = null;
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
    }

    private String getModuleTagname(JrModule module, Tag tag) {
        return tag.hasFlags(4) ? tag.getName() : module.getName() + "." + tag.getName();
    }

    private void collectTags() {
        Pattern pfilter;
        if (!this.needCollect) {
            return;
        }
        this.needCollect = false;
        this.etags.values().forEach(etag -> {
            etag.relevant = false;
        });
        this.filter = this.filter.trim().isEmpty() ? ".*" : this.filter;
        try {
            pfilter = Pattern.compile(this.filter);
        }
        catch (PatternSyntaxException e) {
            this.env.printError(this.logger, this.name, "Bad filter: " + this.filter + ", changed to .*");
            this.filter = ".*";
            pfilter = Pattern.compile(".*");
        }
        long cntAdd = 0L;
        for (JrModule m : this.env.getModuleManager().getModules()) {
            for (Tag tag : m.getTagTable().values()) {
                String tagname = this.getModuleTagname(m, tag);
                if (!pfilter.matcher(tagname).matches()) continue;
                ExportTag etag2 = this.etags.get(tagname);
                if (etag2 == null) {
                    etag2 = new ExportTag(tagname, tag);
                    this.etags.put(tagname, etag2);
                    ++cntAdd;
                }
                etag2.relevant = true;
            }
        }
        long cntDel = this.etags.values().stream().filter(etag -> !etag.relevant).count();
        if (cntDel > 0L) {
            this.etags.forEach((key, etag) -> {
                if (!etag.relevant) {
                    this.deleteKey((String)key);
                }
            });
            this.asyncCmd.flushCommands();
            this.etags.entrySet().removeIf(entry -> !((ExportTag)entry.getValue()).relevant);
        }
        if (cntAdd + cntDel > 0L) {
            this.env.printInfo(this.logger, this.name, "Collected tags: " + (String)(cntAdd > 0L ? cntAdd + " added" : "") + (String)(cntDel > 0L ? cntDel + " deleted" : ""));
        }
    }

    private RedisFuture<Long> deleteKey(String key) {
        this.asyncCmd.publish(this.channelDelete, TagInfoCodec.encodeMessageDelete(key, System.currentTimeMillis()));
        return this.asyncCmd.hdel(this.tagsKey, (String[])new String[]{key});
    }

    private void deleteKeys() {
        if (this.noScanDelete) {
            return;
        }
        try {
            this.env.printInfo(this.logger, this.name, "Scanning existing keys...");
            long t1 = System.currentTimeMillis();
            ArrayList futures = new ArrayList();
            KeyValueStreamingChannel<String, String> channel = (key, value) -> {
                if (!this.etags.containsKey(key)) {
                    futures.add(this.deleteKey((String)key));
                }
            };
            ScanArgs args = ScanArgs.Builder.limit(100000L);
            RedisFuture<StreamScanCursor> scanFuture = this.asyncCmd.hscan(channel, this.tagsKey, args);
            while (true) {
                StreamScanCursor cursor;
                this.asyncCmd.flushCommands();
                boolean scanOk = scanFuture.await(this.timeoutCmd, TimeUnit.SECONDS);
                long t2 = System.currentTimeMillis();
                if (scanOk) {
                    cursor = (StreamScanCursor)scanFuture.get();
                    this.env.printInfo(this.logger, this.name, String.format("Scanned %d keys in %d ms", cursor.getCount(), t2 - t1));
                } else {
                    cursor = null;
                    this.env.printInfo(this.logger, this.name, "Scan timeout!");
                }
                if (futures.size() > 0) {
                    this.env.printInfo(this.logger, this.name, String.format("Deleting %d keys...", futures.size()));
                    t1 = System.currentTimeMillis();
                    this.asyncCmd.flushCommands();
                    boolean delOk = LettuceFutures.awaitAll(this.timeoutCmd, TimeUnit.SECONDS, (Future[])futures.toArray(new RedisFuture[0]));
                    t2 = System.currentTimeMillis();
                    this.env.printInfo(this.logger, this.name, String.format("Deleted %d keys in %d ms %s", futures.size(), t2 - t1, delOk ? "" : "with timeout!"));
                }
                if (this.asyncCmd.isOpen() && cursor != null && !cursor.isFinished()) {
                    this.env.printInfo(this.logger, this.name, "Continue scanning existing keys...");
                    futures.clear();
                    scanFuture = this.asyncCmd.hscan(channel, this.tagsKey, cursor, args);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.env.printError(this.logger, e, this.name);
        }
    }

    private void updateValues() {
        this.cntWait = 0;
        this.cntLast = 0;
        int timeout = this.timeoutCmd * 1000;
        long now = System.currentTimeMillis();
        this.etags.forEach((key, etag) -> {
            if (etag.state == ExportTag.State.HAS_FUTURE) {
                if (etag.future.isDone()) {
                    etag.state = ExportTag.State.IDLE;
                } else if (etag.future.isCancelled()) {
                    etag.state = ExportTag.State.NEED_SET;
                } else if (now - etag.timeSet > (long)timeout) {
                    etag.future.cancel(true);
                    etag.state = ExportTag.State.NEED_SET;
                    if (this.opened) {
                        this.env.printInfo(this.logger, this.name, String.format("Update timeout: %s = %s", key, etag.curval.getString()));
                    }
                }
            }
            if (etag.state == ExportTag.State.IDLE && etag.isOutdated()) {
                etag.state = ExportTag.State.NEED_SET;
            }
            if (etag.state == ExportTag.State.NEED_SET) {
                etag.update();
                etag.future = this.asyncCmd.hset(this.tagsKey, (String)key, etag.getEncodedData());
                etag.timeSet = now;
                etag.state = ExportTag.State.HAS_FUTURE;
                this.asyncCmd.publish(this.channelUpdate, etag.getEncodedMessageUpdate());
                ++this.cntLast;
            }
            if (etag.state == ExportTag.State.HAS_FUTURE) {
                ++this.cntWait;
            }
        });
        if (this.cntLast > 0) {
            this.asyncCmd.flushCommands();
            this.cntUpdatingLast = this.cntLast;
        }
        if (this.cntWait > 0) {
            this.cntUpdatingWait = this.cntWait;
        }
    }

    private void processWrites() {
        this.processMessages(this.queueWrites, this.cntWrites, this::writeValue);
    }

    private void writeValue(String message) {
        ExportTag etag;
        TagInfo info2 = TagInfoCodec.decodeMessageWrite(message);
        if (info2 != null && (etag = this.etags.get(info2.name)) != null) {
            etag.tag.setString(info2.value);
        }
    }

    private void processResets() {
        if (this.needResetAll) {
            this.resetAllValues();
            this.needResetAll = false;
            this.queueResets.clear();
            this.env.printInfo(this.logger, this.name, "Requested to RESET ALL!");
        } else {
            this.processMessages(this.queueResets, this.cntResets, this::resetValue);
        }
    }

    private void resetAllValues() {
        this.etags.values().forEach(etag -> {
            if (etag.state == ExportTag.State.HAS_FUTURE) {
                etag.future.cancel(true);
            }
            etag.state = ExportTag.State.NEED_SET;
        });
    }

    private void resetValue(String key) {
        ExportTag etag = this.etags.get(key);
        if (etag != null) {
            if (etag.state == ExportTag.State.HAS_FUTURE) {
                etag.future.cancel(true);
            }
            etag.state = ExportTag.State.NEED_SET;
        }
    }

    private void offerMessage(String message, Queue<String> queue, AtomicInteger counter) {
        if (counter.get() < 1000000) {
            queue.offer(message);
            counter.incrementAndGet();
        }
    }

    private String pollMessage(Queue<String> queue, AtomicInteger counter) {
        String message = queue.poll();
        if (message != null) {
            counter.decrementAndGet();
        }
        return message;
    }

    private void processMessages(Queue<String> queue, AtomicInteger counter, Consumer<String> handler) {
        while (counter.get() > 0) {
            String message = this.pollMessage(queue, counter);
            if (message == null) continue;
            handler.accept(message);
        }
    }

    @Override
    public void message(String channel, String message) {
        if (channel.equals(this.channelWrite)) {
            if (!this.readonly) {
                this.offerMessage(message, this.queueWrites, this.cntWrites);
            }
        } else if (channel.equals(this.channelReset)) {
            if (message.isEmpty()) {
                this.needResetAll = true;
            } else {
                this.offerMessage(message, this.queueResets, this.cntResets);
            }
        }
    }

    @Override
    public void message(String pattern, String channel, String message) {
    }

    @Override
    public void subscribed(String channel, long count) {
    }

    @Override
    public void psubscribed(String pattern, long count) {
    }

    @Override
    public void unsubscribed(String channel, long count) {
    }

    @Override
    public void punsubscribed(String pattern, long count) {
    }

    @Override
    public String getInfo() {
        return !this.enable ? "disabled" : String.format("%s%s%s filter=%s%s%s, tags=%d, %sset/wait=%d/%d write=%d%s", !this.tagConnected.getBool() ? "\u001b[31m\u001b[01mERROR! \u001b[0m" : "", this.uri.toString(), this.descr.isEmpty() ? "" : " " + this.descr, this.filter, this.readonly ? " RO" : "", this.ssl ? " SSL" : "", this.etags.size(), "\u001b[32m", this.cntUpdatingLast, this.cntUpdatingWait, this.cntWrites.get(), "\u001b[0m");
    }

    @Override
    protected boolean reload() {
        this.closedownModule();
        this.load();
        this.prepareModule();
        return true;
    }
}

