/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.Environment;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.RoboplantModule;

public class ConnectManager {
    private final State state = new State();
    private State backup = null;
    private Environment env;

    public ConnectManager(Environment env) {
        this.env = env;
    }

    public boolean loadConnectors(RoboplantModule _module, Object conf) {
        boolean result = true;
        this.removeConnectors(_module);
        Configuration cm = this.env.getConfiguration();
        Map<String, Object> conf_connect = cm.toMap(cm.get(conf, "connect"));
        for (Map.Entry<String, Object> ent : conf_connect.entrySet()) {
            String devicename = _module.getName() + ":" + ent.getKey();
            String modulename = ent.getValue().toString();
            if (modulename.equals("---")) {
                this.state.notConnectedModuleNames.add(devicename);
            }
            this.state.deviceModule.put(devicename, modulename);
        }
        if (conf_connect.size() > 0 || this.state.notConnectedModuleNames.size() > 0) {
            this.state.roboplantModules.add(_module);
        }
        return result;
    }

    public void removeConnectors(RoboplantModule roboplantModule) {
        if (this.state.roboplantModules.contains(roboplantModule)) {
            String modname = roboplantModule.getName() + ":";
            this.state.deviceModule.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(modname));
            this.state.notConnectedModuleNames.removeIf(devmodname -> devmodname.startsWith(modname));
            this.state.roboplantModules.remove(roboplantModule);
        }
    }

    public JrModule getConnectedModule(RoboplantModule module, Device device) {
        String modulename = this.state.deviceModule.get(module.getName() + ":" + device.devtype + "." + device.tagname);
        if (modulename == null) {
            return null;
        }
        return this.env.getModuleManager().getModule(modulename);
    }

    public void replaceModule(RoboplantModule targetModule, RoboplantModule newModule) {
        if (this.state.roboplantModules.remove(targetModule)) {
            this.state.roboplantModules.add(newModule);
        }
    }

    public boolean isNotConnected(RoboplantModule module, Device device) {
        return this.state.notConnectedModuleNames.contains(module.getName() + ":" + device.devtype + "." + device.tagname);
    }

    public void backupState() {
        this.backup = new State();
        this.backup.deviceModule.putAll(this.state.deviceModule);
        this.backup.roboplantModules.addAll(this.state.roboplantModules);
        this.backup.notConnectedModuleNames.addAll(this.state.notConnectedModuleNames);
    }

    public void restoreState() {
        if (this.backup == null) {
            return;
        }
        this.state.deviceModule.clear();
        this.state.roboplantModules.clear();
        this.state.notConnectedModuleNames.clear();
        this.state.deviceModule = this.backup.deviceModule;
        this.state.roboplantModules = this.backup.roboplantModules;
        this.state.notConnectedModuleNames = this.backup.notConnectedModuleNames;
        this.backup = null;
    }

    public void resetState() {
        this.backup.deviceModule.clear();
        this.backup.roboplantModules.clear();
        this.backup.notConnectedModuleNames.clear();
        this.backup = null;
    }

    public static class State {
        public Map<String, String> deviceModule = new HashMap<String, String>();
        public Set<RoboplantModule> roboplantModules = new HashSet<RoboplantModule>();
        public Set<String> notConnectedModuleNames = new HashSet<String>();
    }
}

