/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.RoboplantPlugin;

public class Connector {
    private static final int BIND_STATUS_OK = 0;
    private static final int BIND_MODULE_NOT_FOUND = -1;
    private final Device device;
    private final JrModule bindmod;
    private final List<Link> links = new LinkedList<Link>();
    private final Map<Tag, Link> linksMap = new HashMap<Tag, Link>();
    private Tag tagBindStatus;

    public Connector(Device _device) {
        RoboplantPlugin plugin = (RoboplantPlugin)_device.module.getPlugin();
        this.device = _device;
        this.bindmod = plugin.getConnectManager().getConnectedModule(_device.module, _device);
        String bindtagname = _device.devtype + "_" + _device.tagname + "_BindStatus";
        this.tagBindStatus = this.device.module.getTagTable().get(bindtagname);
        if (this.tagBindStatus == null) {
            this.tagBindStatus = this.device.module.getTagTable().createInt(bindtagname, 0);
        } else {
            this.tagBindStatus.setInt(0);
        }
        if (this.bindmod == null) {
            if (plugin.getConnectManager().isNotConnected(_device.module, _device)) {
                this.tagBindStatus.setInt(0);
            } else {
                this.tagBindStatus.setInt(-1);
            }
        }
    }

    public JrModule getBindmod() {
        return this.bindmod;
    }

    public boolean connect(String _deviceOutputName, String _tagnameBind, Mode _mode, Device.RefBool _res) {
        if (this.device == null || this.bindmod == null) {
            return false;
        }
        Tag tagOwn = this.device.getOutputTag(_deviceOutputName, _res);
        if (tagOwn == null) {
            return false;
        }
        Link link = new Link();
        link.tagOwn = tagOwn;
        link.tagBind = this.bindmod.getTagTable().get(_tagnameBind);
        link.tagnameBind = _tagnameBind;
        link.mode = _mode;
        this.links.add(link);
        this.linksMap.put(tagOwn, link);
        return true;
    }

    public Tag getTagBind(Tag tag) {
        Link link = this.linksMap.get(tag);
        if (link != null) {
            return link.tagBind;
        }
        return null;
    }

    public boolean execute() {
        if (this.links.size() == 0) {
            return true;
        }
        int errcnt = 0;
        for (Link link : this.links) {
            if (link.tagBind == null || link.tagBind.getStatus() == Tag.Status.Deleted) {
                link.tagBind = this.bindmod.getTagTable().get(link.tagnameBind);
                if (link.tagBind != null) continue;
                ++errcnt;
                continue;
            }
            if (link.tagBind.equalsValue(link.tagOwn)) continue;
            if (link.mode == Mode.READ) {
                link.tagBind.copyValueTo(link.tagOwn);
                continue;
            }
            if (link.mode != Mode.WRITE) continue;
            link.tagOwn.copyValueTo(link.tagBind);
        }
        if (this.tagBindStatus.getInt() != errcnt) {
            this.tagBindStatus.setInt(errcnt);
        }
        return true;
    }

    public String checkErrors() {
        if (this.tagBindStatus.getInt() == 0) {
            return "";
        }
        if (this.tagBindStatus.getInt() == -1 || this.bindmod == null) {
            return "Connection module not found";
        }
        StringBuilder res = new StringBuilder();
        for (Link link : this.links) {
            if (link.tagBind != null && link.tagBind.getStatus() != Tag.Status.Deleted) continue;
            res.append("\r\n    ").append(link.tagOwn.getName()).append(link.mode == Mode.READ ? " <- " : "").append(link.mode == Mode.WRITE ? " -> " : "").append(link.mode == Mode.MANUAL ? " -- " : "").append(this.bindmod.getName()).append(":").append(link.tagnameBind);
        }
        return res.toString();
    }

    public static class Link {
        Tag tagOwn;
        Tag tagBind;
        String tagnameBind;
        Mode mode;
    }

    public static enum Mode {
        READ,
        WRITE,
        MANUAL;

    }
}

