/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.State;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.TagPlain;
import promauto.jroboplc.plugin.roboplant.Channel;
import promauto.jroboplc.plugin.roboplant.Comp;
import promauto.jroboplc.plugin.roboplant.Input;
import promauto.jroboplc.plugin.roboplant.Output;
import promauto.jroboplc.plugin.roboplant.RoboplantModule;

public class Device
implements Comparable<Device> {
    protected final Logger logger = LoggerFactory.getLogger(Device.class);
    private static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
    RoboplantModule module;
    public String devtype;
    public String tagname;
    public String name;
    public int addr;
    public int order;
    protected List<Input> inputs = new LinkedList<Input>();
    protected List<Output> outputs = new LinkedList<Output>();
    protected List<Output> outputsByNum = new LinkedList<Output>();

    public Input getInput(String searchName) {
        int i = Collections.binarySearch(this.inputs, new Input(searchName));
        return i < 0 ? null : this.inputs.get(i);
    }

    public Output getOutput(String searchName) {
        int i = Collections.binarySearch(this.outputs, new Output(searchName));
        return i < 0 ? null : this.outputs.get(i);
    }

    public Output getOutput(int searchNum) {
        int i = Collections.binarySearch(this.outputsByNum, new Output(searchNum), Output.CmpNum.get());
        return i < 0 ? null : this.outputsByNum.get(i);
    }

    public Input getInput(String searchName, RefBool res) {
        Input input = this.getInput(searchName);
        return this.checkres(input, res, searchName) ? input : null;
    }

    public Tag getOutputTag(String searchName, RefBool res) {
        Output output = this.getOutput(searchName);
        return this.checkres(output, res, searchName) ? output.tag : null;
    }

    public Tag getOutputTag(int searchNum, RefBool res) {
        Output output = this.getOutput(searchNum);
        return this.checkres(output, res, searchNum) ? output.tag : null;
    }

    public Tag getOutputTagOrFake(String searchName) {
        Output output = this.getOutput(searchName);
        return output == null ? TagPlain.create(Tag.Type.INT, searchName) : output.tag;
    }

    public boolean checkres(Comp comp, RefBool res, Object obj) {
        if (comp == null) {
            if (res.value) {
                EnvironmentInst.get().printError(this.logger, this.module.getName(), String.format("DeviceBase component doesn't exist (addr.name.comp): %04X.%s.%s%n", this.addr, this.name, obj.toString()));
                res.value = false;
            }
            return false;
        }
        return true;
    }

    protected void sortInputOutputArrays() {
        this.inputs = new ArrayList<Input>(this.inputs);
        this.outputs = new ArrayList<Output>(this.outputs);
        this.outputsByNum = new ArrayList<Output>(this.outputs);
        Collections.sort(this.inputs);
        Collections.sort(this.outputs);
        Collections.sort(this.outputsByNum, Output.CmpNum.get());
    }

    @Override
    public int compareTo(Device o) {
        return this.order - o.order;
    }

    public void setAttribute(String attrName, String value) {
        switch (attrName) {
            case "DevType": {
                this.devtype = value;
                break;
            }
            case "TagName": {
                this.tagname = value;
                break;
            }
            case "Name": {
                this.name = value;
                break;
            }
            case "Addr": {
                this.addr = Integer.parseInt(value, 16);
                break;
            }
            case "Order": {
                this.order = Integer.parseInt(value, 16);
            }
        }
    }

    public Comp addComp(boolean isInp) {
        if (isInp) {
            Input input = new Input();
            this.inputs.add(input);
            return input;
        }
        Output output = new Output();
        this.outputs.add(output);
        return output;
    }

    public boolean init(RoboplantModule module) {
        this.module = module;
        this.correctTagname();
        this.createTagForEachOutputs();
        this.createTagForConstAndEmptyInputs();
        this.sortInputOutputArrays();
        return true;
    }

    private void correctTagname() {
        this.tagname = this.tagname == null ? String.format("T%04X", this.addr) : this.correctTagnameText(this.tagname);
        if (!asciiEncoder.canEncode(this.tagname)) {
            EnvironmentInst.get().printError(this.logger, this.module.getName(), String.format("None ascii tagname: '%s', device: %04X", this.tagname, this.addr));
        }
    }

    private String correctTagnameText(String s) {
        if (s.contains(" ")) {
            s = s.replace(" ", "_");
        }
        if (s.contains(".")) {
            s = s.replace(".", "_");
        }
        if (s.contains(":")) {
            s = s.replace(":", "_");
        }
        return s;
    }

    protected void createTagForEachOutputs() {
        String s1 = this.devtype + "_" + this.tagname + "_";
        for (Output output : this.outputs) {
            if (output.tag != null) continue;
            int i = 1;
            String s2 = this.correctTagnameText(s1 + output.name);
            Object sname = s2;
            while (this.module.getTagTable().get((String)sname) != null) {
                sname = s2 + "_" + i++;
            }
            output.tag = this.module.getTagTable().createTag(output.type, (String)sname);
            if (output.tag == null) continue;
            if (output.value == null) {
                output.tag.setInt(output.inival);
            } else {
                output.tag.setString(output.value);
            }
            if (output.saveable) {
                output.tag.addFlag(1);
            }
            if (output.istag) continue;
            output.tag.addFlag(2);
        }
    }

    private void createTagForConstAndEmptyInputs() {
        String s = this.devtype + "_" + this.tagname + "@";
        int i = 0;
        for (Input input : this.inputs) {
            if (input.isConst()) {
                input.isTagOwner = true;
                input.invertor = false;
                input.tag = this.module.getTagTable().createTag(input.type, s + input.name + "_" + i);
                input.tag.setInt(input.refaddr == 28672 ? 0 : input.refnum);
                input.tag.addFlag(2);
            }
            ++i;
        }
    }

    public boolean prepare() {
        String s = this.devtype + "_" + this.tagname + "@BADREF_";
        Output output = null;
        for (Input input : this.inputs) {
            if (input.isConst()) continue;
            Device dev = this.module.getDevice(input.refaddr);
            Output output2 = output = dev == null ? null : dev.getOutput(input.refnum);
            if (output == null) {
                input.isTagOwner = true;
                input.tag = this.module.getTagTable().createTag(input.type, s + input.name);
                continue;
            }
            input.isTagOwner = false;
            input.tag = output.tag;
        }
        RefBool res = new RefBool(true);
        this.prepareTags(res);
        return res.value;
    }

    protected void prepareTags(RefBool res) {
    }

    protected void registerAsChannelProvider(String outputNameAddr, Channel.Type type, RefBool res) {
        this.module.getChannelManager().registerChannelProvider(this, this.getOutputTag(outputNameAddr, res), type);
    }

    protected Channel createChannel(String outputName, Channel.Type type, RefBool res) {
        return this.module.getChannelManager().createChannel(this.getOutputTag(outputName, res), type);
    }

    public boolean execute() {
        System.out.println(this.devtype + " not implemented: " + this.name);
        return true;
    }

    public final void saveState(State state) {
        state.setVarPrefix(this.getVarPrefix());
        for (Output out : this.outputs) {
            state.saveTag(out.tag);
        }
        this.saveStateExtra(state);
    }

    public void saveStateExtra(State state) {
    }

    public final void loadState(State state) {
        state.setVarPrefix(this.getVarPrefix());
        for (Output out : this.outputs) {
            state.loadTag(out.tag);
        }
        this.loadStateExtra(state);
    }

    public void loadStateExtra(State state) {
    }

    private String getVarPrefix() {
        return "$" + this.devtype + "_" + this.tagname + "_";
    }

    public String checkErrors() {
        return "";
    }

    protected final void createTagDescr() {
        if (this.module.isUseDescr()) {
            String tagnameDescr = this.devtype + "_" + this.tagname + ".descr";
            this.module.getTagTable().createRWString(tagnameDescr, this.name, this.module.getDescrFlags());
        }
    }

    public static class RefBool {
        public boolean value;

        public RefBool(boolean value) {
            this.value = value;
        }
    }
}

