/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.roboplant;

import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.plugin.roboplant.ConnectDevice;
import promauto.jroboplc.plugin.roboplant.Connector;
import promauto.jroboplc.plugin.roboplant.Device;
import promauto.jroboplc.plugin.roboplant.Input;

public class DeviceGLSA
extends ConnectDevice {
    Input inpInput;
    Input inpSuspend;
    Input inpAlarmEnable;
    Tag tagSetCmd;
    Tag tagSost;
    Tag tagAlarm;
    Tag tagState;
    Tag tagControl;
    Tag tagSuspend;
    Tag tagBlok;

    @Override
    public void prepareTags(Device.RefBool res) {
        this.connector.connect("State", "State", Connector.Mode.READ, res);
        this.connector.connect("SetCmd", "SetCmd", Connector.Mode.WRITE, res);
        this.inpInput = this.getInput("Input", res);
        this.inpSuspend = this.getInput("Suspend", res);
        this.inpAlarmEnable = this.getInput("AlarmEnable", res);
        this.tagSetCmd = this.getOutputTag("SetCmd", res);
        this.tagSost = this.getOutputTag("Sost", res);
        this.tagAlarm = this.getOutputTag("Alarm", res);
        this.tagState = this.getOutputTag("State", res);
        this.tagControl = this.getOutputTag("Control", res);
        this.tagSuspend = this.getOutputTag("Suspend", res);
        this.tagBlok = this.getOutputTag("Blok", res);
    }

    @Override
    public boolean execute() {
        boolean state_alm;
        boolean state_off;
        boolean state_on;
        boolean susp;
        super.execute();
        int flags = this.tagBlok.getInt();
        boolean inp = this.inpInput.getInt() > 0;
        boolean bl = susp = this.inpSuspend.getInt() > 0 || this.tagSuspend.getBool();
        if ((flags & 0xF0) == 0) {
            state_on = (this.tagState.getInt() & 0x2E) > 0;
            state_off = (this.tagState.getInt() & 1) > 0;
            state_alm = (this.tagState.getInt() & 0x40) > 0;
        } else {
            state_on = this.tagState.getInt() == 1;
            state_off = this.tagState.getInt() == 0;
            state_alm = this.tagState.getInt() == 2;
        }
        boolean control_stop = false;
        this.tagAlarm.setBool(state_alm && (flags & 1) == 0 && this.inpAlarmEnable.getInt() > 0);
        if ((this.tagControl.getInt() & 1) > 0) {
            inp = (this.tagControl.getInt() & 2) > 0;
            boolean bl2 = control_stop = !inp;
        }
        if (susp) {
            inp = false;
        }
        if (state_alm) {
            this.tagSetCmd.setInt(control_stop ? 2 : 0);
        } else if (!inp && !state_off) {
            this.tagSetCmd.setInt(2);
        } else if (inp && !state_on) {
            this.tagSetCmd.setInt(1);
        } else {
            this.tagSetCmd.setInt(0);
        }
        int sost = this.tagSost.getInt();
        sost = state_alm ? 4 : (this.tagSetCmd.getInt() == 1 ? 2 : (this.tagSetCmd.getInt() == 2 ? 3 : (state_on ? 1 : (susp && state_off ? 5 : (state_off ? 0 : 6)))));
        this.tagSost.setInt(sost);
        return true;
    }
}

