/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parsii.eval.Expression;
import parsii.eval.Function;
import parsii.eval.Parser;
import parsii.eval.Scope;
import parsii.eval.Variable;
import parsii.tokenizer.ParseException;
import promauto.jroboplc.core.api.Configuration;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.Tag;
import promauto.jroboplc.core.tags.Ref;
import promauto.jroboplc.plugin.script.Action;
import promauto.jroboplc.plugin.script.ScriptModule;

public class ActionCalc
extends Action {
    private final Logger logger = LoggerFactory.getLogger(ActionCalc.class);
    protected Expr expr;
    private double lastExprResult = 0.0;
    private boolean hasExprResult = false;
    protected Ref rslt = EnvironmentInst.get().getRefFactory().createRef();
    protected List<Argument> args = new LinkedList<Argument>();
    private ScriptModule module;

    public static void loadExprs(Object conf, Map<String, Expr> calcexprs) throws ParseException {
        Configuration cm = EnvironmentInst.get().getConfiguration();
        Map<String, Object> conf_calcexpr = cm.toMap(cm.get(conf, "calcexpr"));
        for (Map.Entry<String, Object> ent : conf_calcexpr.entrySet()) {
            Expr expr = new Expr(ent.getValue().toString());
            calcexprs.put(ent.getKey().toString(), expr);
        }
    }

    public ActionCalc(ScriptModule module) {
        this.module = module;
    }

    @Override
    public boolean load(Object conf) {
        super.load(conf);
        Configuration cm = EnvironmentInst.get().getConfiguration();
        String calc = cm.get(conf, "expr", "");
        this.expr = this.module.getCalcExpr(calc);
        if (this.expr == null) {
            try {
                this.expr = new Expr(calc);
            }
            catch (ParseException e) {
                EnvironmentInst.get().printError(this.logger, e, this.module.getName(), this.getId(), "calc:", calc);
                return false;
            }
        }
        if (!this.rslt.init(conf, "result", this.module)) {
            return false;
        }
        if (this.rslt.getRefModuleName().equals(this.module.getName()) && this.module.getTagTable().get(this.rslt.getRefTagName()) == null) {
            this.module.getTagTable().createDouble(this.rslt.getRefTagName(), 0.0);
        }
        Set<String> varnames = this.expr.scope.getLocalNames();
        for (String varname : varnames) {
            Argument arg = new Argument(varname, this.expr.scope);
            if (!arg.ref.init(conf, varname, this.module)) {
                return false;
            }
            this.args.add(arg);
        }
        return true;
    }

    @Override
    public boolean prepare() {
        this.lastExprResult = 0.0;
        this.hasExprResult = false;
        if (!this.rslt.prepare()) {
            return false;
        }
        this.rslt.link();
        for (Argument arg : this.args) {
            if (arg.ref.prepare()) {
                arg.ref.link();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        if (!this.rslt.linkIfNotValid()) {
            return;
        }
        for (Argument arg : this.args) {
            if (!arg.ref.linkIfNotValid()) {
                return;
            }
            if (arg.value == arg.ref.getTag().getDouble()) continue;
            arg.value = arg.ref.getTag().getDouble();
            this.hasExprResult = false;
        }
        if (this.hasExprResult) {
            if (this.rslt.getTag().getDouble() != this.lastExprResult) {
                this.updateResult();
            }
            return;
        }
        for (Argument arg : this.args) {
            arg.var.setValue(arg.value);
        }
        try {
            this.lastExprResult = this.expr.expr.evaluate();
        }
        catch (Exception e) {
            EnvironmentInst.get().printError(this.logger, e, this.module.getName(), this.getId());
        }
        Tag.Type rsltType = this.rslt.getTag().getType();
        if (rsltType != Tag.Type.DOUBLE) {
            if (rsltType == Tag.Type.INT) {
                this.lastExprResult = (int)this.lastExprResult;
            } else if (rsltType == Tag.Type.LONG) {
                this.lastExprResult = (long)this.lastExprResult;
            } else if (rsltType == Tag.Type.BOOL) {
                this.lastExprResult = this.lastExprResult != 0.0 ? 1.0 : 0.0;
            }
        }
        this.hasExprResult = true;
        this.updateResult();
    }

    private void updateResult() {
        if (this.delay_ms > 0L) {
            if (this.timeDelay == 0L) {
                this.timeDelay = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.timeDelay > this.delay_ms) {
                this.rslt.getTag().setDouble(this.lastExprResult);
                this.timeDelay = 0L;
            }
        } else {
            this.rslt.getTag().setDouble(this.lastExprResult);
        }
    }

    @Override
    public boolean isValid() {
        if (!this.rslt.isValid()) {
            return false;
        }
        for (Argument arg : this.args) {
            if (arg.ref.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getError() {
        String res = "calc " + this.getId() + ": ";
        if (!this.rslt.isValid()) {
            res = "result=" + this.rslt.getName() + " ";
        }
        for (Argument arg : this.args) {
            if (arg.ref.isValid()) continue;
            res = res + arg.var.getName() + "=" + arg.ref.getName() + " ";
        }
        return res;
    }

    static {
        Parser.registerFunction("AND", new FunctionAND());
        Parser.registerFunction("OR", new FunctionOR());
    }

    public static class Expr {
        public Scope scope = new Scope();
        public Expression expr;

        public Expr(String expr) throws ParseException {
            this.expr = Parser.parse(expr, this.scope);
        }
    }

    protected static class Argument {
        Ref ref = EnvironmentInst.get().getRefFactory().createRef();
        Variable var;
        double value;

        public Argument(String nameVar, Scope scope) {
            this.var = scope.getVariable(nameVar);
        }
    }

    public static class FunctionAND
    implements Function {
        @Override
        public int getNumberOfArguments() {
            return 2;
        }

        @Override
        public double eval(List<Expression> args) {
            return (int)args.get(0).evaluate() & (int)args.get(1).evaluate();
        }

        @Override
        public boolean isNaturalFunction() {
            return true;
        }
    }

    public static class FunctionOR
    implements Function {
        @Override
        public int getNumberOfArguments() {
            return 2;
        }

        @Override
        public double eval(List<Expression> args) {
            return (int)args.get(0).evaluate() | (int)args.get(1).evaluate();
        }

        @Override
        public boolean isNaturalFunction() {
            return true;
        }
    }
}

