/*
 * Decompiled with CFR 0.152.
 */
package promauto.jroboplc.plugin.script;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import promauto.jroboplc.core.AbstractCommand;
import promauto.jroboplc.core.api.Console;
import promauto.jroboplc.core.api.EnvironmentInst;
import promauto.jroboplc.core.api.JrModule;
import promauto.jroboplc.core.api.Plugin;
import promauto.jroboplc.plugin.script.ScriptModule;

public class CmdCheck
extends AbstractCommand {
    final Logger logger = LoggerFactory.getLogger(CmdCheck.class);

    @Override
    public String getName() {
        return "check";
    }

    @Override
    public String getUsage() {
        return "[mod ...]";
    }

    @Override
    public String getDescription() {
        return "checks and shows errors";
    }

    @Override
    public String execute(Console console, Plugin plugin, String args) {
        Set<JrModule> mods = EnvironmentInst.get().getModuleManager().getModules();
        Pattern pattern = null;
        try {
            if (!args.isEmpty()) {
                pattern = Pattern.compile(args);
            }
        }
        catch (PatternSyntaxException e) {
            EnvironmentInst.get().printError(this.logger, e, "Bad regex:", args);
        }
        int total = 0;
        int badcnt = 0;
        StringBuilder sb = new StringBuilder();
        for (JrModule mod : mods) {
            if (!mod.isEnabled() || !(mod instanceof ScriptModule) || pattern != null && !pattern.matcher(mod.getName()).matches()) continue;
            ++total;
            ScriptModule sm = (ScriptModule)mod;
            String errors = sm.getErrors();
            if (errors.isEmpty()) continue;
            ++badcnt;
            sb.append("\u001b[01m");
            sb.append(mod.getName());
            sb.append(":\r\n");
            sb.append("\u001b[0m");
            sb.append(errors);
            sb.append("\r\n");
        }
        sb.append("Checked modules: ");
        sb.append("\u001b[01m");
        sb.append(total + "\r\n");
        sb.append("\u001b[0m");
        if (badcnt > 0) {
            sb.append("\u001b[31m");
            sb.append("Modules with errors: ");
            sb.append("\u001b[01m");
            sb.append(badcnt + "\r\n");
            sb.append("\u001b[0m");
        } else {
            sb.append("OK!");
        }
        return sb.toString();
    }
}

